/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.encrypt;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDoneException;
import android.database.sqlite.SQLiteStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.named_data.jndn.Name;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encoding.TlvWireFormat;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.encrypt.GroupManagerDb;
import net.named_data.jndn.encrypt.Schedule;
import net.named_data.jndn.encrypt.Sqlite3GroupManagerDbBase;
import net.named_data.jndn.util.Blob;

public class AndroidSqlite3GroupManagerDb
extends Sqlite3GroupManagerDbBase {
    private final SQLiteDatabase database_;
    Map<Name, Blob> privateKeyBase_ = new HashMap<Name, Blob>();

    public AndroidSqlite3GroupManagerDb(String databaseFilePath) {
        this.database_ = SQLiteDatabase.openDatabase((String)databaseFilePath, null, (int)0x10000000);
        this.database_.execSQL("CREATE TABLE IF NOT EXISTS                         \n  schedules(                                       \n    schedule_id         INTEGER PRIMARY KEY,       \n    schedule_name       TEXT NOT NULL,             \n    schedule            BLOB NOT NULL              \n  );                                               \n");
        this.database_.execSQL("CREATE UNIQUE INDEX IF NOT EXISTS                  \n   scheduleNameIndex ON schedules(schedule_name);  \n");
        this.database_.execSQL("CREATE TABLE IF NOT EXISTS                         \n  members(                                         \n    member_id           INTEGER PRIMARY KEY,       \n    schedule_id         INTEGER NOT NULL,          \n    member_name         BLOB NOT NULL,             \n    key_name            BLOB NOT NULL,             \n    pubkey              BLOB NOT NULL              \n  );                                               \n");
        this.database_.execSQL("CREATE UNIQUE INDEX IF NOT EXISTS                  \n   memNameIndex ON members(member_name);           \n");
        this.database_.execSQL("CREATE TABLE IF NOT EXISTS                         \n  ekeys(                                           \n    ekey_id             INTEGER PRIMARY KEY,       \n    ekey_name           BLOB NOT NULL,             \n    pub_key             BLOB NOT NULL              \n  );                                               \n");
        this.database_.execSQL("CREATE UNIQUE INDEX IF NOT EXISTS                  \n   ekeyNameIndex ON ekeys(ekey_name);              \n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasSchedule(String name) throws GroupManagerDb.Error {
        try (Cursor cursor = this.database_.rawQuery("SELECT schedule_id FROM schedules where schedule_name=?", new String[]{name});){
            if (cursor.moveToNext()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public List listAllScheduleNames() throws GroupManagerDb.Error {
        ArrayList<String> list = new ArrayList<String>();
        try (Cursor cursor = this.database_.rawQuery("SELECT schedule_name FROM schedules", new String[0]);){
            while (cursor.moveToNext()) {
                list.add(cursor.getString(0));
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Schedule getSchedule(String name) throws GroupManagerDb.Error {
        Schedule schedule;
        block6: {
            schedule = new Schedule();
            try (Cursor cursor = this.database_.rawQuery("SELECT schedule FROM schedules WHERE schedule_name=?", new String[]{name});){
                if (cursor.moveToNext()) {
                    try {
                        schedule.wireDecode(new Blob(cursor.getBlob(0)));
                        break block6;
                    }
                    catch (EncodingException ex) {
                        throw new GroupManagerDb.Error("AndroidSqlite3GroupManagerDb.getSchedule: Error decoding schedule: " + ex);
                    }
                }
                throw new GroupManagerDb.Error("AndroidSqlite3GroupManagerDb.getSchedule: Cannot get the result from the database");
            }
        }
        return schedule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map getScheduleMembers(String name) throws GroupManagerDb.Error {
        HashMap<Name, Blob> map = new HashMap<Name, Blob>();
        try (Cursor cursor = this.database_.rawQuery("SELECT key_name, pubkey FROM members JOIN schedules ON members.schedule_id=schedules.schedule_id WHERE schedule_name=?", new String[]{name});){
            while (cursor.moveToNext()) {
                Name keyName = new Name();
                try {
                    keyName.wireDecode(new Blob(cursor.getBlob(0)), (WireFormat)TlvWireFormat.get());
                }
                catch (EncodingException ex) {
                    throw new GroupManagerDb.Error("AndroidSqlite3GroupManagerDb.getScheduleMembers: Error decoding name: " + ex);
                }
                map.put(keyName, new Blob(cursor.getBlob(1)));
            }
        }
        return map;
    }

    @Override
    public void addSchedule(String name, Schedule schedule) throws GroupManagerDb.Error {
        AndroidSqlite3GroupManagerDb.checkAddSchedule(name);
        ContentValues values = new ContentValues();
        values.put("schedule_name", name);
        values.put("schedule", schedule.wireEncode().getImmutableArray());
        if (this.database_.insert("schedules", null, values) < 0L) {
            throw new GroupManagerDb.Error("AndroidSqlite3GroupManagerDb.addSchedule: SQLite error");
        }
    }

    @Override
    public void deleteSchedule(String name) throws GroupManagerDb.Error {
        int scheduleId = this.getScheduleId(name);
        if (scheduleId == -1) {
            return;
        }
        this.database_.execSQL("DELETE FROM members WHERE schedule_id=?", new Object[]{scheduleId});
        this.database_.execSQL("DELETE FROM schedules WHERE schedule_id=?", new Object[]{scheduleId});
    }

    @Override
    public void renameSchedule(String oldName, String newName) throws GroupManagerDb.Error {
        AndroidSqlite3GroupManagerDb.checkRenameSchedule(newName);
        ContentValues values = new ContentValues();
        values.put("schedule_name", newName);
        if (this.database_.update("schedules", values, "schedule_name=?", new String[]{oldName}) <= 0) {
            throw new GroupManagerDb.Error("AndroidSqlite3GroupManagerDb.renameSchedule: SQLite error");
        }
    }

    @Override
    public void updateSchedule(String name, Schedule schedule) throws GroupManagerDb.Error {
        if (!this.hasSchedule(name)) {
            this.addSchedule(name, schedule);
            return;
        }
        ContentValues values = new ContentValues();
        values.put("schedule", schedule.wireEncode().getImmutableArray());
        if (this.database_.update("schedules", values, "schedule_name=?", new String[]{name}) <= 0) {
            throw new GroupManagerDb.Error("AndroidSqlite3GroupManagerDb.updateSchedule: SQLite error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasMember(Name identity) throws GroupManagerDb.Error {
        try (SQLiteStatement statement = this.database_.compileStatement("SELECT member_id FROM members WHERE member_name=?");){
            statement.bindBlob(1, identity.wireEncode(TlvWireFormat.get()).getImmutableArray());
            try {
                statement.simpleQueryForLong();
                boolean bl = true;
                return bl;
            }
            catch (SQLiteDoneException ex) {
                boolean bl = false;
                statement.close();
                return bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List listAllMembers() throws GroupManagerDb.Error {
        ArrayList<Name> list = new ArrayList<Name>();
        try (Cursor cursor = this.database_.rawQuery("SELECT member_name FROM members", new String[0]);){
            while (cursor.moveToNext()) {
                Name identity = new Name();
                try {
                    identity.wireDecode(new Blob(cursor.getBlob(0)), (WireFormat)TlvWireFormat.get());
                }
                catch (EncodingException ex) {
                    throw new GroupManagerDb.Error("AndroidSqlite3GroupManagerDb.listAllMembers: Error decoding name: " + ex);
                }
                list.add(identity);
            }
        }
        return list;
    }

    @Override
    public String getMemberSchedule(Name identity) throws GroupManagerDb.Error {
        try (SQLiteStatement statement = this.database_.compileStatement("SELECT schedule_name FROM schedules JOIN members ON schedules.schedule_id = members.schedule_id WHERE member_name=?");){
            statement.bindBlob(1, identity.wireEncode(TlvWireFormat.get()).getImmutableArray());
            try {
                String string = statement.simpleQueryForString();
                return string;
            }
            catch (SQLiteDoneException ex) {
                throw new GroupManagerDb.Error("AndroidSqlite3GroupManagerDb.getMemberSchedule: Cannot get the result from the database");
            }
        }
    }

    @Override
    public void addMember(String scheduleName, Name keyName, Blob key) throws GroupManagerDb.Error {
        int scheduleId = this.getScheduleId(scheduleName);
        if (scheduleId == -1) {
            throw new GroupManagerDb.Error("The schedule does not exist");
        }
        Name memberName = keyName.getPrefix(-1);
        ContentValues values = new ContentValues();
        values.put("schedule_id", Integer.valueOf(scheduleId));
        values.put("member_name", memberName.wireEncode(TlvWireFormat.get()).getImmutableArray());
        values.put("key_name", keyName.wireEncode(TlvWireFormat.get()).getImmutableArray());
        values.put("pubkey", key.getImmutableArray());
        if (this.database_.insert("members", null, values) < 0L) {
            throw new GroupManagerDb.Error("AndroidSqlite3GroupManagerDb.addMember: SQLite error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMemberSchedule(Name identity, String scheduleName) throws GroupManagerDb.Error {
        int scheduleId = this.getScheduleId(scheduleName);
        if (scheduleId == -1) {
            throw new GroupManagerDb.Error("Sqlite3GroupManagerDb.updateMemberSchedule: The schedule does not exist");
        }
        try (SQLiteStatement statement = this.database_.compileStatement("UPDATE members SET schedule_id=? WHERE member_name=?");){
            statement.bindLong(1, (long)scheduleId);
            statement.bindBlob(2, identity.wireEncode(TlvWireFormat.get()).getImmutableArray());
            if (statement.executeUpdateDelete() <= 0) {
                throw new GroupManagerDb.Error("AndroidSqlite3GroupManagerDb.updateMemberSchedule: SQLite error");
            }
        }
    }

    @Override
    public void deleteMember(Name identity) throws GroupManagerDb.Error {
        this.database_.execSQL("DELETE FROM members WHERE member_name=?", new Object[]{identity.wireEncode(TlvWireFormat.get()).getImmutableArray()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasEKey(Name eKeyName) throws GroupManagerDb.Error {
        try (SQLiteStatement statement = this.database_.compileStatement("SELECT ekey_id FROM ekeys where ekey_name=?");){
            statement.bindBlob(1, eKeyName.wireEncode(TlvWireFormat.get()).getImmutableArray());
            try {
                statement.simpleQueryForLong();
                boolean bl = true;
                return bl;
            }
            catch (SQLiteDoneException ex) {
                boolean bl = false;
                statement.close();
                return bl;
            }
        }
    }

    @Override
    public void addEKey(Name eKeyName, Blob publicKey, Blob privateKey) throws GroupManagerDb.Error {
        ContentValues values = new ContentValues();
        values.put("ekey_name", eKeyName.wireEncode(TlvWireFormat.get()).getImmutableArray());
        values.put("pub_key", publicKey.getImmutableArray());
        if (this.database_.insert("ekeys", null, values) < 0L) {
            throw new GroupManagerDb.Error("AndroidSqlite3GroupManagerDb.addEKey: SQLite error");
        }
        this.privateKeyBase_.put(new Name(eKeyName), privateKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getEKey(Name eKeyName, Blob[] publicKey, Blob[] privateKey) throws GroupManagerDb.Error {
        block10: {
            long ekeyId;
            try (SQLiteStatement statement = this.database_.compileStatement("SELECT ekey_id FROM ekeys WHERE ekey_name=?");){
                statement.bindBlob(1, eKeyName.wireEncode(TlvWireFormat.get()).getImmutableArray());
                try {
                    ekeyId = statement.simpleQueryForLong();
                }
                catch (SQLiteDoneException ex) {
                    throw new GroupManagerDb.Error("getEKey: Cannot find the eKeyName");
                }
            }
            try (Cursor cursor = this.database_.rawQuery("SELECT pub_key FROM ekeys WHERE ekey_id=?", new String[]{Long.toString(ekeyId)});){
                if (cursor.moveToNext()) {
                    publicKey[0] = new Blob(cursor.getBlob(0));
                    break block10;
                }
                throw new GroupManagerDb.Error("getEKey: Cannot find the eKeyName");
            }
        }
        privateKey[0] = this.privateKeyBase_.get(eKeyName);
    }

    @Override
    public void cleanEKeys() throws GroupManagerDb.Error {
        this.database_.execSQL("DELETE FROM ekeys", new Object[0]);
        this.privateKeyBase_.clear();
    }

    @Override
    public void deleteEKey(Name eKeyName) throws GroupManagerDb.Error {
        this.database_.execSQL("DELETE FROM ekeys WHERE ekey_name=?", new Object[]{eKeyName.wireEncode(TlvWireFormat.get()).getImmutableArray()});
        this.privateKeyBase_.remove(eKeyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getScheduleId(String name) throws GroupManagerDb.Error {
        try (Cursor cursor = this.database_.rawQuery("SELECT schedule_id FROM schedules WHERE schedule_name=?", new String[]{name});){
            if (cursor.moveToNext()) {
                int n = cursor.getInt(0);
                return n;
            }
            int n = -1;
            return n;
        }
    }
}

