/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.encrypt;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDoneException;
import android.database.sqlite.SQLiteStatement;
import net.named_data.jndn.Name;
import net.named_data.jndn.encoding.TlvWireFormat;
import net.named_data.jndn.encrypt.ConsumerDb;
import net.named_data.jndn.encrypt.Sqlite3ConsumerDbBase;
import net.named_data.jndn.util.Blob;

public class AndroidSqlite3ConsumerDb
extends Sqlite3ConsumerDbBase {
    private final SQLiteDatabase database_;

    public AndroidSqlite3ConsumerDb(String databaseFilePath) {
        this.database_ = SQLiteDatabase.openDatabase((String)databaseFilePath, null, (int)0x10000000);
        this.database_.execSQL("CREATE TABLE IF NOT EXISTS                         \n  decryptionkeys(                                  \n    key_id              INTEGER PRIMARY KEY,       \n    key_name            BLOB NOT NULL,             \n    key_buf             BLOB NOT NULL              \n  );                                               \n");
        this.database_.execSQL("CREATE UNIQUE INDEX IF NOT EXISTS                  \n   KeyNameIndex ON decryptionkeys(key_name);       \n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob getKey(Name keyName) throws ConsumerDb.Error {
        long keyId;
        try (SQLiteStatement statement = this.database_.compileStatement("SELECT key_id FROM decryptionkeys WHERE key_name=?");){
            statement.bindBlob(1, keyName.wireEncode(TlvWireFormat.get()).getImmutableArray());
            try {
                keyId = statement.simpleQueryForLong();
            }
            catch (SQLiteDoneException ex) {
                Blob blob = new Blob();
                statement.close();
                return blob;
            }
        }
        try (Cursor cursor = this.database_.rawQuery("SELECT key_buf FROM decryptionkeys WHERE key_id=?", new String[]{Long.toString(keyId)});){
            if (cursor.moveToNext()) {
                Blob blob = new Blob(cursor.getBlob(0));
                return blob;
            }
            Blob blob = new Blob();
            return blob;
        }
    }

    @Override
    public void addKey(Name keyName, Blob keyBlob) throws ConsumerDb.Error {
        ContentValues values = new ContentValues();
        values.put("key_name", keyName.wireEncode(TlvWireFormat.get()).getImmutableArray());
        values.put("key_buf", keyBlob.getImmutableArray());
        if (this.database_.insert("decryptionkeys", null, values) < 0L) {
            throw new ConsumerDb.Error("AndroidSqlite3ConsumerDb.addKey: SQLite error");
        }
    }

    @Override
    public void deleteKey(Name keyName) throws ConsumerDb.Error {
        this.database_.execSQL("DELETE FROM decryptionkeys WHERE key_name=?", new Object[]{keyName.wireEncode(TlvWireFormat.get()).getImmutableArray()});
    }
}

