/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.encoding.tlv;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.util.Common;

public class TlvDecoder {
    private final ByteBuffer input_;
    private static Common dummyCommon_ = new Common();

    public TlvDecoder(ByteBuffer input) {
        this.input_ = input.duplicate();
    }

    public final int readVarNumber() throws EncodingException {
        try {
            int firstOctet = this.input_.get() & 0xFF;
            if (firstOctet < 253) {
                return firstOctet;
            }
            return this.readExtendedVarNumber(firstOctet);
        }
        catch (BufferUnderflowException ex) {
            throw new EncodingException("Read past the end of the input");
        }
    }

    public final int readExtendedVarNumber(int firstOctet) throws EncodingException {
        try {
            if (firstOctet == 253) {
                return ((this.input_.get() & 0xFF) << 8) + (this.input_.get() & 0xFF);
            }
            if (firstOctet == 254) {
                return ((this.input_.get() & 0xFF) << 24) + ((this.input_.get() & 0xFF) << 16) + ((this.input_.get() & 0xFF) << 8) + (this.input_.get() & 0xFF);
            }
            throw new EncodingException("Decoding a 64-bit VAR-NUMBER is not supported");
        }
        catch (BufferUnderflowException ex) {
            throw new EncodingException("Read past the end of the input");
        }
    }

    public final int readTypeAndLength(int expectedType) throws EncodingException {
        int type = this.readVarNumber();
        if (type != expectedType) {
            throw new EncodingException("Did not get the expected TLV type");
        }
        int length = this.readVarNumber();
        if (length > this.input_.remaining()) {
            throw new EncodingException("TLV length exceeds the buffer length");
        }
        return length;
    }

    public final int readNestedTlvsStart(int expectedType) throws EncodingException {
        return this.readTypeAndLength(expectedType) + this.input_.position();
    }

    public final void finishNestedTlvs(int endOffset, boolean skipCritical) throws EncodingException {
        if (this.input_.position() == endOffset) {
            return;
        }
        while (this.input_.position() < endOffset) {
            boolean critical;
            int type = this.readVarNumber();
            boolean bl = critical = type <= 31 || (type & 1) == 1;
            if (critical && !skipCritical) {
                throw new EncodingException("Unrecognized critical type code " + type);
            }
            int length = this.readVarNumber();
            int newPosition = this.input_.position() + length;
            if (newPosition > this.input_.limit()) {
                throw new EncodingException("TLV length exceeds the buffer length");
            }
            this.input_.position(newPosition);
        }
        if (this.input_.position() != endOffset) {
            throw new EncodingException("TLV length does not equal the total length of the nested TLVs");
        }
    }

    public final void finishNestedTlvs(int endOffset) throws EncodingException {
        this.finishNestedTlvs(endOffset, false);
    }

    public final boolean peekType(int expectedType, int endOffset) throws EncodingException {
        if (this.input_.position() >= endOffset) {
            return false;
        }
        int savePosition = this.input_.position();
        int type = this.readVarNumber();
        this.input_.position(savePosition);
        return type == expectedType;
    }

    public final long readNonNegativeInteger(int length) throws EncodingException {
        try {
            if (length == 1) {
                return (long)this.input_.get() & 0xFFL;
            }
            if (length == 2) {
                return (((long)this.input_.get() & 0xFFL) << 8) + ((long)this.input_.get() & 0xFFL);
            }
            if (length == 4) {
                return (((long)this.input_.get() & 0xFFL) << 24) + (((long)this.input_.get() & 0xFFL) << 16) + (((long)this.input_.get() & 0xFFL) << 8) + ((long)this.input_.get() & 0xFFL);
            }
            if (length == 8) {
                return (((long)this.input_.get() & 0xFFL) << 56) + (((long)this.input_.get() & 0xFFL) << 48) + (((long)this.input_.get() & 0xFFL) << 40) + (((long)this.input_.get() & 0xFFL) << 32) + (((long)this.input_.get() & 0xFFL) << 24) + (((long)this.input_.get() & 0xFFL) << 16) + (((long)this.input_.get() & 0xFFL) << 8) + ((long)this.input_.get() & 0xFFL);
            }
            throw new EncodingException("Invalid length for a TLV nonNegativeInteger");
        }
        catch (BufferUnderflowException ex) {
            throw new EncodingException("Read past the end of the input");
        }
    }

    public final long readNonNegativeIntegerTlv(int expectedType) throws EncodingException {
        int length = this.readTypeAndLength(expectedType);
        return this.readNonNegativeInteger(length);
    }

    public final long readOptionalNonNegativeIntegerTlv(int expectedType, int endOffset) throws EncodingException {
        if (this.peekType(expectedType, endOffset)) {
            return this.readNonNegativeIntegerTlv(expectedType);
        }
        return -1L;
    }

    public final ByteBuffer readBlobTlv(int expectedType) throws EncodingException {
        int length = this.readTypeAndLength(expectedType);
        int saveLimit = this.input_.limit();
        this.input_.limit(this.input_.position() + length);
        ByteBuffer result = this.input_.slice();
        this.input_.limit(saveLimit);
        this.input_.position(this.input_.position() + length);
        return result;
    }

    public final ByteBuffer readOptionalBlobTlv(int expectedType, int endOffset) throws EncodingException {
        if (this.peekType(expectedType, endOffset)) {
            return this.readBlobTlv(expectedType);
        }
        return null;
    }

    public final boolean readBooleanTlv(int expectedType, int endOffset) throws EncodingException {
        if (this.peekType(expectedType, endOffset)) {
            int length = this.readTypeAndLength(expectedType);
            this.input_.position(this.input_.position() + length);
            return true;
        }
        return false;
    }

    public final void skipTlv(int expectedType) throws EncodingException {
        int length = this.readTypeAndLength(expectedType);
        this.input_.position(this.input_.position() + length);
    }

    public final void skipOptionalTlv(int expectedType, int endOffset) throws EncodingException {
        if (this.peekType(expectedType, endOffset)) {
            this.skipTlv(expectedType);
        }
    }

    public final int getOffset() {
        return this.input_.position();
    }

    public final void seek(int offset) {
        this.input_.position(offset);
    }

    public final ByteBuffer getSlice(int beginOffset, int endOffset) {
        ByteBuffer result = this.input_.duplicate();
        result.position(0);
        result.limit(endOffset);
        result.position(beginOffset);
        return result;
    }
}

