/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.encoding;

import java.nio.ByteBuffer;
import java.util.Random;
import net.named_data.jndn.ComponentType;
import net.named_data.jndn.ContentType;
import net.named_data.jndn.ControlParameters;
import net.named_data.jndn.ControlResponse;
import net.named_data.jndn.Data;
import net.named_data.jndn.DelegationSet;
import net.named_data.jndn.DigestSha256Signature;
import net.named_data.jndn.Exclude;
import net.named_data.jndn.GenericSignature;
import net.named_data.jndn.HmacWithSha256Signature;
import net.named_data.jndn.Interest;
import net.named_data.jndn.KeyLocator;
import net.named_data.jndn.KeyLocatorType;
import net.named_data.jndn.MetaInfo;
import net.named_data.jndn.Name;
import net.named_data.jndn.NetworkNack;
import net.named_data.jndn.RegistrationOptions;
import net.named_data.jndn.Sha256WithEcdsaSignature;
import net.named_data.jndn.Sha256WithRsaSignature;
import net.named_data.jndn.Signature;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encoding.SignatureHolder;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.encoding.tlv.TlvDecoder;
import net.named_data.jndn.encoding.tlv.TlvEncoder;
import net.named_data.jndn.encrypt.EncryptedContent;
import net.named_data.jndn.encrypt.Schedule;
import net.named_data.jndn.encrypt.algo.EncryptAlgorithmType;
import net.named_data.jndn.lp.CongestionMark;
import net.named_data.jndn.lp.IncomingFaceId;
import net.named_data.jndn.lp.LpPacket;
import net.named_data.jndn.security.ValidityPeriod;
import net.named_data.jndn.util.Blob;

public class Tlv0_2WireFormat
extends WireFormat {
    private static final Random random_ = new Random();
    private static Tlv0_2WireFormat instance_ = new Tlv0_2WireFormat();
    private static boolean didCanBePrefixWarning_ = false;

    @Override
    public Blob encodeName(Name name) {
        TlvEncoder encoder = new TlvEncoder(256);
        Tlv0_2WireFormat.encodeName(name, new int[1], new int[1], encoder);
        return new Blob(encoder.getOutput(), false);
    }

    @Override
    public void decodeName(Name name, ByteBuffer input, boolean copy) throws EncodingException {
        TlvDecoder decoder = new TlvDecoder(input);
        Tlv0_2WireFormat.decodeName(name, new int[1], new int[1], decoder, copy);
    }

    @Override
    public Blob encodeInterest(Interest interest, int[] signedPortionBeginOffset, int[] signedPortionEndOffset) {
        ByteBuffer nonce;
        if (!interest.getDidSetCanBePrefix_() && !didCanBePrefixWarning_) {
            System.out.println("WARNING: The default CanBePrefix will change. See Interest.setDefaultCanBePrefix() for details.");
            didCanBePrefixWarning_ = true;
        }
        if (interest.hasApplicationParameters()) {
            return Tlv0_2WireFormat.encodeInterestV03(interest, signedPortionBeginOffset, signedPortionEndOffset);
        }
        TlvEncoder encoder = new TlvEncoder(256);
        int saveLength = encoder.getLength();
        if (interest.getForwardingHint().size() > 0) {
            if (interest.getSelectedDelegationIndex() >= 0) {
                throw new Error("An Interest may not have a selected delegation when encoding a forwarding hint");
            }
            if (interest.hasLink()) {
                throw new Error("An Interest may not have a link object when encoding a forwarding hint");
            }
            int forwardingHintSaveLength = encoder.getLength();
            Tlv0_2WireFormat.encodeDelegationSet(interest.getForwardingHint(), encoder);
            encoder.writeTypeAndLength(30, encoder.getLength() - forwardingHintSaveLength);
        }
        encoder.writeOptionalNonNegativeIntegerTlv(32, interest.getSelectedDelegationIndex());
        try {
            Blob linkWireEncoding = interest.getLinkWireEncoding(this);
            if (!linkWireEncoding.isNull()) {
                encoder.writeBuffer(linkWireEncoding.buf());
            }
        }
        catch (EncodingException ex) {
            throw new Error(ex.getMessage());
        }
        encoder.writeOptionalNonNegativeIntegerTlvFromDouble(12, interest.getInterestLifetimeMilliseconds());
        if (interest.getNonce().size() == 0) {
            nonce = ByteBuffer.allocate(4);
            random_.nextBytes(nonce.array());
            encoder.writeBlobTlv(10, nonce);
        } else if (interest.getNonce().size() < 4) {
            nonce = ByteBuffer.allocate(4);
            nonce.put(interest.getNonce().buf());
            for (int i = 0; i < 4 - interest.getNonce().size(); ++i) {
                nonce.put((byte)random_.nextInt());
            }
            nonce.flip();
            encoder.writeBlobTlv(10, nonce);
        } else if (interest.getNonce().size() == 4) {
            encoder.writeBlobTlv(10, interest.getNonce().buf());
        } else {
            nonce = interest.getNonce().buf();
            nonce.limit(nonce.position() + 4);
            encoder.writeBlobTlv(10, nonce);
        }
        Tlv0_2WireFormat.encodeSelectors(interest, encoder);
        int[] tempSignedPortionBeginOffset = new int[1];
        int[] tempSignedPortionEndOffset = new int[1];
        Tlv0_2WireFormat.encodeName(interest.getName(), tempSignedPortionBeginOffset, tempSignedPortionEndOffset, encoder);
        int signedPortionBeginOffsetFromBack = encoder.getLength() - tempSignedPortionBeginOffset[0];
        int signedPortionEndOffsetFromBack = encoder.getLength() - tempSignedPortionEndOffset[0];
        encoder.writeTypeAndLength(5, encoder.getLength() - saveLength);
        signedPortionBeginOffset[0] = encoder.getLength() - signedPortionBeginOffsetFromBack;
        signedPortionEndOffset[0] = encoder.getLength() - signedPortionEndOffsetFromBack;
        return new Blob(encoder.getOutput(), false);
    }

    @Override
    public void decodeInterest(Interest interest, ByteBuffer input, int[] signedPortionBeginOffset, int[] signedPortionEndOffset, boolean copy) throws EncodingException {
        try {
            this.decodeInterestV02(interest, input, signedPortionBeginOffset, signedPortionEndOffset, copy);
        }
        catch (Exception exceptionV02) {
            try {
                Tlv0_2WireFormat.decodeInterestV03(interest, input, signedPortionBeginOffset, signedPortionEndOffset, copy);
            }
            catch (Exception ex) {
                throw exceptionV02;
            }
        }
    }

    private void decodeInterestV02(Interest interest, ByteBuffer input, int[] signedPortionBeginOffset, int[] signedPortionEndOffset, boolean copy) throws EncodingException {
        TlvDecoder decoder = new TlvDecoder(input);
        int endOffset = decoder.readNestedTlvsStart(5);
        Tlv0_2WireFormat.decodeName(interest.getName(), signedPortionBeginOffset, signedPortionEndOffset, decoder, copy);
        if (decoder.peekType(9, endOffset)) {
            Tlv0_2WireFormat.decodeSelectors(interest, decoder, copy);
        } else {
            interest.setMinSuffixComponents(-1);
            interest.setMaxSuffixComponents(-1);
            interest.getKeyLocator().clear();
            interest.getExclude().clear();
            interest.setChildSelector(-1);
            interest.setMustBeFresh(false);
        }
        ByteBuffer nonce = decoder.readBlobTlv(10);
        interest.setInterestLifetimeMilliseconds(decoder.readOptionalNonNegativeIntegerTlv(12, endOffset));
        if (decoder.peekType(30, endOffset)) {
            int forwardingHintEndOffset = decoder.readNestedTlvsStart(30);
            Tlv0_2WireFormat.decodeDelegationSet(interest.getForwardingHint(), forwardingHintEndOffset, decoder, copy);
            decoder.finishNestedTlvs(forwardingHintEndOffset);
        }
        if (decoder.peekType(6, endOffset)) {
            int linkBeginOffset = decoder.getOffset();
            int linkEndOffset = decoder.readNestedTlvsStart(6);
            decoder.seek(linkEndOffset);
            interest.setLinkWireEncoding(new Blob(decoder.getSlice(linkBeginOffset, linkEndOffset), copy), this);
        } else {
            interest.unsetLink();
        }
        interest.setSelectedDelegationIndex((int)decoder.readOptionalNonNegativeIntegerTlv(32, endOffset));
        if (interest.getSelectedDelegationIndex() >= 0 && !interest.hasLink()) {
            throw new EncodingException("Interest has a selected delegation, but no link object");
        }
        interest.setApplicationParameters(new Blob());
        interest.setNonce(new Blob(nonce, copy));
        decoder.finishNestedTlvs(endOffset);
    }

    @Override
    public Blob encodeData(Data data, int[] signedPortionBeginOffset, int[] signedPortionEndOffset) {
        TlvEncoder encoder = new TlvEncoder(1500);
        int saveLength = encoder.getLength();
        encoder.writeBlobTlv(23, data.getSignature().getSignature().buf());
        int signedPortionEndOffsetFromBack = encoder.getLength();
        Tlv0_2WireFormat.encodeSignatureInfo(data.getSignature(), encoder);
        encoder.writeBlobTlv(21, data.getContent().buf());
        Tlv0_2WireFormat.encodeMetaInfo(data.getMetaInfo(), encoder);
        Tlv0_2WireFormat.encodeName(data.getName(), new int[1], new int[1], encoder);
        int signedPortionBeginOffsetFromBack = encoder.getLength();
        encoder.writeTypeAndLength(6, encoder.getLength() - saveLength);
        signedPortionBeginOffset[0] = encoder.getLength() - signedPortionBeginOffsetFromBack;
        signedPortionEndOffset[0] = encoder.getLength() - signedPortionEndOffsetFromBack;
        return new Blob(encoder.getOutput(), false);
    }

    @Override
    public void decodeData(Data data, ByteBuffer input, int[] signedPortionBeginOffset, int[] signedPortionEndOffset, boolean copy) throws EncodingException {
        TlvDecoder decoder = new TlvDecoder(input);
        int endOffset = decoder.readNestedTlvsStart(6);
        signedPortionBeginOffset[0] = decoder.getOffset();
        Tlv0_2WireFormat.decodeName(data.getName(), new int[1], new int[1], decoder, copy);
        if (decoder.peekType(20, endOffset)) {
            Tlv0_2WireFormat.decodeMetaInfo(data.getMetaInfo(), decoder, copy);
        } else {
            data.getMetaInfo().clear();
        }
        data.setContent(new Blob(decoder.readOptionalBlobTlv(21, endOffset), copy));
        Tlv0_2WireFormat.decodeSignatureInfo(data, decoder, copy);
        signedPortionEndOffset[0] = decoder.getOffset();
        data.getSignature().setSignature(new Blob(decoder.readBlobTlv(23), copy));
        decoder.finishNestedTlvs(endOffset);
    }

    @Override
    public Blob encodeControlParameters(ControlParameters controlParameters) {
        TlvEncoder encoder = new TlvEncoder(256);
        Tlv0_2WireFormat.encodeControlParameters(controlParameters, encoder);
        return new Blob(encoder.getOutput(), false);
    }

    @Override
    public void decodeControlParameters(ControlParameters controlParameters, ByteBuffer input, boolean copy) throws EncodingException {
        TlvDecoder decoder = new TlvDecoder(input);
        Tlv0_2WireFormat.decodeControlParameters(controlParameters, decoder, copy);
    }

    @Override
    public Blob encodeControlResponse(ControlResponse controlResponse) {
        TlvEncoder encoder = new TlvEncoder(256);
        int saveLength = encoder.getLength();
        if (controlResponse.getBodyAsControlParameters() != null) {
            Tlv0_2WireFormat.encodeControlParameters(controlResponse.getBodyAsControlParameters(), encoder);
        }
        encoder.writeBlobTlv(103, new Blob(controlResponse.getStatusText()).buf());
        encoder.writeNonNegativeIntegerTlv(102, controlResponse.getStatusCode());
        encoder.writeTypeAndLength(101, encoder.getLength() - saveLength);
        return new Blob(encoder.getOutput(), false);
    }

    @Override
    public void decodeControlResponse(ControlResponse controlResponse, ByteBuffer input, boolean copy) throws EncodingException {
        TlvDecoder decoder = new TlvDecoder(input);
        int endOffset = decoder.readNestedTlvsStart(101);
        controlResponse.setStatusCode((int)decoder.readNonNegativeIntegerTlv(102));
        Blob statusText = new Blob(decoder.readBlobTlv(103), false);
        controlResponse.setStatusText(statusText.toString());
        if (decoder.peekType(104, endOffset)) {
            controlResponse.setBodyAsControlParameters(new ControlParameters());
            Tlv0_2WireFormat.decodeControlParameters(controlResponse.getBodyAsControlParameters(), decoder, copy);
        } else {
            controlResponse.setBodyAsControlParameters(null);
        }
        decoder.finishNestedTlvs(endOffset, true);
    }

    @Override
    public Blob encodeSignatureInfo(Signature signature) {
        TlvEncoder encoder = new TlvEncoder(256);
        Tlv0_2WireFormat.encodeSignatureInfo(signature, encoder);
        return new Blob(encoder.getOutput(), false);
    }

    @Override
    public Signature decodeSignatureInfoAndValue(ByteBuffer signatureInfo, ByteBuffer signatureValue, boolean copy) throws EncodingException {
        SimpleSignatureHolder signatureHolder = new SimpleSignatureHolder();
        TlvDecoder decoder = new TlvDecoder(signatureInfo);
        Tlv0_2WireFormat.decodeSignatureInfo(signatureHolder, decoder, copy);
        decoder = new TlvDecoder(signatureValue);
        signatureHolder.getSignature().setSignature(new Blob(decoder.readBlobTlv(23), copy));
        return signatureHolder.getSignature();
    }

    @Override
    public Blob encodeSignatureValue(Signature signature) {
        TlvEncoder encoder = new TlvEncoder(256);
        encoder.writeBlobTlv(23, signature.getSignature().buf());
        return new Blob(encoder.getOutput(), false);
    }

    @Override
    public void decodeLpPacket(LpPacket lpPacket, ByteBuffer input, boolean copy) throws EncodingException {
        lpPacket.clear();
        TlvDecoder decoder = new TlvDecoder(input);
        int endOffset = decoder.readNestedTlvsStart(100);
        while (decoder.getOffset() < endOffset) {
            int fieldType = decoder.readVarNumber();
            int fieldLength = decoder.readVarNumber();
            int fieldEndOffset = decoder.getOffset() + fieldLength;
            if (fieldEndOffset > input.limit()) {
                throw new EncodingException("TLV length exceeds the buffer length");
            }
            if (fieldType == 80) {
                lpPacket.setFragmentWireEncoding(new Blob(decoder.getSlice(decoder.getOffset(), fieldEndOffset), copy));
                decoder.seek(fieldEndOffset);
                break;
            }
            if (fieldType == 800) {
                NetworkNack networkNack = new NetworkNack();
                int code = (int)decoder.readOptionalNonNegativeIntegerTlv(801, fieldEndOffset);
                if (code < 0 || code == NetworkNack.Reason.NONE.getNumericType()) {
                    networkNack.setReason(NetworkNack.Reason.NONE);
                } else if (code == NetworkNack.Reason.CONGESTION.getNumericType()) {
                    networkNack.setReason(NetworkNack.Reason.CONGESTION);
                } else if (code == NetworkNack.Reason.DUPLICATE.getNumericType()) {
                    networkNack.setReason(NetworkNack.Reason.DUPLICATE);
                } else if (code == NetworkNack.Reason.NO_ROUTE.getNumericType()) {
                    networkNack.setReason(NetworkNack.Reason.NO_ROUTE);
                } else {
                    networkNack.setReason(NetworkNack.Reason.OTHER_CODE);
                    networkNack.setOtherReasonCode(code);
                }
                lpPacket.addHeaderField(networkNack);
            } else if (fieldType == 817) {
                IncomingFaceId incomingFaceId = new IncomingFaceId();
                incomingFaceId.setFaceId(decoder.readNonNegativeInteger(fieldLength));
                lpPacket.addHeaderField(incomingFaceId);
            } else if (fieldType == 832) {
                CongestionMark congestionMark = new CongestionMark();
                congestionMark.setCongestionMark(decoder.readNonNegativeInteger(fieldLength));
                lpPacket.addHeaderField(congestionMark);
            } else {
                boolean canIgnore;
                boolean bl = canIgnore = fieldType >= 800 && fieldType <= 959 && (fieldType & 3) == 0;
                if (!canIgnore) {
                    throw new EncodingException("Did not get the expected TLV type");
                }
                decoder.seek(fieldEndOffset);
            }
            decoder.finishNestedTlvs(fieldEndOffset);
        }
        decoder.finishNestedTlvs(endOffset);
    }

    @Override
    public Blob encodeDelegationSet(DelegationSet delegationSet) {
        TlvEncoder encoder = new TlvEncoder(256);
        Tlv0_2WireFormat.encodeDelegationSet(delegationSet, encoder);
        return new Blob(encoder.getOutput(), false);
    }

    @Override
    public void decodeDelegationSet(DelegationSet delegationSet, ByteBuffer input, boolean copy) throws EncodingException {
        TlvDecoder decoder = new TlvDecoder(input);
        Tlv0_2WireFormat.decodeDelegationSet(delegationSet, input.limit(), decoder, copy);
    }

    @Override
    public Blob encodeEncryptedContent(EncryptedContent encryptedContent) {
        TlvEncoder encoder = new TlvEncoder(256);
        int saveLength = encoder.getLength();
        encoder.writeBlobTlv(132, encryptedContent.getPayload().buf());
        encoder.writeOptionalBlobTlv(133, encryptedContent.getInitialVector().buf());
        encoder.writeNonNegativeIntegerTlv(131, encryptedContent.getAlgorithmType().getNumericType());
        Tlv0_2WireFormat.encodeKeyLocator(28, encryptedContent.getKeyLocator(), encoder);
        encoder.writeTypeAndLength(130, encoder.getLength() - saveLength);
        return new Blob(encoder.getOutput(), false);
    }

    @Override
    public void decodeEncryptedContent(EncryptedContent encryptedContent, ByteBuffer input, boolean copy) throws EncodingException {
        TlvDecoder decoder = new TlvDecoder(input);
        int endOffset = decoder.readNestedTlvsStart(130);
        encryptedContent.clear();
        Tlv0_2WireFormat.decodeKeyLocator(28, encryptedContent.getKeyLocator(), decoder, copy);
        int algorithmType = (int)decoder.readNonNegativeIntegerTlv(131);
        if (algorithmType == EncryptAlgorithmType.AesEcb.getNumericType()) {
            encryptedContent.setAlgorithmType(EncryptAlgorithmType.AesEcb);
        } else if (algorithmType == EncryptAlgorithmType.AesCbc.getNumericType()) {
            encryptedContent.setAlgorithmType(EncryptAlgorithmType.AesCbc);
        } else if (algorithmType == EncryptAlgorithmType.RsaPkcs.getNumericType()) {
            encryptedContent.setAlgorithmType(EncryptAlgorithmType.RsaPkcs);
        } else if (algorithmType == EncryptAlgorithmType.RsaOaep.getNumericType()) {
            encryptedContent.setAlgorithmType(EncryptAlgorithmType.RsaOaep);
        } else {
            throw new EncodingException("Unrecognized EncryptionAlgorithm code " + algorithmType);
        }
        encryptedContent.setInitialVector(new Blob(decoder.readOptionalBlobTlv(133, endOffset), copy));
        encryptedContent.setPayload(new Blob(decoder.readBlobTlv(132), copy));
        decoder.finishNestedTlvs(endOffset);
    }

    @Override
    public Blob encodeEncryptedContentV2(EncryptedContent encryptedContent) {
        TlvEncoder encoder = new TlvEncoder(256);
        int saveLength = encoder.getLength();
        if (encryptedContent.getKeyLocator().getType() == KeyLocatorType.KEYNAME) {
            Tlv0_2WireFormat.encodeName(encryptedContent.getKeyLocator().getKeyName(), new int[1], new int[1], encoder);
        }
        encoder.writeOptionalBlobTlv(134, encryptedContent.getPayloadKey().buf());
        encoder.writeOptionalBlobTlv(133, encryptedContent.getInitialVector().buf());
        encoder.writeBlobTlv(132, encryptedContent.getPayload().buf());
        encoder.writeTypeAndLength(130, encoder.getLength() - saveLength);
        return new Blob(encoder.getOutput(), false);
    }

    @Override
    public void decodeEncryptedContentV2(EncryptedContent encryptedContent, ByteBuffer input, boolean copy) throws EncodingException {
        TlvDecoder decoder = new TlvDecoder(input);
        int endOffset = decoder.readNestedTlvsStart(130);
        encryptedContent.clear();
        encryptedContent.setPayload(new Blob(decoder.readBlobTlv(132), copy));
        encryptedContent.setInitialVector(new Blob(decoder.readOptionalBlobTlv(133, endOffset), copy));
        encryptedContent.setPayloadKey(new Blob(decoder.readOptionalBlobTlv(134, endOffset), copy));
        if (decoder.peekType(7, endOffset)) {
            Tlv0_2WireFormat.decodeName(encryptedContent.getKeyLocator().getKeyName(), new int[1], new int[1], decoder, copy);
            encryptedContent.getKeyLocator().setType(KeyLocatorType.KEYNAME);
        }
        decoder.finishNestedTlvs(endOffset);
    }

    public static Tlv0_2WireFormat get() {
        return instance_;
    }

    private static void encodeNameComponent(Name.Component component, TlvEncoder encoder) {
        int type = component.getType() == ComponentType.OTHER_CODE ? component.getOtherTypeCode() : component.getType().getNumericType();
        encoder.writeBlobTlv(type, component.getValue().buf());
    }

    private static Name.Component decodeNameComponent(TlvDecoder decoder, boolean copy) throws EncodingException {
        int savePosition = decoder.getOffset();
        int type = decoder.readVarNumber();
        decoder.seek(savePosition);
        Blob value = new Blob(decoder.readBlobTlv(type), copy);
        if (type == 1) {
            return Name.Component.fromImplicitSha256Digest(value);
        }
        if (type == 2) {
            return Name.Component.fromParametersSha256Digest(value);
        }
        if (type == 8) {
            return new Name.Component(value);
        }
        return new Name.Component(value, ComponentType.OTHER_CODE, type);
    }

    private static void encodeName(Name name, int[] signedPortionBeginOffset, int[] signedPortionEndOffset, TlvEncoder encoder) {
        int saveLength = encoder.getLength();
        int signedPortionEndOffsetFromBack = 0;
        for (int i = name.size() - 1; i >= 0; --i) {
            Tlv0_2WireFormat.encodeNameComponent(name.get(i), encoder);
            if (i != name.size() - 1) continue;
            signedPortionEndOffsetFromBack = encoder.getLength();
        }
        int signedPortionBeginOffsetFromBack = encoder.getLength();
        encoder.writeTypeAndLength(7, encoder.getLength() - saveLength);
        signedPortionBeginOffset[0] = encoder.getLength() - signedPortionBeginOffsetFromBack;
        signedPortionEndOffset[0] = name.size() == 0 ? signedPortionBeginOffset[0] : encoder.getLength() - signedPortionEndOffsetFromBack;
    }

    private static void decodeName(Name name, int[] signedPortionBeginOffset, int[] signedPortionEndOffset, TlvDecoder decoder, boolean copy) throws EncodingException {
        name.clear();
        int endOffset = decoder.readNestedTlvsStart(7);
        signedPortionBeginOffset[0] = decoder.getOffset();
        signedPortionEndOffset[0] = signedPortionBeginOffset[0];
        while (decoder.getOffset() < endOffset) {
            signedPortionEndOffset[0] = decoder.getOffset();
            name.append(Tlv0_2WireFormat.decodeNameComponent(decoder, copy));
        }
        decoder.finishNestedTlvs(endOffset);
    }

    private static void encodeSelectors(Interest interest, TlvEncoder encoder) {
        int saveLength = encoder.getLength();
        if (interest.getMustBeFresh()) {
            encoder.writeTypeAndLength(18, 0);
        }
        encoder.writeOptionalNonNegativeIntegerTlv(17, interest.getChildSelector());
        if (interest.getExclude().size() > 0) {
            Tlv0_2WireFormat.encodeExclude(interest.getExclude(), encoder);
        }
        if (interest.getKeyLocator().getType() != KeyLocatorType.NONE) {
            Tlv0_2WireFormat.encodeKeyLocator(15, interest.getKeyLocator(), encoder);
        }
        encoder.writeOptionalNonNegativeIntegerTlv(14, interest.getMaxSuffixComponents());
        encoder.writeOptionalNonNegativeIntegerTlv(13, interest.getMinSuffixComponents());
        if (encoder.getLength() != saveLength) {
            encoder.writeTypeAndLength(9, encoder.getLength() - saveLength);
        }
    }

    private static void decodeSelectors(Interest interest, TlvDecoder decoder, boolean copy) throws EncodingException {
        int endOffset = decoder.readNestedTlvsStart(9);
        interest.setMinSuffixComponents((int)decoder.readOptionalNonNegativeIntegerTlv(13, endOffset));
        interest.setMaxSuffixComponents((int)decoder.readOptionalNonNegativeIntegerTlv(14, endOffset));
        if (decoder.peekType(15, endOffset)) {
            Tlv0_2WireFormat.decodeKeyLocator(15, interest.getKeyLocator(), decoder, copy);
        } else {
            interest.getKeyLocator().clear();
        }
        if (decoder.peekType(16, endOffset)) {
            Tlv0_2WireFormat.decodeExclude(interest.getExclude(), decoder, copy);
        } else {
            interest.getExclude().clear();
        }
        interest.setChildSelector((int)decoder.readOptionalNonNegativeIntegerTlv(17, endOffset));
        interest.setMustBeFresh(decoder.readBooleanTlv(18, endOffset));
        decoder.finishNestedTlvs(endOffset);
    }

    private static void encodeExclude(Exclude exclude, TlvEncoder encoder) {
        int saveLength = encoder.getLength();
        for (int i = exclude.size() - 1; i >= 0; --i) {
            Exclude.Entry entry = exclude.get(i);
            if (entry.getType() == Exclude.Type.ANY) {
                encoder.writeTypeAndLength(19, 0);
                continue;
            }
            Tlv0_2WireFormat.encodeNameComponent(entry.getComponent(), encoder);
        }
        encoder.writeTypeAndLength(16, encoder.getLength() - saveLength);
    }

    private static void decodeExclude(Exclude exclude, TlvDecoder decoder, boolean copy) throws EncodingException {
        int endOffset = decoder.readNestedTlvsStart(16);
        exclude.clear();
        while (decoder.getOffset() < endOffset) {
            if (decoder.peekType(19, endOffset)) {
                decoder.readBooleanTlv(19, endOffset);
                exclude.appendAny();
                continue;
            }
            exclude.appendComponent(Tlv0_2WireFormat.decodeNameComponent(decoder, copy));
        }
        decoder.finishNestedTlvs(endOffset);
    }

    private static void encodeKeyLocator(int type, KeyLocator keyLocator, TlvEncoder encoder) {
        int saveLength = encoder.getLength();
        if (keyLocator.getType() != KeyLocatorType.NONE) {
            if (keyLocator.getType() == KeyLocatorType.KEYNAME) {
                Tlv0_2WireFormat.encodeName(keyLocator.getKeyName(), new int[1], new int[1], encoder);
            } else if (keyLocator.getType() == KeyLocatorType.KEY_LOCATOR_DIGEST && keyLocator.getKeyData().size() > 0) {
                encoder.writeBlobTlv(29, keyLocator.getKeyData().buf());
            } else {
                throw new Error("Unrecognized KeyLocatorType " + (Object)((Object)keyLocator.getType()));
            }
        }
        encoder.writeTypeAndLength(type, encoder.getLength() - saveLength);
    }

    private static void decodeKeyLocator(int expectedType, KeyLocator keyLocator, TlvDecoder decoder, boolean copy) throws EncodingException {
        int endOffset = decoder.readNestedTlvsStart(expectedType);
        keyLocator.clear();
        if (decoder.getOffset() == endOffset) {
            return;
        }
        if (decoder.peekType(7, endOffset)) {
            keyLocator.setType(KeyLocatorType.KEYNAME);
            Tlv0_2WireFormat.decodeName(keyLocator.getKeyName(), new int[1], new int[1], decoder, copy);
        } else if (decoder.peekType(29, endOffset)) {
            keyLocator.setType(KeyLocatorType.KEY_LOCATOR_DIGEST);
            keyLocator.setKeyData(new Blob(decoder.readBlobTlv(29), copy));
        } else {
            throw new EncodingException("decodeKeyLocator: Unrecognized key locator type");
        }
        decoder.finishNestedTlvs(endOffset);
    }

    private static void encodeValidityPeriod(ValidityPeriod validityPeriod, TlvEncoder encoder) {
        int saveLength = encoder.getLength();
        encoder.writeBlobTlv(255, new Blob(Schedule.toIsoString(validityPeriod.getNotAfter())).buf());
        encoder.writeBlobTlv(254, new Blob(Schedule.toIsoString(validityPeriod.getNotBefore())).buf());
        encoder.writeTypeAndLength(253, encoder.getLength() - saveLength);
    }

    private static void decodeValidityPeriod(ValidityPeriod validityPeriod, TlvDecoder decoder) throws EncodingException {
        int endOffset = decoder.readNestedTlvsStart(253);
        validityPeriod.clear();
        Blob isoString = new Blob(decoder.readBlobTlv(254), false);
        double notBefore = Schedule.fromIsoString("" + isoString);
        isoString = new Blob(decoder.readBlobTlv(255), false);
        double notAfter = Schedule.fromIsoString("" + isoString);
        validityPeriod.setPeriod(notBefore, notAfter);
        decoder.finishNestedTlvs(endOffset);
    }

    private static void encodeSignatureInfo(Signature signature, TlvEncoder encoder) {
        if (signature instanceof GenericSignature) {
            Blob encoding = ((GenericSignature)signature).getSignatureInfoEncoding();
            try {
                TlvDecoder decoder = new TlvDecoder(encoding.buf());
                int endOffset = decoder.readNestedTlvsStart(22);
                decoder.readNonNegativeIntegerTlv(27);
                decoder.finishNestedTlvs(endOffset, true);
            }
            catch (EncodingException ex) {
                throw new Error("The GenericSignature encoding is not a valid NDN-TLV SignatureInfo: " + ex.getMessage());
            }
            encoder.writeBuffer(encoding.buf());
            return;
        }
        int saveLength = encoder.getLength();
        if (signature instanceof Sha256WithRsaSignature) {
            if (((Sha256WithRsaSignature)signature).getValidityPeriod().hasPeriod()) {
                Tlv0_2WireFormat.encodeValidityPeriod(((Sha256WithRsaSignature)signature).getValidityPeriod(), encoder);
            }
            Tlv0_2WireFormat.encodeKeyLocator(28, ((Sha256WithRsaSignature)signature).getKeyLocator(), encoder);
            encoder.writeNonNegativeIntegerTlv(27, 1L);
        } else if (signature instanceof Sha256WithEcdsaSignature) {
            if (((Sha256WithEcdsaSignature)signature).getValidityPeriod().hasPeriod()) {
                Tlv0_2WireFormat.encodeValidityPeriod(((Sha256WithEcdsaSignature)signature).getValidityPeriod(), encoder);
            }
            Tlv0_2WireFormat.encodeKeyLocator(28, ((Sha256WithEcdsaSignature)signature).getKeyLocator(), encoder);
            encoder.writeNonNegativeIntegerTlv(27, 3L);
        } else if (signature instanceof HmacWithSha256Signature) {
            Tlv0_2WireFormat.encodeKeyLocator(28, ((HmacWithSha256Signature)signature).getKeyLocator(), encoder);
            encoder.writeNonNegativeIntegerTlv(27, 4L);
        } else if (signature instanceof DigestSha256Signature) {
            encoder.writeNonNegativeIntegerTlv(27, 0L);
        } else {
            throw new Error("encodeSignatureInfo: Unrecognized Signature object type");
        }
        encoder.writeTypeAndLength(22, encoder.getLength() - saveLength);
    }

    private static void decodeSignatureInfo(SignatureHolder signatureHolder, TlvDecoder decoder, boolean copy) throws EncodingException {
        int beginOffset = decoder.getOffset();
        int endOffset = decoder.readNestedTlvsStart(22);
        int signatureType = (int)decoder.readNonNegativeIntegerTlv(27);
        if (signatureType == 1) {
            signatureHolder.setSignature(new Sha256WithRsaSignature());
            Sha256WithRsaSignature signatureInfo = (Sha256WithRsaSignature)signatureHolder.getSignature();
            Tlv0_2WireFormat.decodeKeyLocator(28, signatureInfo.getKeyLocator(), decoder, copy);
            if (decoder.peekType(253, endOffset)) {
                Tlv0_2WireFormat.decodeValidityPeriod(signatureInfo.getValidityPeriod(), decoder);
            }
        } else if (signatureType == 3) {
            signatureHolder.setSignature(new Sha256WithEcdsaSignature());
            Sha256WithEcdsaSignature signatureInfo = (Sha256WithEcdsaSignature)signatureHolder.getSignature();
            Tlv0_2WireFormat.decodeKeyLocator(28, signatureInfo.getKeyLocator(), decoder, copy);
            if (decoder.peekType(253, endOffset)) {
                Tlv0_2WireFormat.decodeValidityPeriod(signatureInfo.getValidityPeriod(), decoder);
            }
        } else if (signatureType == 4) {
            signatureHolder.setSignature(new HmacWithSha256Signature());
            HmacWithSha256Signature signatureInfo = (HmacWithSha256Signature)signatureHolder.getSignature();
            Tlv0_2WireFormat.decodeKeyLocator(28, signatureInfo.getKeyLocator(), decoder, copy);
        } else if (signatureType == 0) {
            signatureHolder.setSignature(new DigestSha256Signature());
        } else {
            signatureHolder.setSignature(new GenericSignature());
            GenericSignature signatureInfo = (GenericSignature)signatureHolder.getSignature();
            signatureInfo.setSignatureInfoEncoding(new Blob(decoder.getSlice(beginOffset, endOffset), copy), signatureType);
            decoder.finishNestedTlvs(endOffset, true);
        }
        decoder.finishNestedTlvs(endOffset);
    }

    private static void encodeMetaInfo(MetaInfo metaInfo, TlvEncoder encoder) {
        int saveLength = encoder.getLength();
        ByteBuffer finalBlockIdBuf = metaInfo.getFinalBlockId().getValue().buf();
        if (finalBlockIdBuf != null && finalBlockIdBuf.remaining() > 0) {
            int finalBlockIdSaveLength = encoder.getLength();
            Tlv0_2WireFormat.encodeNameComponent(metaInfo.getFinalBlockId(), encoder);
            encoder.writeTypeAndLength(26, encoder.getLength() - finalBlockIdSaveLength);
        }
        encoder.writeOptionalNonNegativeIntegerTlvFromDouble(25, metaInfo.getFreshnessPeriod());
        if (metaInfo.getType() != ContentType.BLOB) {
            if (metaInfo.getType() == ContentType.LINK || metaInfo.getType() == ContentType.KEY || metaInfo.getType() == ContentType.NACK) {
                encoder.writeNonNegativeIntegerTlv(24, metaInfo.getType().getNumericType());
            } else if (metaInfo.getType() == ContentType.OTHER_CODE) {
                encoder.writeNonNegativeIntegerTlv(24, metaInfo.getOtherTypeCode());
            } else {
                throw new Error("unrecognized TLV ContentType");
            }
        }
        encoder.writeTypeAndLength(20, encoder.getLength() - saveLength);
    }

    private static void decodeMetaInfo(MetaInfo metaInfo, TlvDecoder decoder, boolean copy) throws EncodingException {
        int endOffset = decoder.readNestedTlvsStart(20);
        int type = (int)decoder.readOptionalNonNegativeIntegerTlv(24, endOffset);
        if (type < 0 || type == ContentType.BLOB.getNumericType()) {
            metaInfo.setType(ContentType.BLOB);
        } else if (type == ContentType.LINK.getNumericType()) {
            metaInfo.setType(ContentType.LINK);
        } else if (type == ContentType.KEY.getNumericType()) {
            metaInfo.setType(ContentType.KEY);
        } else if (type == ContentType.NACK.getNumericType()) {
            metaInfo.setType(ContentType.NACK);
        } else {
            metaInfo.setType(ContentType.OTHER_CODE);
            metaInfo.setOtherTypeCode(type);
        }
        metaInfo.setFreshnessPeriod(decoder.readOptionalNonNegativeIntegerTlv(25, endOffset));
        if (decoder.peekType(26, endOffset)) {
            int finalBlockIdEndOffset = decoder.readNestedTlvsStart(26);
            metaInfo.setFinalBlockId(Tlv0_2WireFormat.decodeNameComponent(decoder, copy));
            decoder.finishNestedTlvs(finalBlockIdEndOffset);
        } else {
            metaInfo.setFinalBlockId(null);
        }
        decoder.finishNestedTlvs(endOffset);
    }

    private static void encodeControlParameters(ControlParameters controlParameters, TlvEncoder encoder) {
        int flags;
        int saveLength = encoder.getLength();
        encoder.writeOptionalNonNegativeIntegerTlvFromDouble(109, controlParameters.getExpirationPeriod());
        if (controlParameters.getStrategy().size() != 0) {
            int strategySaveLength = encoder.getLength();
            Tlv0_2WireFormat.encodeName(controlParameters.getStrategy(), new int[1], new int[1], encoder);
            encoder.writeTypeAndLength(107, encoder.getLength() - strategySaveLength);
        }
        if ((flags = controlParameters.getForwardingFlags().getNfdForwardingFlags()) != new RegistrationOptions().getNfdForwardingFlags()) {
            encoder.writeNonNegativeIntegerTlv(108, flags);
        }
        encoder.writeOptionalNonNegativeIntegerTlv(106, controlParameters.getCost());
        encoder.writeOptionalNonNegativeIntegerTlv(111, controlParameters.getOrigin());
        encoder.writeOptionalNonNegativeIntegerTlv(110, controlParameters.getLocalControlFeature());
        if (controlParameters.getUri().length() != 0) {
            encoder.writeBlobTlv(114, new Blob(controlParameters.getUri()).buf());
        }
        encoder.writeOptionalNonNegativeIntegerTlv(105, controlParameters.getFaceId());
        if (controlParameters.getName() != null) {
            Tlv0_2WireFormat.encodeName(controlParameters.getName(), new int[1], new int[1], encoder);
        }
        encoder.writeTypeAndLength(104, encoder.getLength() - saveLength);
    }

    private static void decodeControlParameters(ControlParameters controlParameters, TlvDecoder decoder, boolean copy) throws EncodingException {
        controlParameters.clear();
        int endOffset = decoder.readNestedTlvsStart(104);
        if (decoder.peekType(7, endOffset)) {
            Name name = new Name();
            Tlv0_2WireFormat.decodeName(name, new int[1], new int[1], decoder, copy);
            controlParameters.setName(name);
        }
        controlParameters.setFaceId((int)decoder.readOptionalNonNegativeIntegerTlv(105, endOffset));
        if (decoder.peekType(114, endOffset)) {
            Blob uri = new Blob(decoder.readOptionalBlobTlv(114, endOffset), false);
            controlParameters.setUri("" + uri);
        }
        decoder.skipOptionalTlv(129, endOffset);
        controlParameters.setLocalControlFeature((int)decoder.readOptionalNonNegativeIntegerTlv(110, endOffset));
        controlParameters.setOrigin((int)decoder.readOptionalNonNegativeIntegerTlv(111, endOffset));
        controlParameters.setCost((int)decoder.readOptionalNonNegativeIntegerTlv(106, endOffset));
        decoder.skipOptionalTlv(131, endOffset);
        decoder.skipOptionalTlv(132, endOffset);
        decoder.skipOptionalTlv(135, endOffset);
        decoder.skipOptionalTlv(136, endOffset);
        decoder.skipOptionalTlv(137, endOffset);
        if (decoder.peekType(108, endOffset)) {
            RegistrationOptions flags = new RegistrationOptions();
            flags.setNfdForwardingFlags((int)decoder.readNonNegativeIntegerTlv(108));
            controlParameters.setForwardingFlags(flags);
        }
        decoder.skipOptionalTlv(112, endOffset);
        if (decoder.peekType(107, endOffset)) {
            int strategyEndOffset = decoder.readNestedTlvsStart(107);
            Tlv0_2WireFormat.decodeName(controlParameters.getStrategy(), new int[1], new int[1], decoder, copy);
            decoder.finishNestedTlvs(strategyEndOffset);
        }
        controlParameters.setExpirationPeriod(decoder.readOptionalNonNegativeIntegerTlv(109, endOffset));
        decoder.finishNestedTlvs(endOffset, true);
    }

    private static void encodeDelegationSet(DelegationSet delegationSet, TlvEncoder encoder) {
        for (int i = delegationSet.size() - 1; i >= 0; --i) {
            int saveLength = encoder.getLength();
            Tlv0_2WireFormat.encodeName(delegationSet.get(i).getName(), new int[1], new int[1], encoder);
            encoder.writeNonNegativeIntegerTlv(30, delegationSet.get(i).getPreference());
            encoder.writeTypeAndLength(31, encoder.getLength() - saveLength);
        }
    }

    private static void decodeDelegationSet(DelegationSet delegationSet, int endOffset, TlvDecoder decoder, boolean copy) throws EncodingException {
        delegationSet.clear();
        while (decoder.getOffset() < endOffset) {
            decoder.readTypeAndLength(31);
            int preference = (int)decoder.readNonNegativeIntegerTlv(30);
            Name name = new Name();
            Tlv0_2WireFormat.decodeName(name, new int[1], new int[1], decoder, copy);
            delegationSet.addUnsorted(preference, name);
        }
    }

    private static Blob encodeInterestV03(Interest interest, int[] signedPortionBeginOffset, int[] signedPortionEndOffset) {
        ByteBuffer nonce;
        TlvEncoder encoder = new TlvEncoder(256);
        int saveLength = encoder.getLength();
        encoder.writeOptionalBlobTlv(35, interest.getApplicationParameters().buf());
        encoder.writeOptionalNonNegativeIntegerTlvFromDouble(12, interest.getInterestLifetimeMilliseconds());
        if (interest.getNonce().size() == 0) {
            nonce = ByteBuffer.allocate(4);
            random_.nextBytes(nonce.array());
            encoder.writeBlobTlv(10, nonce);
        } else if (interest.getNonce().size() < 4) {
            nonce = ByteBuffer.allocate(4);
            nonce.put(interest.getNonce().buf());
            for (int i = 0; i < 4 - interest.getNonce().size(); ++i) {
                nonce.put((byte)random_.nextInt());
            }
            nonce.flip();
            encoder.writeBlobTlv(10, nonce);
        } else if (interest.getNonce().size() == 4) {
            encoder.writeBlobTlv(10, interest.getNonce().buf());
        } else {
            nonce = interest.getNonce().buf();
            nonce.limit(nonce.position() + 4);
            encoder.writeBlobTlv(10, nonce);
        }
        if (interest.getForwardingHint().size() > 0) {
            if (interest.getSelectedDelegationIndex() >= 0) {
                throw new Error("An Interest may not have a selected delegation when encoding a forwarding hint");
            }
            if (interest.hasLink()) {
                throw new Error("An Interest may not have a link object when encoding a forwarding hint");
            }
            int forwardingHintSaveLength = encoder.getLength();
            Tlv0_2WireFormat.encodeDelegationSet(interest.getForwardingHint(), encoder);
            encoder.writeTypeAndLength(30, encoder.getLength() - forwardingHintSaveLength);
        }
        if (interest.getMustBeFresh()) {
            encoder.writeTypeAndLength(18, 0);
        }
        if (interest.getCanBePrefix()) {
            encoder.writeTypeAndLength(33, 0);
        }
        int[] tempSignedPortionBeginOffset = new int[1];
        int[] tempSignedPortionEndOffset = new int[1];
        Tlv0_2WireFormat.encodeName(interest.getName(), tempSignedPortionBeginOffset, tempSignedPortionEndOffset, encoder);
        int signedPortionBeginOffsetFromBack = encoder.getLength() - tempSignedPortionBeginOffset[0];
        int signedPortionEndOffsetFromBack = encoder.getLength() - tempSignedPortionEndOffset[0];
        encoder.writeTypeAndLength(5, encoder.getLength() - saveLength);
        signedPortionBeginOffset[0] = encoder.getLength() - signedPortionBeginOffsetFromBack;
        signedPortionEndOffset[0] = encoder.getLength() - signedPortionEndOffsetFromBack;
        return new Blob(encoder.getOutput(), false);
    }

    private static void decodeInterestV03(Interest interest, ByteBuffer input, int[] signedPortionBeginOffset, int[] signedPortionEndOffset, boolean copy) throws EncodingException {
        TlvDecoder decoder = new TlvDecoder(input);
        int endOffset = decoder.readNestedTlvsStart(5);
        Tlv0_2WireFormat.decodeName(interest.getName(), signedPortionBeginOffset, signedPortionEndOffset, decoder, copy);
        interest.setCanBePrefix(decoder.readBooleanTlv(33, endOffset));
        interest.setMustBeFresh(decoder.readBooleanTlv(18, endOffset));
        if (decoder.peekType(30, endOffset)) {
            int forwardingHintEndOffset = decoder.readNestedTlvsStart(30);
            Tlv0_2WireFormat.decodeDelegationSet(interest.getForwardingHint(), forwardingHintEndOffset, decoder, copy);
            decoder.finishNestedTlvs(forwardingHintEndOffset);
        } else {
            interest.getForwardingHint().clear();
        }
        ByteBuffer nonce = decoder.readOptionalBlobTlv(10, endOffset);
        interest.setInterestLifetimeMilliseconds(decoder.readOptionalNonNegativeIntegerTlv(12, endOffset));
        interest.setMinSuffixComponents(-1);
        interest.getKeyLocator().clear();
        interest.getExclude().clear();
        interest.setChildSelector(-1);
        interest.unsetLink();
        interest.setSelectedDelegationIndex(-1);
        decoder.readOptionalBlobTlv(34, endOffset);
        interest.setApplicationParameters(new Blob(decoder.readOptionalBlobTlv(35, endOffset), copy));
        decoder.readOptionalBlobTlv(35, endOffset);
        interest.setNonce(new Blob(nonce, copy));
        decoder.finishNestedTlvs(endOffset);
    }

    private static class SimpleSignatureHolder
    implements SignatureHolder {
        private Signature signature_;

        private SimpleSignatureHolder() {
        }

        @Override
        public Data setSignature(Signature signature) {
            this.signature_ = signature;
            return null;
        }

        @Override
        public Signature getSignature() {
            return this.signature_;
        }
    }
}

