/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn;

import net.named_data.jndn.ContentType;
import net.named_data.jndn.Data;
import net.named_data.jndn.DelegationSet;
import net.named_data.jndn.Name;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.util.Blob;

public class Link
extends Data {
    private final DelegationSet delegations_ = new DelegationSet();

    public Link() {
        this.getMetaInfo().setType(ContentType.LINK);
    }

    public Link(Name name) {
        super(name);
        this.getMetaInfo().setType(ContentType.LINK);
    }

    public Link(Data data) {
        super(data);
        if (!this.getContent().isNull()) {
            try {
                this.delegations_.wireDecode(this.getContent());
                this.getMetaInfo().setType(ContentType.LINK);
            }
            catch (EncodingException ex) {
                this.delegations_.clear();
            }
        }
    }

    @Override
    public void wireDecode(Blob input, WireFormat wireFormat) throws EncodingException {
        super.wireDecode(input, wireFormat);
        if (this.getMetaInfo().getType() != ContentType.LINK) {
            throw new EncodingException("Link.wireDecode: MetaInfo ContentType is not LINK.");
        }
        this.delegations_.wireDecode(this.getContent());
    }

    public final Link addDelegation(int preference, Name name, WireFormat wireFormat) {
        this.delegations_.add(preference, name);
        this.encodeContent(wireFormat);
        return this;
    }

    public final Link addDelegation(int preference, Name name) {
        return this.addDelegation(preference, name, WireFormat.getDefaultWireFormat());
    }

    public final boolean removeDelegation(Name name, WireFormat wireFormat) {
        boolean wasRemoved = this.delegations_.remove(name);
        if (wasRemoved) {
            this.encodeContent(wireFormat);
        }
        return wasRemoved;
    }

    public final boolean removeDelegation(Name name) {
        return this.removeDelegation(name, WireFormat.getDefaultWireFormat());
    }

    public final DelegationSet getDelegations() {
        return this.delegations_;
    }

    private void encodeContent(WireFormat wireFormat) {
        this.setContent(this.delegations_.wireEncode(wireFormat));
        this.getMetaInfo().setType(ContentType.LINK);
    }
}

