/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.util.regex;

import net.named_data.jndn.Name;
import net.named_data.jndn.util.regex.NdnRegexBackrefManager;
import net.named_data.jndn.util.regex.NdnRegexMatcherBase;
import net.named_data.jndn.util.regex.NdnRegexPatternListMatcher;

public class NdnRegexTopMatcher
extends NdnRegexMatcherBase {
    private final String expand_;
    private NdnRegexPatternListMatcher primaryMatcher_ = null;
    private NdnRegexPatternListMatcher secondaryMatcher_ = null;
    private final NdnRegexBackrefManager primaryBackrefManager_ = new NdnRegexBackrefManager();
    private final NdnRegexBackrefManager secondaryBackrefManager_ = new NdnRegexBackrefManager();
    private boolean isSecondaryUsed_ = false;

    public NdnRegexTopMatcher(String expr, String expand) throws NdnRegexMatcherBase.Error {
        super(expr, NdnRegexMatcherBase.NdnRegexExprType.TOP);
        this.expand_ = expand;
        this.compile();
    }

    public NdnRegexTopMatcher(String expr) throws NdnRegexMatcherBase.Error {
        super(expr, NdnRegexMatcherBase.NdnRegexExprType.TOP);
        this.expand_ = "";
        this.compile();
    }

    public final boolean match(Name name) throws NdnRegexMatcherBase.Error {
        this.isSecondaryUsed_ = false;
        this.matchResult_.clear();
        if (this.primaryMatcher_.match(name, 0, name.size())) {
            this.matchResult_.clear();
            for (Name.Component component : this.primaryMatcher_.getMatchResult()) {
                this.matchResult_.add(component);
            }
            return true;
        }
        if (this.secondaryMatcher_ != null && this.secondaryMatcher_.match(name, 0, name.size())) {
            this.matchResult_.clear();
            for (Name.Component component : this.secondaryMatcher_.getMatchResult()) {
                this.matchResult_.add(component);
            }
            this.isSecondaryUsed_ = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean match(Name name, int offset, int len) throws NdnRegexMatcherBase.Error {
        return this.match(name);
    }

    public Name expand(String expandStr) throws NdnRegexMatcherBase.Error {
        Name result = new Name();
        NdnRegexBackrefManager backrefManager = this.isSecondaryUsed_ ? this.secondaryBackrefManager_ : this.primaryBackrefManager_;
        int backrefNo = backrefManager.size();
        String expand = !expandStr.equals("") ? expandStr : this.expand_;
        int[] offset = new int[]{0};
        while (offset[0] < expand.length()) {
            String item = NdnRegexTopMatcher.getItemFromExpand(expand, offset);
            if (item.charAt(0) == '<') {
                result.append(item.substring(1, item.length() - 1));
            }
            if (item.charAt(0) != '\\') continue;
            int index = Integer.parseInt(item.substring(1, item.length()));
            if (0 == index) {
                for (Name.Component component : this.matchResult_) {
                    result.append(component);
                }
                continue;
            }
            if (index <= backrefNo) {
                for (Name.Component component : backrefManager.getBackref(index - 1).getMatchResult()) {
                    result.append(component);
                }
                continue;
            }
            throw new NdnRegexMatcherBase.Error("Exceed the range of back reference");
        }
        return result;
    }

    public Name expand() throws NdnRegexMatcherBase.Error {
        return this.expand("");
    }

    public static NdnRegexTopMatcher fromName(Name name, boolean hasAnchor) throws NdnRegexMatcherBase.Error {
        String regexStr = "^";
        for (int i = 0; i < name.size(); ++i) {
            regexStr = regexStr + "<";
            regexStr = regexStr + NdnRegexTopMatcher.convertSpecialChar(name.get(i).toEscapedString());
            regexStr = regexStr + ">";
        }
        if (hasAnchor) {
            regexStr = regexStr + "$";
        }
        return new NdnRegexTopMatcher(regexStr);
    }

    public static NdnRegexTopMatcher fromName(Name name) throws NdnRegexMatcherBase.Error {
        return NdnRegexTopMatcher.fromName(name, false);
    }

    @Override
    protected void compile() throws NdnRegexMatcherBase.Error {
        String errMsg = "Error: RegexTopMatcher.Compile(): ";
        String expr = this.expr_;
        if ('^' != (expr = '$' != expr.charAt(expr.length() - 1) ? expr + "<.*>*" : expr.substring(0, expr.length() - 1)).charAt(0)) {
            this.secondaryMatcher_ = new NdnRegexPatternListMatcher("<.*>*" + expr, this.secondaryBackrefManager_);
        } else {
            expr = expr.substring(1, expr.length());
        }
        this.primaryMatcher_ = new NdnRegexPatternListMatcher(expr, this.primaryBackrefManager_);
    }

    private static String getItemFromExpand(String expand, int[] offset) throws NdnRegexMatcherBase.Error {
        int begin = offset[0];
        if (expand.charAt(offset[0]) == '\\') {
            offset[0] = offset[0] + 1;
            if (offset[0] >= expand.length()) {
                throw new NdnRegexMatcherBase.Error("Wrong format of expand string!");
            }
            while (offset[0] < expand.length() && expand.charAt(offset[0]) <= '9' && expand.charAt(offset[0]) >= '0') {
                offset[0] = offset[0] + 1;
                if (offset[0] <= expand.length()) continue;
                throw new NdnRegexMatcherBase.Error("Wrong format of expand string!");
            }
            if (offset[0] > begin + 1) {
                return expand.substring(begin, offset[0]);
            }
            throw new NdnRegexMatcherBase.Error("Wrong format of expand string!");
        }
        if (expand.charAt(offset[0]) == '<') {
            offset[0] = offset[0] + 1;
            if (offset[0] >= expand.length()) {
                throw new NdnRegexMatcherBase.Error("Wrong format of expand string!");
            }
            int left = 1;
            int right = 0;
            while (right < left) {
                if (expand.charAt(offset[0]) == '<') {
                    ++left;
                }
                if (expand.charAt(offset[0]) == '>') {
                    ++right;
                }
                offset[0] = offset[0] + 1;
                if (offset[0] < expand.length()) continue;
                throw new NdnRegexMatcherBase.Error("Wrong format of expand string!");
            }
            return expand.substring(begin, offset[0]);
        }
        throw new NdnRegexMatcherBase.Error("Wrong format of expand string!");
    }

    private static String convertSpecialChar(String str) {
        String newStr = "";
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '.' || c == '[' || c == '{' || c == '}' || c == '(' || c == ')' || c == '\\' || c == '*' || c == '+' || c == '?' || c == '|' || c == '^' || c == '$') {
                newStr = newStr + '\\';
                newStr = newStr + c;
                continue;
            }
            newStr = newStr + c;
        }
        return newStr;
    }
}

