/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.util;

import net.named_data.jndn.Interest;
import net.named_data.jndn.Name;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.security.CommandInterestPreparer;
import net.named_data.jndn.security.KeyChain;
import net.named_data.jndn.security.SecurityException;

public class CommandInterestGenerator
extends CommandInterestPreparer {
    public void generate(Interest interest, KeyChain keyChain, Name certificateName, WireFormat wireFormat) throws SecurityException {
        this.prepareCommandInterestName(interest, wireFormat);
        keyChain.sign(interest, certificateName, wireFormat);
        if (interest.getInterestLifetimeMilliseconds() < 0.0) {
            interest.setInterestLifetimeMilliseconds(1000.0);
        }
    }

    public void generate(Interest interest, KeyChain keyChain, Name certificateName) throws SecurityException {
        this.generate(interest, keyChain, certificateName, WireFormat.getDefaultWireFormat());
    }
}

