/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.v2;

import java.util.ArrayList;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.Interest;
import net.named_data.jndn.Name;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encrypt.Schedule;
import net.named_data.jndn.security.v2.CertificateV2;
import net.named_data.jndn.util.Common;

public class CertificateCacheV2 {
    private final TreeMap certificatesByName_ = new TreeMap();
    private double nextRefreshTime_ = Double.MAX_VALUE;
    private final double maxLifetimeMilliseconds_;
    private static final Logger logger_ = Logger.getLogger(CertificateCacheV2.class.getName());
    private double nowOffsetMilliseconds_ = 0.0;
    private static Common dummyCommon_ = new Common();

    public CertificateCacheV2(double maxLifetimeMilliseconds) {
        this.maxLifetimeMilliseconds_ = maxLifetimeMilliseconds;
    }

    public CertificateCacheV2() {
        this.maxLifetimeMilliseconds_ = CertificateCacheV2.getDefaultLifetime();
    }

    public final void insert(CertificateV2 certificate) throws CertificateV2.Error {
        double now;
        double notAfterTime = certificate.getValidityPeriod().getNotAfter();
        if (notAfterTime < (now = Common.getNowMilliseconds() + this.nowOffsetMilliseconds_)) {
            logger_.log(Level.FINE, "Not adding {0}: already expired at {1}", new Object[]{certificate.getName().toUri(), Schedule.toIsoString(notAfterTime)});
            return;
        }
        double removalTime = Math.min(notAfterTime, now + this.maxLifetimeMilliseconds_);
        if (removalTime < this.nextRefreshTime_) {
            this.nextRefreshTime_ = removalTime;
        }
        double removalHours = (removalTime - now) / 3600000.0;
        logger_.log(Level.FINE, "Adding {0}, will remove in {1} hours", new Object[]{certificate.getName().toUri(), removalHours});
        CertificateV2 certificateCopy = new CertificateV2(certificate);
        this.certificatesByName_.put(certificateCopy.getName(), new Entry(certificateCopy, removalTime));
    }

    public final CertificateV2 find(Name certificatePrefix) {
        if (certificatePrefix.size() > 0 && certificatePrefix.get(-1).isImplicitSha256Digest()) {
            logger_.log(Level.FINE, "Certificate search using a name with an implicit digest is not yet supported");
        }
        this.refresh();
        Name entryKey = this.certificatesByName_.ceilingKey(certificatePrefix);
        if (entryKey == null) {
            return null;
        }
        CertificateV2 certificate = ((Entry)this.certificatesByName_.get((Object)entryKey)).certificate_;
        if (!certificatePrefix.isPrefixOf(certificate.getName())) {
            return null;
        }
        return certificate;
    }

    public final CertificateV2 find(Interest interest) {
        if (interest.getChildSelector() >= 0) {
            logger_.log(Level.FINE, "Certificate search using a ChildSelector is not supported. Searching as if this selector not specified");
        }
        if (interest.getName().size() > 0 && interest.getName().get(-1).isImplicitSha256Digest()) {
            logger_.log(Level.FINE, "Certificate search using a name with an implicit digest is not yet supported");
        }
        this.refresh();
        Name firstKey = this.certificatesByName_.ceilingKey(interest.getName());
        if (firstKey == null) {
            return null;
        }
        for (Object e : this.certificatesByName_.navigableKeySet().tailSet(firstKey)) {
            CertificateV2 certificate = ((Entry)this.certificatesByName_.get((Object)((Name)e))).certificate_;
            if (!interest.getName().isPrefixOf(certificate.getName())) break;
            try {
                if (!interest.matchesData(certificate)) continue;
                return certificate;
            }
            catch (EncodingException ex) {
                throw new Error("Error in Interest.matchesData: " + ex);
            }
        }
        return null;
    }

    public final void deleteCertificate(Name certificateName) {
        this.certificatesByName_.remove(certificateName);
    }

    public final void clear() {
        this.certificatesByName_.clear();
        this.nextRefreshTime_ = Double.MAX_VALUE;
    }

    public static double getDefaultLifetime() {
        return 3600000.0;
    }

    public final void setNowOffsetMilliseconds_(double nowOffsetMilliseconds) {
        this.nowOffsetMilliseconds_ = nowOffsetMilliseconds;
    }

    private void refresh() {
        double now = Common.getNowMilliseconds() + this.nowOffsetMilliseconds_;
        if (now < this.nextRefreshTime_) {
            return;
        }
        double nextRefreshTime = Double.MAX_VALUE;
        ArrayList<Name> namesToErase = new ArrayList<Name>();
        for (Object key : this.certificatesByName_.keySet()) {
            Name name = (Name)key;
            Entry entry = (Entry)this.certificatesByName_.get(name);
            if (entry.removalTime_ <= now) {
                namesToErase.add(name);
                continue;
            }
            nextRefreshTime = Math.min(nextRefreshTime, entry.removalTime_);
        }
        this.nextRefreshTime_ = nextRefreshTime;
        for (int i = 0; i < namesToErase.size(); ++i) {
            this.certificatesByName_.remove(namesToErase.get(i));
        }
    }

    private static class Entry {
        public final CertificateV2 certificate_;
        public final double removalTime_;

        public Entry(CertificateV2 certificate, double removalTime) {
            this.certificate_ = certificate;
            this.removalTime_ = removalTime;
        }
    }
}

