/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.identity;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.KeyLocator;
import net.named_data.jndn.Name;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.security.KeyType;
import net.named_data.jndn.security.SecurityException;
import net.named_data.jndn.security.certificate.IdentityCertificate;
import net.named_data.jndn.security.identity.Sqlite3IdentityStorageBase;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.Common;

public class BasicIdentityStorage
extends Sqlite3IdentityStorageBase {
    Connection database_ = null;

    public BasicIdentityStorage() throws SecurityException {
        File identityDir = BasicIdentityStorage.getDefaultDatabaseDirectoryPath();
        identityDir.mkdirs();
        File databasePath = new File(identityDir, "ndnsec-public-info.db");
        this.construct(databasePath.getAbsolutePath());
    }

    public BasicIdentityStorage(String databaseFilePath) throws SecurityException {
        this.construct(databaseFilePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void construct(String databaseFilePath) throws SecurityException {
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(BasicIdentityStorage.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        try {
            this.database_ = DriverManager.getConnection("jdbc:sqlite:" + databaseFilePath);
            try (Statement statement = this.database_.createStatement();){
                ResultSet result = statement.executeQuery("SELECT name FROM sqlite_master WHERE type='table' And name='TpmInfo'");
                boolean tpmInfoTableExists = false;
                if (result.next()) {
                    tpmInfoTableExists = true;
                }
                result.close();
                if (!tpmInfoTableExists) {
                    statement.executeUpdate("CREATE TABLE IF NOT EXISTS                                           \n  TpmInfo(                                                           \n      tpm_locator BLOB NOT NULL,                                     \n      PRIMARY KEY (tpm_locator)                                      \n  );                                                                 \n");
                }
                result = statement.executeQuery("SELECT name FROM sqlite_master WHERE type='table' And name='Identity'");
                boolean idTableExists = false;
                if (result.next()) {
                    idTableExists = true;
                }
                result.close();
                if (!idTableExists) {
                    statement.executeUpdate("CREATE TABLE IF NOT EXISTS                                           \n  Identity(                                                          \n      identity_name     BLOB NOT NULL,                               \n      default_identity  INTEGER DEFAULT 0,                           \n                                                                     \n      PRIMARY KEY (identity_name)                                    \n  );                                                                 \n                                                                     \n");
                    statement.executeUpdate("CREATE INDEX identity_index ON Identity(identity_name);              \n");
                }
                result = statement.executeQuery("SELECT name FROM sqlite_master WHERE type='table' And name='Key'");
                idTableExists = false;
                if (result.next()) {
                    idTableExists = true;
                }
                result.close();
                if (!idTableExists) {
                    statement.executeUpdate("CREATE TABLE IF NOT EXISTS                                           \n  Key(                                                               \n      identity_name     BLOB NOT NULL,                               \n      key_identifier    BLOB NOT NULL,                               \n      key_type          INTEGER,                                     \n      public_key        BLOB,                                        \n      default_key       INTEGER DEFAULT 0,                           \n      active            INTEGER DEFAULT 0,                           \n                                                                     \n      PRIMARY KEY (identity_name, key_identifier)                    \n  );                                                                 \n                                                                     \n");
                    statement.executeUpdate("CREATE INDEX key_index ON Key(identity_name);                        \n");
                }
                result = statement.executeQuery("SELECT name FROM sqlite_master WHERE type='table' And name='Certificate'");
                idTableExists = false;
                if (result.next()) {
                    idTableExists = true;
                }
                result.close();
                if (!idTableExists) {
                    statement.executeUpdate("CREATE TABLE IF NOT EXISTS                                           \n  Certificate(                                                       \n      cert_name         BLOB NOT NULL,                               \n      cert_issuer       BLOB NOT NULL,                               \n      identity_name     BLOB NOT NULL,                               \n      key_identifier    BLOB NOT NULL,                               \n      not_before        TIMESTAMP,                                   \n      not_after         TIMESTAMP,                                   \n      certificate_data  BLOB NOT NULL,                               \n      valid_flag        INTEGER DEFAULT 1,                           \n      default_cert      INTEGER DEFAULT 0,                           \n                                                                     \n      PRIMARY KEY (cert_name)                                        \n  );                                                                 \n                                                                     \n");
                    statement.executeUpdate("CREATE INDEX cert_index ON Certificate(cert_name);           \n");
                    statement.executeUpdate("CREATE INDEX subject ON Certificate(identity_name);          \n");
                }
            }
        }
        catch (SQLException exception) {
            throw new SecurityException("BasicIdentityStorage: SQLite error: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean doesIdentityExist(Name identityName) throws SecurityException {
        try {
            statement.setString(1, identityName.toUri());
            try (PreparedStatement statement = this.database_.prepareStatement("SELECT count(*) FROM Identity WHERE identity_name=?");){
                ResultSet result = statement.executeQuery();
                if (result.next()) {
                    boolean bl = result.getInt(1) > 0;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
        catch (SQLException exception) {
            throw new SecurityException("BasicIdentityStorage: SQLite error: " + exception);
        }
    }

    @Override
    public final void addIdentity(Name identityName) throws SecurityException {
        if (this.doesIdentityExist(identityName)) {
            return;
        }
        try {
            statement.setString(1, identityName.toUri());
            try (PreparedStatement statement = this.database_.prepareStatement("INSERT INTO Identity (identity_name) values (?)");){
                statement.executeUpdate();
            }
        }
        catch (SQLException exception) {
            throw new SecurityException("BasicIdentityStorage: SQLite error: " + exception);
        }
    }

    @Override
    public final boolean revokeIdentity() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean doesKeyExist(Name keyName) throws SecurityException {
        String keyId = keyName.get(-1).toEscapedString();
        Name identityName = keyName.getPrefix(-1);
        try {
            PreparedStatement statement = this.database_.prepareStatement("SELECT count(*) FROM Key WHERE identity_name=? AND key_identifier=?");
            statement.setString(1, identityName.toUri());
            statement.setString(2, keyId);
            try {
                ResultSet result = statement.executeQuery();
                if (result.next()) {
                    boolean bl = result.getInt(1) > 0;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException exception) {
            throw new SecurityException("BasicIdentityStorage: SQLite error: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addKey(Name keyName, KeyType keyType, Blob publicKeyDer) throws SecurityException {
        if (keyName.size() == 0) {
            return;
        }
        if (this.doesKeyExist(keyName)) {
            return;
        }
        String keyId = keyName.get(-1).toEscapedString();
        Name identityName = keyName.getPrefix(-1);
        this.addIdentity(identityName);
        try {
            PreparedStatement statement = this.database_.prepareStatement("INSERT INTO Key (identity_name, key_identifier, key_type, public_key) values (?, ?, ?, ?)");
            statement.setString(1, identityName.toUri());
            statement.setString(2, keyId);
            statement.setInt(3, keyType.getNumericType());
            statement.setBytes(4, publicKeyDer.getImmutableArray());
            try {
                statement.executeUpdate();
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException exception) {
            throw new SecurityException("BasicIdentityStorage: SQLite error: " + exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Blob getKey(Name keyName) throws SecurityException {
        if (keyName.size() == 0) {
            throw new SecurityException("BasicIdentityStorage.getKey: Empty keyName");
        }
        String keyId = keyName.get(-1).toEscapedString();
        Name identityName = keyName.getPrefix(-1);
        try {
            PreparedStatement statement = this.database_.prepareStatement("SELECT public_key FROM Key WHERE identity_name=? AND key_identifier=?");
            statement.setString(1, identityName.toUri());
            statement.setString(2, keyId);
            try {
                ResultSet result = statement.executeQuery();
                if (!result.next()) throw new SecurityException("BasicIdentityStorage.getKey: The key does not exist");
                Blob blob = new Blob(result.getBytes("public_key"), false);
                return blob;
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException exception) {
            throw new SecurityException("BasicIdentityStorage: SQLite error: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateKeyStatus(Name keyName, boolean isActive) throws SecurityException {
        String keyId = keyName.get(-1).toEscapedString();
        Name identityName = keyName.getPrefix(-1);
        try {
            PreparedStatement statement = this.database_.prepareStatement("UPDATE Key SET active=? WHERE identity_name=? AND key_identifier=?");
            statement.setInt(1, isActive ? 1 : 0);
            statement.setString(2, identityName.toUri());
            statement.setString(3, keyId);
            try {
                statement.executeUpdate();
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException exception) {
            throw new SecurityException("BasicIdentityStorage: SQLite error: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean doesCertificateExist(Name certificateName) throws SecurityException {
        try {
            statement.setString(1, certificateName.toUri());
            try (PreparedStatement statement = this.database_.prepareStatement("SELECT count(*) FROM Certificate WHERE cert_name=?");){
                ResultSet result = statement.executeQuery();
                if (result.next()) {
                    boolean bl = result.getInt(1) > 0;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
        catch (SQLException exception) {
            throw new SecurityException("BasicIdentityStorage: SQLite error: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addCertificate(IdentityCertificate certificate) throws SecurityException {
        Name certificateName = certificate.getName();
        Name keyName = certificate.getPublicKeyName();
        this.addKey(keyName, certificate.getPublicKeyInfo().getKeyType(), certificate.getPublicKeyInfo().getKeyDer());
        if (this.doesCertificateExist(certificateName)) {
            return;
        }
        try {
            PreparedStatement statement = this.database_.prepareStatement("INSERT INTO Certificate (cert_name, cert_issuer, identity_name, key_identifier, not_before, not_after, certificate_data) values (?, ?, ?, ?, datetime(?, 'unixepoch'), datetime(?, 'unixepoch'), ?)");
            statement.setString(1, certificateName.toUri());
            Name signerName = KeyLocator.getFromSignature(certificate.getSignature()).getKeyName();
            statement.setString(2, signerName.toUri());
            String keyId = keyName.get(-1).toEscapedString();
            Name identity = keyName.getPrefix(-1);
            statement.setString(3, identity.toUri());
            statement.setString(4, keyId);
            statement.setLong(5, (long)Math.floor(certificate.getNotBefore() / 1000.0));
            statement.setLong(6, (long)Math.floor(certificate.getNotAfter() / 1000.0));
            statement.setBytes(7, certificate.wireEncode().getImmutableArray());
            try {
                statement.executeUpdate();
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException exception) {
            throw new SecurityException("BasicIdentityStorage: SQLite error: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IdentityCertificate getCertificate(Name certificateName) throws SecurityException {
        try {
            IdentityCertificate certificate;
            block8: {
                PreparedStatement statement = this.database_.prepareStatement("SELECT certificate_data FROM Certificate WHERE cert_name=?");
                statement.setString(1, certificateName.toUri());
                certificate = new IdentityCertificate();
                try {
                    ResultSet result = statement.executeQuery();
                    if (result.next()) {
                        try {
                            certificate.wireDecode(new Blob(result.getBytes("certificate_data"), false));
                            break block8;
                        }
                        catch (EncodingException ex) {
                            throw new SecurityException("BasicIdentityStorage: Error decoding certificate data: " + ex);
                        }
                    }
                    throw new SecurityException("BasicIdentityStorage.getKey: The key certificate not exist");
                }
                finally {
                    statement.close();
                }
            }
            return certificate;
        }
        catch (SQLException exception) {
            throw new SecurityException("BasicIdentityStorage: SQLite error: " + exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final String getTpmLocator() throws SecurityException {
        try (Statement statement = this.database_.createStatement();){
            ResultSet result = statement.executeQuery("SELECT tpm_locator FROM TpmInfo");
            if (!result.next()) throw new SecurityException("BasicIdentityStorage.getTpmLocator: TPM info does not exist");
            String string = result.getString("tpm_locator");
            return string;
        }
        catch (SQLException exception) {
            throw new SecurityException("BasicIdentityStorage: SQLite error: " + exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Name getDefaultIdentity() throws SecurityException {
        try (Statement statement = this.database_.createStatement();){
            ResultSet result = statement.executeQuery("SELECT identity_name FROM Identity WHERE default_identity=1");
            if (!result.next()) throw new SecurityException("BasicIdentityStorage.getDefaultIdentity: The default identity is not defined");
            Name name = new Name(result.getString("identity_name"));
            return name;
        }
        catch (SQLException exception) {
            throw new SecurityException("BasicIdentityStorage: SQLite error: " + exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Name getDefaultKeyNameForIdentity(Name identityName) throws SecurityException {
        try {
            statement.setString(1, identityName.toUri());
            try (PreparedStatement statement = this.database_.prepareStatement("SELECT key_identifier FROM Key WHERE identity_name=? AND default_key=1");){
                ResultSet result = statement.executeQuery();
                if (!result.next()) throw new SecurityException("BasicIdentityStorage.getDefaultKeyNameForIdentity: The default key for the identity is not defined");
                Name name = new Name(identityName).append(result.getString("key_identifier"));
                return name;
            }
        }
        catch (SQLException exception) {
            throw new SecurityException("BasicIdentityStorage: SQLite error: " + exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Name getDefaultCertificateNameForKey(Name keyName) throws SecurityException {
        String keyId = keyName.get(-1).toEscapedString();
        Name identityName = keyName.getPrefix(-1);
        try {
            PreparedStatement statement = this.database_.prepareStatement("SELECT cert_name FROM Certificate WHERE identity_name=? AND key_identifier=? AND default_cert=1");
            statement.setString(1, identityName.toUri());
            statement.setString(2, keyId);
            try {
                ResultSet result = statement.executeQuery();
                if (!result.next()) throw new SecurityException("BasicIdentityStorage.getDefaultCertificateNameForKey: The default certificate for the key name is not defined");
                Name name = new Name(result.getString("cert_name"));
                return name;
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException exception) {
            throw new SecurityException("BasicIdentityStorage: SQLite error: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getAllIdentities(ArrayList nameList, boolean isDefault) throws SecurityException {
        try {
            String sql = isDefault ? "SELECT identity_name FROM Identity WHERE default_identity=1" : "SELECT identity_name FROM Identity WHERE default_identity=0";
            try (PreparedStatement statement = this.database_.prepareStatement(sql);){
                ResultSet result = statement.executeQuery();
                while (result.next()) {
                    nameList.add(new Name(result.getString("identity_name")));
                }
            }
        }
        catch (SQLException exception) {
            throw new SecurityException("BasicIdentityStorage: SQLite error: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getAllKeyNamesOfIdentity(Name identityName, ArrayList nameList, boolean isDefault) throws SecurityException {
        try {
            String sql = isDefault ? "SELECT key_identifier FROM Key WHERE default_key=1 and identity_name=?" : "SELECT key_identifier FROM Key WHERE default_key=0 and identity_name=?";
            statement.setString(1, identityName.toUri());
            try (PreparedStatement statement = this.database_.prepareStatement(sql);){
                ResultSet result = statement.executeQuery();
                while (result.next()) {
                    nameList.add(new Name(identityName).append(result.getString("key_identifier")));
                }
            }
        }
        catch (SQLException exception) {
            throw new SecurityException("BasicIdentityStorage: SQLite error: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getAllCertificateNamesOfKey(Name keyName, ArrayList nameList, boolean isDefault) throws SecurityException {
        try {
            String sql = isDefault ? "SELECT cert_name FROM Certificate  WHERE default_cert=1 and identity_name=? and key_identifier=?" : "SELECT cert_name FROM Certificate  WHERE default_cert=0 and identity_name=? and key_identifier=?";
            PreparedStatement statement = this.database_.prepareStatement(sql);
            statement.setString(1, keyName.getPrefix(-1).toUri());
            statement.setString(2, keyName.get(-1).toEscapedString());
            try {
                ResultSet result = statement.executeQuery();
                while (result.next()) {
                    nameList.add(new Name(result.getString("cert_name")));
                }
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException exception) {
            throw new SecurityException("BasicIdentityStorage: SQLite error: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setDefaultIdentity(Name identityName) throws SecurityException {
        try {
            try (PreparedStatement statement = this.database_.prepareStatement("UPDATE Identity SET default_identity=0 WHERE default_identity=1");){
                statement.executeUpdate();
            }
            statement = this.database_.prepareStatement("UPDATE Identity SET default_identity=1 WHERE identity_name=?");
            statement.setString(1, identityName.toUri());
            try {
                statement.executeUpdate();
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException exception) {
            throw new SecurityException("BasicIdentityStorage: SQLite error: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setDefaultKeyNameForIdentity(Name keyName, Name identityNameCheck) throws SecurityException {
        this.checkSetDefaultKeyNameForIdentity(keyName, identityNameCheck);
        String keyId = keyName.get(-1).toEscapedString();
        Name identityName = keyName.getPrefix(-1);
        try {
            statement.setString(1, identityName.toUri());
            try (PreparedStatement statement = this.database_.prepareStatement("UPDATE Key SET default_key=0 WHERE default_key=1 and identity_name=?");){
                statement.executeUpdate();
            }
            statement = this.database_.prepareStatement("UPDATE Key SET default_key=1 WHERE identity_name=? AND key_identifier=?");
            statement.setString(1, identityName.toUri());
            statement.setString(2, keyId);
            try {
                statement.executeUpdate();
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException exception) {
            throw new SecurityException("BasicIdentityStorage: SQLite error: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setDefaultCertificateNameForKey(Name keyName, Name certificateName) throws SecurityException {
        String keyId = keyName.get(-1).toEscapedString();
        Name identityName = keyName.getPrefix(-1);
        try {
            PreparedStatement statement = this.database_.prepareStatement("UPDATE Certificate SET default_cert=0 WHERE default_cert=1 AND identity_name=? AND key_identifier=?");
            statement.setString(1, identityName.toUri());
            statement.setString(2, keyId);
            try {
                statement.executeUpdate();
            }
            finally {
                statement.close();
            }
            statement = this.database_.prepareStatement("UPDATE Certificate SET default_cert=1 WHERE identity_name=? AND key_identifier=? AND cert_name=?");
            statement.setString(1, identityName.toUri());
            statement.setString(2, keyId);
            statement.setString(3, certificateName.toUri());
            try {
                statement.executeUpdate();
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException exception) {
            throw new SecurityException("BasicIdentityStorage: SQLite error: " + exception);
        }
    }

    @Override
    public void deleteCertificateInfo(Name certificateName) throws SecurityException {
        if (certificateName.size() == 0) {
            return;
        }
        try {
            statement.setString(1, certificateName.toUri());
            try (PreparedStatement statement = this.database_.prepareStatement("DELETE FROM Certificate WHERE cert_name=?");){
                statement.executeUpdate();
            }
        }
        catch (SQLException exception) {
            throw new SecurityException("BasicIdentityStorage: SQLite error: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deletePublicKeyInfo(Name keyName) throws SecurityException {
        if (keyName.size() == 0) {
            return;
        }
        String keyId = keyName.get(-1).toEscapedString();
        Name identityName = keyName.getPrefix(-1);
        try {
            PreparedStatement statement = this.database_.prepareStatement("DELETE FROM Certificate WHERE identity_name=? and key_identifier=?");
            statement.setString(1, identityName.toUri());
            statement.setString(2, keyId);
            try {
                statement.executeUpdate();
            }
            finally {
                statement.close();
            }
            statement = this.database_.prepareStatement("DELETE FROM Key WHERE identity_name=? and key_identifier=?");
            statement.setString(1, identityName.toUri());
            statement.setString(2, keyId);
            try {
                statement.executeUpdate();
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException exception) {
            throw new SecurityException("BasicIdentityStorage: SQLite error: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteIdentityInfo(Name identityName) throws SecurityException {
        String identity = identityName.toUri();
        try {
            statement.setString(1, identity);
            try (PreparedStatement statement = this.database_.prepareStatement("DELETE FROM Certificate WHERE identity_name=?");){
                statement.executeUpdate();
            }
            statement = this.database_.prepareStatement("DELETE FROM Key WHERE identity_name=?");
            statement.setString(1, identity);
            try {
                statement.executeUpdate();
            }
            finally {
                statement.close();
            }
            statement = this.database_.prepareStatement("DELETE FROM Identity WHERE identity_name=?");
            statement.setString(1, identity);
            try {
                statement.executeUpdate();
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException exception) {
            throw new SecurityException("BasicIdentityStorage: SQLite error: " + exception);
        }
    }

    public static File getDefaultDatabaseDirectoryPath() {
        return new File(Common.getHomeDirectory(), ".ndn");
    }

    public static File getDefaultDatabaseFilePath() {
        return new File(BasicIdentityStorage.getDefaultDatabaseDirectoryPath(), "ndnsec-public-info.db");
    }
}

