/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security;

import net.named_data.jndn.Name;
import net.named_data.jndn.security.DigestAlgorithm;
import net.named_data.jndn.security.ValidityPeriod;
import net.named_data.jndn.security.pib.PibIdentity;
import net.named_data.jndn.security.pib.PibKey;
import net.named_data.jndn.util.Common;

public class SigningInfo {
    private SignerType type_;
    private Name name_;
    private PibIdentity identity_;
    private PibKey key_;
    private DigestAlgorithm digestAlgorithm_;
    private ValidityPeriod validityPeriod_ = new ValidityPeriod();
    private static Common dummyCommon_ = new Common();

    public SigningInfo(SignerType signerType, Name signerName) {
        this.reset(signerType);
        this.name_ = new Name(signerName);
        this.digestAlgorithm_ = DigestAlgorithm.SHA256;
    }

    public SigningInfo(SignerType signerType) {
        this.reset(signerType);
        this.digestAlgorithm_ = DigestAlgorithm.SHA256;
    }

    public SigningInfo() {
        this.reset(SignerType.NULL);
        this.digestAlgorithm_ = DigestAlgorithm.SHA256;
    }

    public SigningInfo(PibIdentity identity) {
        this.digestAlgorithm_ = DigestAlgorithm.SHA256;
        this.setPibIdentity(identity);
    }

    public SigningInfo(PibKey key) {
        this.digestAlgorithm_ = DigestAlgorithm.SHA256;
        this.setPibKey(key);
    }

    public SigningInfo(String signingString) {
        this.reset(SignerType.NULL);
        this.digestAlgorithm_ = DigestAlgorithm.SHA256;
        if (signingString.equals("")) {
            return;
        }
        int iColon = signingString.indexOf(58);
        if (iColon < 0) {
            throw new IllegalArgumentException("Invalid signing string cannot represent SigningInfo");
        }
        String scheme = signingString.substring(0, iColon);
        String nameArg = signingString.substring(iColon + 1);
        if (scheme.equals("id")) {
            if (nameArg.equals(SigningInfo.getDigestSha256Identity().toUri())) {
                this.setSha256Signing();
            } else {
                this.setSigningIdentity(new Name(nameArg));
            }
        } else if (scheme.equals("key")) {
            this.setSigningKeyName(new Name(nameArg));
        } else if (scheme.equals("cert")) {
            this.setSigningCertificateName(new Name(nameArg));
        } else {
            throw new IllegalArgumentException("Invalid signing string scheme");
        }
    }

    public SigningInfo(SigningInfo signingInfo) {
        this.type_ = signingInfo.type_;
        this.name_ = new Name(signingInfo.name_);
        this.identity_ = signingInfo.identity_;
        this.key_ = signingInfo.key_;
        this.digestAlgorithm_ = signingInfo.digestAlgorithm_;
        this.validityPeriod_ = new ValidityPeriod(signingInfo.validityPeriod_);
    }

    public final SigningInfo setSigningIdentity(Name identityName) {
        this.reset(SignerType.ID);
        this.name_ = new Name(identityName);
        return this;
    }

    public final SigningInfo setSigningKeyName(Name keyName) {
        this.reset(SignerType.KEY);
        this.name_ = new Name(keyName);
        return this;
    }

    public final SigningInfo setSigningCertificateName(Name certificateName) {
        this.reset(SignerType.CERT);
        this.name_ = new Name(certificateName);
        return this;
    }

    public final SigningInfo setSha256Signing() {
        this.reset(SignerType.SHA256);
        this.digestAlgorithm_ = DigestAlgorithm.SHA256;
        return this;
    }

    public final SigningInfo setPibIdentity(PibIdentity identity) {
        this.reset(SignerType.ID);
        if (identity != null) {
            this.name_ = identity.getName();
        }
        this.identity_ = identity;
        return this;
    }

    public final SigningInfo setPibKey(PibKey key) {
        this.reset(SignerType.KEY);
        if (key != null) {
            this.name_ = key.getName();
        }
        this.key_ = key;
        return this;
    }

    public final SignerType getSignerType() {
        return this.type_;
    }

    public final Name getSignerName() {
        return this.name_;
    }

    public final PibIdentity getPibIdentity() {
        if (this.type_ != SignerType.ID) {
            throw new AssertionError((Object)"getPibIdentity: The signer type is not SignerType.ID");
        }
        return this.identity_;
    }

    public final PibKey getPibKey() {
        if (this.type_ != SignerType.KEY) {
            throw new AssertionError((Object)"getPibKey: The signer type is not SignerType.KEY");
        }
        return this.key_;
    }

    public final SigningInfo setDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        this.digestAlgorithm_ = digestAlgorithm;
        return this;
    }

    public final DigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm_;
    }

    public final SigningInfo setValidityPeriod(ValidityPeriod validityPeriod) {
        this.validityPeriod_ = new ValidityPeriod(validityPeriod);
        return this;
    }

    public final ValidityPeriod getValidityPeriod() {
        return this.validityPeriod_;
    }

    public String toString() {
        if (this.type_ == SignerType.NULL) {
            return "";
        }
        if (this.type_ == SignerType.ID) {
            return "id:" + this.getSignerName().toUri();
        }
        if (this.type_ == SignerType.KEY) {
            return "key:" + this.getSignerName().toUri();
        }
        if (this.type_ == SignerType.CERT) {
            return "cert:" + this.getSignerName().toUri();
        }
        if (this.type_ == SignerType.SHA256) {
            return "id:" + SigningInfo.getDigestSha256Identity().toUri();
        }
        throw new AssertionError((Object)"Unknown signer type");
    }

    public static Name getDigestSha256Identity() {
        return new Name("/localhost/identity/digest-sha256");
    }

    private void reset(SignerType signerType) {
        if (signerType != SignerType.NULL && signerType != SignerType.ID && signerType != SignerType.KEY && signerType != SignerType.CERT && signerType != SignerType.SHA256) {
            throw new AssertionError((Object)"SigningInfo: The signerType is not valid");
        }
        this.type_ = signerType;
        this.name_ = new Name();
        this.identity_ = null;
        this.key_ = null;
        this.validityPeriod_ = new ValidityPeriod();
    }

    public static enum SignerType {
        NULL,
        ID,
        KEY,
        CERT,
        SHA256;

    }
}

