/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.encrypt;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.named_data.jndn.Data;
import net.named_data.jndn.Face;
import net.named_data.jndn.Interest;
import net.named_data.jndn.InterestFilter;
import net.named_data.jndn.Name;
import net.named_data.jndn.NetworkNack;
import net.named_data.jndn.OnData;
import net.named_data.jndn.OnInterestCallback;
import net.named_data.jndn.OnNetworkNack;
import net.named_data.jndn.OnRegisterFailed;
import net.named_data.jndn.OnTimeout;
import net.named_data.jndn.encrypt.EncryptError;
import net.named_data.jndn.encrypt.EncryptedContent;
import net.named_data.jndn.encrypt.algo.EncryptAlgorithmType;
import net.named_data.jndn.in_memory_storage.InMemoryStorageRetaining;
import net.named_data.jndn.security.KeyChain;
import net.named_data.jndn.security.SecurityException;
import net.named_data.jndn.security.SigningInfo;
import net.named_data.jndn.security.certificate.PublicKey;
import net.named_data.jndn.security.v2.Validator;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.Common;

public class EncryptorV2 {
    public static final Name.Component NAME_COMPONENT_ENCRYPTED_BY = new Name.Component("ENCRYPTED-BY");
    public static final Name.Component NAME_COMPONENT_NAC = new Name.Component("NAC");
    public static final Name.Component NAME_COMPONENT_KEK = new Name.Component("KEK");
    public static final Name.Component NAME_COMPONENT_KDK = new Name.Component("KDK");
    public static final Name.Component NAME_COMPONENT_CK = new Name.Component("CK");
    public static final double RETRY_DELAY_AFTER_NACK_MS = 1000.0;
    public static final double RETRY_DELAY_KEK_RETRIEVAL_MS = 60000.0;
    private final Name accessPrefix_;
    private final Name ckPrefix_;
    private Name ckName_;
    private final byte[] ckBits_;
    private final SigningInfo ckDataSigningInfo_;
    private boolean isKekRetrievalInProgress_;
    private Data kekData_ = null;
    private final EncryptError.OnError onError_;
    private final InMemoryStorageRetaining storage_ = new InMemoryStorageRetaining();
    private final long ckRegisteredPrefixId_;
    private long kekPendingInterestId_ = 0L;
    private final KeyChain keyChain_;
    private final Face face_;
    private static final Logger logger_ = Logger.getLogger(EncryptorV2.class.getName());
    public static final int AES_KEY_SIZE = 32;
    public static final int AES_IV_SIZE = 16;
    public static final int N_RETRIES = 3;
    private static final double DEFAULT_CK_FRESHNESS_PERIOD_MS = 3600000.0;

    public EncryptorV2(Name accessPrefix, Name ckPrefix, SigningInfo ckDataSigningInfo, EncryptError.OnError onError, Validator validator, KeyChain keyChain, Face face) throws IOException, SecurityException {
        this.accessPrefix_ = new Name(accessPrefix);
        this.ckPrefix_ = new Name(ckPrefix);
        this.ckBits_ = new byte[32];
        this.ckDataSigningInfo_ = new SigningInfo(ckDataSigningInfo);
        this.isKekRetrievalInProgress_ = false;
        this.onError_ = onError;
        this.keyChain_ = keyChain;
        this.face_ = face;
        this.regenerateCk();
        this.ckRegisteredPrefixId_ = this.face_.registerPrefix(new Name(ckPrefix).append(NAME_COMPONENT_CK), new OnInterestCallback(){

            @Override
            public void onInterest(Name prefix, Interest interest, Face face, long interestFilterId, InterestFilter filter) {
                Data data = EncryptorV2.this.storage_.find(interest);
                if (data != null) {
                    logger_.log(Level.INFO, "Serving {0} from InMemoryStorage", data.getName());
                    try {
                        face.putData(data);
                    }
                    catch (IOException ex) {
                        logger_.log(Level.SEVERE, "Error in Face.putData: {0}", ex);
                    }
                } else {
                    logger_.log(Level.INFO, "Didn't find CK data for {0}", interest.getName());
                }
            }
        }, new OnRegisterFailed(){

            @Override
            public void onRegisterFailed(Name prefix) {
                logger_.log(Level.SEVERE, "Failed to register prefix {0}", prefix);
            }
        });
    }

    public final void shutdown() {
        this.face_.unsetInterestFilter(this.ckRegisteredPrefixId_);
        if (this.kekPendingInterestId_ > 0L) {
            this.face_.removePendingInterest(this.kekPendingInterestId_);
        }
    }

    public final EncryptedContent encrypt(byte[] plainData) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        byte[] iv = new byte[16];
        Common.getRandom().nextBytes(iv);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        try {
            cipher.init(1, (Key)new SecretKeySpec(this.ckBits_, "AES"), new IvParameterSpec(iv));
        }
        catch (InvalidKeyException ex) {
            throw new Error("If the error is 'Illegal key size', try installing the Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files: " + ex);
        }
        byte[] encryptedData = cipher.doFinal(plainData);
        EncryptedContent content = new EncryptedContent();
        content.setInitialVector(new Blob(iv, false));
        content.setPayload(new Blob(encryptedData, false));
        content.setKeyLocatorName(this.ckName_);
        return content;
    }

    public final void regenerateCk() {
        this.ckName_ = new Name(this.ckPrefix_);
        this.ckName_.append(NAME_COMPONENT_CK);
        this.ckName_.appendVersion((long)Common.getNowMilliseconds());
        logger_.log(Level.INFO, "Generating new CK: {0}", this.ckName_);
        Common.getRandom().nextBytes(this.ckBits_);
        if (this.kekData_ == null) {
            this.retryFetchingKek();
        } else {
            this.makeAndPublishCkData(this.onError_);
        }
    }

    public final int size() {
        return this.storage_.size();
    }

    public final HashMap getCache_() {
        return this.storage_.getCache_();
    }

    public final boolean getIsKekRetrievalInProgress_() {
        return this.isKekRetrievalInProgress_;
    }

    public final void clearKekData_() {
        this.kekData_ = null;
    }

    private void retryFetchingKek() {
        if (this.isKekRetrievalInProgress_) {
            return;
        }
        logger_.log(Level.INFO, "Retrying fetching of the KEK");
        this.isKekRetrievalInProgress_ = true;
        this.fetchKekAndPublishCkData(new Runnable(){

            @Override
            public void run() {
                logger_.log(Level.INFO, "The KEK was retrieved and published");
                EncryptorV2.this.isKekRetrievalInProgress_ = false;
            }
        }, new EncryptError.OnError(){

            @Override
            public void onError(EncryptError.ErrorCode errorCode, String message) {
                logger_.log(Level.INFO, "Failed to retrieve KEK: {0}", message);
                EncryptorV2.this.isKekRetrievalInProgress_ = false;
                EncryptorV2.this.onError_.onError(errorCode, message);
            }
        }, 3);
    }

    private void fetchKekAndPublishCkData(final Runnable onReady, final EncryptError.OnError onError, final int nTriesLeft) {
        logger_.log(Level.INFO, "Fetching KEK: {0}", new Name(this.accessPrefix_).append(NAME_COMPONENT_KEK));
        if (this.kekPendingInterestId_ > 0L) {
            onError.onError(EncryptError.ErrorCode.SecurityException, "fetchKekAndPublishCkData: There is already a kekPendingInterestId_");
            return;
        }
        try {
            this.kekPendingInterestId_ = this.face_.expressInterest(new Interest(new Name(this.accessPrefix_).append(NAME_COMPONENT_KEK)).setMustBeFresh(true).setCanBePrefix(true), new OnData(){

                @Override
                public void onData(Interest interest, Data kekData) {
                    EncryptorV2.this.kekPendingInterestId_ = 0L;
                    EncryptorV2.this.kekData_ = kekData;
                    if (EncryptorV2.this.makeAndPublishCkData(onError)) {
                        onReady.run();
                    }
                }
            }, new OnTimeout(){

                @Override
                public void onTimeout(Interest interest) {
                    EncryptorV2.this.kekPendingInterestId_ = 0L;
                    if (nTriesLeft > 1) {
                        EncryptorV2.this.fetchKekAndPublishCkData(onReady, onError, nTriesLeft - 1);
                    } else {
                        onError.onError(EncryptError.ErrorCode.KekRetrievalTimeout, "Retrieval of KEK [" + interest.getName().toUri() + "] timed out");
                        logger_.log(Level.INFO, "Scheduling retry after all timeouts");
                        EncryptorV2.this.face_.callLater(60000.0, new Runnable(){

                            @Override
                            public void run() {
                                EncryptorV2.this.retryFetchingKek();
                            }
                        });
                    }
                }
            }, new OnNetworkNack(){

                @Override
                public void onNetworkNack(Interest interest, NetworkNack networkNack) {
                    EncryptorV2.this.kekPendingInterestId_ = 0L;
                    if (nTriesLeft > 1) {
                        EncryptorV2.this.face_.callLater(1000.0, new Runnable(){

                            @Override
                            public void run() {
                                EncryptorV2.this.fetchKekAndPublishCkData(onReady, onError, nTriesLeft - 1);
                            }
                        });
                    } else {
                        onError.onError(EncryptError.ErrorCode.KekRetrievalFailure, "Retrieval of KEK [" + interest.getName().toUri() + "] failed. Got NACK (" + (Object)((Object)networkNack.getReason()) + ")");
                        logger_.log(Level.INFO, "Scheduling retry from NACK");
                        EncryptorV2.this.face_.callLater(60000.0, new Runnable(){

                            @Override
                            public void run() {
                                EncryptorV2.this.retryFetchingKek();
                            }
                        });
                    }
                }
            });
        }
        catch (Exception ex) {
            onError.onError(EncryptError.ErrorCode.General, "expressInterest error: " + ex);
        }
    }

    private boolean makeAndPublishCkData(EncryptError.OnError onError) {
        try {
            PublicKey kek = new PublicKey(this.kekData_.getContent());
            EncryptedContent content = new EncryptedContent();
            content.setPayload(kek.encrypt(this.ckBits_, EncryptAlgorithmType.RsaOaep));
            Data ckData = new Data(new Name(this.ckName_).append(NAME_COMPONENT_ENCRYPTED_BY).append(this.kekData_.getName()));
            ckData.setContent(content.wireEncodeV2());
            ckData.getMetaInfo().setFreshnessPeriod(3600000.0);
            this.keyChain_.sign(ckData, this.ckDataSigningInfo_);
            this.storage_.insert(ckData);
            logger_.log(Level.INFO, "Publishing CK data: {0}", ckData.getName());
            return true;
        }
        catch (Throwable ex) {
            onError.onError(EncryptError.ErrorCode.EncryptionFailure, "Failed to encrypt generated CK with KEK " + this.kekData_.getName().toUri());
            return false;
        }
    }
}

