/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.encrypt;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import net.named_data.jndn.Data;
import net.named_data.jndn.Face;
import net.named_data.jndn.Interest;
import net.named_data.jndn.InterestFilter;
import net.named_data.jndn.Name;
import net.named_data.jndn.OnInterestCallback;
import net.named_data.jndn.OnRegisterFailed;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encrypt.EncryptedContent;
import net.named_data.jndn.encrypt.EncryptorV2;
import net.named_data.jndn.encrypt.algo.EncryptAlgorithmType;
import net.named_data.jndn.in_memory_storage.InMemoryStorageRetaining;
import net.named_data.jndn.security.KeyChain;
import net.named_data.jndn.security.KeyType;
import net.named_data.jndn.security.RsaKeyParams;
import net.named_data.jndn.security.SafeBag;
import net.named_data.jndn.security.SecurityException;
import net.named_data.jndn.security.SigningInfo;
import net.named_data.jndn.security.UnrecognizedKeyFormatException;
import net.named_data.jndn.security.certificate.PublicKey;
import net.named_data.jndn.security.pib.Pib;
import net.named_data.jndn.security.pib.PibIdentity;
import net.named_data.jndn.security.pib.PibImpl;
import net.named_data.jndn.security.pib.PibKey;
import net.named_data.jndn.security.tpm.Tpm;
import net.named_data.jndn.security.tpm.TpmBackEnd;
import net.named_data.jndn.security.v2.CertificateV2;
import net.named_data.jndn.util.Common;

public class AccessManagerV2 {
    private final PibIdentity identity_;
    private PibKey nacKey_;
    private final KeyChain keyChain_;
    private final Face face_;
    private final InMemoryStorageRetaining storage_ = new InMemoryStorageRetaining();
    private final long kekRegisteredPrefixId_;
    private final long kdkRegisteredPrefixId_;
    private static final Logger logger_ = Logger.getLogger(AccessManagerV2.class.getName());
    private static final double DEFAULT_KEK_FRESHNESS_PERIOD_MS = 3600000.0;
    private static final double DEFAULT_KDK_FRESHNESS_PERIOD_MS = 3600000.0;

    public AccessManagerV2(PibIdentity identity, Name dataset, KeyChain keyChain, Face face) throws Tpm.Error, TpmBackEnd.Error, PibImpl.Error, Pib.Error, KeyChain.Error, EncodingException, IOException, SecurityException {
        this.identity_ = identity;
        this.keyChain_ = keyChain;
        this.face_ = face;
        PibIdentity nacIdentity = this.keyChain_.createIdentityV2(new Name(identity.getName()).append(EncryptorV2.NAME_COMPONENT_NAC).append(dataset), new RsaKeyParams());
        this.nacKey_ = nacIdentity.getDefaultKey();
        if (this.nacKey_.getKeyType() != KeyType.RSA) {
            logger_.log(Level.INFO, "Cannot re-use existing KEK/KDK pair, as it is not an RSA key, regenerating");
            this.nacKey_ = this.keyChain_.createKey(nacIdentity, new RsaKeyParams());
        }
        Name.Component nacKeyId = this.nacKey_.getName().get(-1);
        Name kekPrefix = new Name(this.nacKey_.getIdentityName()).append(EncryptorV2.NAME_COMPONENT_KEK);
        Data kekData = new Data(this.nacKey_.getDefaultCertificate());
        kekData.setName(new Name(kekPrefix).append(nacKeyId));
        kekData.getMetaInfo().setFreshnessPeriod(3600000.0);
        this.keyChain_.sign(kekData, new SigningInfo(this.identity_));
        this.storage_.insert(kekData);
        OnInterestCallback serveFromStorage = new OnInterestCallback(){

            @Override
            public void onInterest(Name prefix, Interest interest, Face face, long interestFilterId, InterestFilter filter) {
                Data data = AccessManagerV2.this.storage_.find(interest);
                if (data != null) {
                    logger_.log(Level.INFO, "Serving {0} from in-memory-storage", data.getName());
                    try {
                        face.putData(data);
                    }
                    catch (Throwable ex) {
                        logger_.log(Level.SEVERE, "AccessManagerV2: Error in Face.putData", ex);
                    }
                } else {
                    logger_.log(Level.INFO, "Didn't find data for {0}", interest.getName());
                }
            }
        };
        OnRegisterFailed registerFailed = new OnRegisterFailed(){

            @Override
            public void onRegisterFailed(Name prefix) {
                logger_.log(Level.SEVERE, "AccessManagerV2: Failed to register prefix {0}", prefix.toUri());
            }
        };
        this.kekRegisteredPrefixId_ = this.face_.registerPrefix(kekPrefix, serveFromStorage, registerFailed);
        Name kdkPrefix = new Name(this.nacKey_.getIdentityName()).append(EncryptorV2.NAME_COMPONENT_KDK).append(nacKeyId);
        this.kdkRegisteredPrefixId_ = this.face_.registerPrefix(kdkPrefix, serveFromStorage, registerFailed);
    }

    public final void shutdown() {
        this.face_.unsetInterestFilter(this.kekRegisteredPrefixId_);
        this.face_.unsetInterestFilter(this.kdkRegisteredPrefixId_);
    }

    public final Data addMember(CertificateV2 memberCertificate) throws Pib.Error, PibImpl.Error, UnrecognizedKeyFormatException, EncodingException, TpmBackEnd.Error, KeyChain.Error, InvalidKeySpecException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, CertificateV2.Error {
        Name kdkName = new Name(this.nacKey_.getIdentityName());
        kdkName.append(EncryptorV2.NAME_COMPONENT_KDK).append(this.nacKey_.getName().get(-1)).append(EncryptorV2.NAME_COMPONENT_ENCRYPTED_BY).append(memberCertificate.getKeyName());
        int secretLength = 32;
        byte[] secret = new byte[32];
        Common.getRandom().nextBytes(secret);
        int i = 0;
        while (i < 32) {
            if (secret[i] == 0) {
                secret[i] = 1;
            }
            int n = i++;
            secret[n] = (byte)(secret[n] & 0x7F);
        }
        SafeBag kdkSafeBag = this.keyChain_.exportSafeBag(this.nacKey_.getDefaultCertificate(), ByteBuffer.wrap(secret));
        PublicKey memberKey = new PublicKey(memberCertificate.getPublicKey());
        EncryptedContent encryptedContent = new EncryptedContent();
        encryptedContent.setPayload(kdkSafeBag.wireEncode());
        encryptedContent.setPayloadKey(memberKey.encrypt(secret, EncryptAlgorithmType.RsaOaep));
        Data kdkData = new Data(kdkName);
        kdkData.setContent(encryptedContent.wireEncodeV2());
        kdkData.getMetaInfo().setFreshnessPeriod(3600000.0);
        this.keyChain_.sign(kdkData, new SigningInfo(this.identity_));
        this.storage_.insert(kdkData);
        return kdkData;
    }

    public final int size() {
        return this.storage_.size();
    }

    public final HashMap getCache_() {
        return this.storage_.getCache_();
    }
}

