/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.util.regex;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.named_data.jndn.Name;
import net.named_data.jndn.util.regex.NdnRegexBackrefManager;
import net.named_data.jndn.util.regex.NdnRegexMatcherBase;
import net.named_data.jndn.util.regex.NdnRegexPseudoMatcher;

public class NdnRegexComponentMatcher
extends NdnRegexMatcherBase {
    private final boolean isExactMatch_;
    private Pattern componentRegex_;
    private final ArrayList<NdnRegexPseudoMatcher> pseudoMatchers_ = new ArrayList();

    public NdnRegexComponentMatcher(String expr, NdnRegexBackrefManager backrefManager, boolean isExactMatch) throws NdnRegexMatcherBase.Error {
        super(expr, NdnRegexMatcherBase.NdnRegexExprType.COMPONENT, backrefManager);
        this.isExactMatch_ = isExactMatch;
        this.compile();
    }

    public NdnRegexComponentMatcher(String expr, NdnRegexBackrefManager backrefManager) throws NdnRegexMatcherBase.Error {
        super(expr, NdnRegexMatcherBase.NdnRegexExprType.COMPONENT, backrefManager);
        this.isExactMatch_ = true;
        this.compile();
    }

    @Override
    public boolean match(Name name, int offset, int len) throws NdnRegexMatcherBase.Error {
        this.matchResult_.clear();
        if (this.expr_.equals("")) {
            this.matchResult_.add(name.get(offset));
            return true;
        }
        if (this.isExactMatch_) {
            String targetStr = name.get(offset).toEscapedString();
            Matcher subResult = this.componentRegex_.matcher(targetStr);
            if (subResult.find()) {
                for (int i = 1; i <= subResult.groupCount(); ++i) {
                    this.pseudoMatchers_.get(i).resetMatchResult();
                    this.pseudoMatchers_.get(i).setMatchResult(subResult.group(i));
                }
                this.matchResult_.add(name.get(offset));
                return true;
            }
        } else {
            throw new NdnRegexMatcherBase.Error("Non-exact component search is not supported yet");
        }
        return false;
    }

    @Override
    protected void compile() throws NdnRegexMatcherBase.Error {
        int i;
        this.componentRegex_ = Pattern.compile(this.expr_);
        this.pseudoMatchers_.clear();
        this.pseudoMatchers_.add(new NdnRegexPseudoMatcher());
        if (this.expr_.contains("\\(")) {
            throw new NdnRegexMatcherBase.Error("Can't count subexpressions in regex with escaped parentheses: " + this.expr_);
        }
        int markCount = 0;
        for (i = 0; i < this.expr_.length(); ++i) {
            if (this.expr_.charAt(i) != '(') continue;
            ++markCount;
        }
        for (i = 1; i <= markCount; ++i) {
            NdnRegexPseudoMatcher pMatcher = new NdnRegexPseudoMatcher();
            this.pseudoMatchers_.add(pMatcher);
            this.backrefManager_.pushRef(pMatcher);
        }
    }
}

