/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.util.regex;

import net.named_data.jndn.util.regex.NdnRegexBackrefManager;
import net.named_data.jndn.util.regex.NdnRegexMatcherBase;
import net.named_data.jndn.util.regex.NdnRegexPatternListMatcher;

public class NdnRegexBackrefMatcher
extends NdnRegexMatcherBase {
    public NdnRegexBackrefMatcher(String expr, NdnRegexBackrefManager backrefManager) {
        super(expr, NdnRegexMatcherBase.NdnRegexExprType.BACKREF, backrefManager);
    }

    public final void lateCompile() throws NdnRegexMatcherBase.Error {
        this.compile();
    }

    @Override
    protected void compile() throws NdnRegexMatcherBase.Error {
        if (this.expr_.length() < 2) {
            throw new NdnRegexMatcherBase.Error("Unrecognized format: " + this.expr_);
        }
        int lastIndex = this.expr_.length() - 1;
        if ('(' != this.expr_.charAt(0) || ')' != this.expr_.charAt(lastIndex)) {
            throw new NdnRegexMatcherBase.Error("Unrecognized format: " + this.expr_);
        }
        NdnRegexPatternListMatcher matcher = new NdnRegexPatternListMatcher(this.expr_.substring(1, lastIndex), this.backrefManager_);
        this.matchers_.add(matcher);
    }
}

