/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.v2.validator_config;

import net.named_data.jndn.Name;
import net.named_data.jndn.security.ValidatorConfigError;
import net.named_data.jndn.security.v2.ValidationError;
import net.named_data.jndn.security.v2.ValidationState;
import net.named_data.jndn.security.v2.validator_config.ConfigChecker;
import net.named_data.jndn.security.v2.validator_config.ConfigNameRelation;
import net.named_data.jndn.util.regex.NdnRegexMatcherBase;
import net.named_data.jndn.util.regex.NdnRegexTopMatcher;

public class ConfigHyperRelationChecker
extends ConfigChecker {
    private final NdnRegexTopMatcher packetNameRegex_;
    private final String packetNameExpansion_;
    private final NdnRegexTopMatcher keyNameRegex_;
    private final String keyNameExpansion_;
    private final ConfigNameRelation.Relation hyperRelation_;

    public ConfigHyperRelationChecker(String packetNameRegexString, String packetNameExpansion, String keyNameRegexString, String keyNameExpansion, ConfigNameRelation.Relation hyperRelation) throws NdnRegexMatcherBase.Error {
        this.packetNameRegex_ = new NdnRegexTopMatcher(packetNameRegexString);
        this.packetNameExpansion_ = packetNameExpansion;
        this.keyNameRegex_ = new NdnRegexTopMatcher(keyNameRegexString);
        this.keyNameExpansion_ = keyNameExpansion;
        this.hyperRelation_ = hyperRelation;
    }

    @Override
    protected boolean checkNames(Name packetName, Name keyLocatorName, ValidationState state) throws ValidatorConfigError {
        Name packetNameMatchExpansion;
        Name keyNameMatchExpansion;
        boolean isMatch;
        try {
            isMatch = this.packetNameRegex_.match(packetName);
        }
        catch (NdnRegexMatcherBase.Error ex) {
            throw new ValidatorConfigError("Error in regex match: " + ex);
        }
        if (!isMatch) {
            state.fail(new ValidationError(9, "The packet " + packetName.toUri() + " (KeyLocator=" + keyLocatorName.toUri() + ") does not match the hyper relation packet name regex " + this.packetNameRegex_.getExpr()));
            return false;
        }
        try {
            isMatch = this.keyNameRegex_.match(keyLocatorName);
        }
        catch (NdnRegexMatcherBase.Error ex) {
            throw new ValidatorConfigError("Error in regex match: " + ex);
        }
        if (!isMatch) {
            state.fail(new ValidationError(9, "The packet " + packetName.toUri() + " (KeyLocator=" + keyLocatorName.toUri() + ") does not match the hyper relation key name regex " + this.keyNameRegex_.getExpr()));
            return false;
        }
        try {
            keyNameMatchExpansion = this.keyNameRegex_.expand(this.keyNameExpansion_);
        }
        catch (NdnRegexMatcherBase.Error ex) {
            throw new ValidatorConfigError("Error in regex expand: " + ex);
        }
        try {
            packetNameMatchExpansion = this.packetNameRegex_.expand(this.packetNameExpansion_);
        }
        catch (NdnRegexMatcherBase.Error ex) {
            throw new ValidatorConfigError("Error in regex expand: " + ex);
        }
        boolean result = ConfigNameRelation.checkNameRelation(this.hyperRelation_, keyNameMatchExpansion, packetNameMatchExpansion);
        if (!result) {
            state.fail(new ValidationError(9, "KeyLocator check failed: hyper relation " + ConfigNameRelation.toString(this.hyperRelation_) + " packet name match=" + packetNameMatchExpansion.toUri() + ", key name match=" + keyNameMatchExpansion.toUri() + " of packet " + packetName.toUri() + " (KeyLocator=" + keyLocatorName.toUri() + ") is invalid"));
        }
        return result;
    }
}

