/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.v2;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.Data;
import net.named_data.jndn.Name;
import net.named_data.jndn.security.VerificationHelpers;
import net.named_data.jndn.security.v2.CertificateV2;
import net.named_data.jndn.security.v2.ValidationError;
import net.named_data.jndn.util.Common;

public abstract class ValidationState {
    private final ArrayList<CertificateV2> certificateChain_ = new ArrayList();
    private final HashSet<Name> seenCertificateNames_ = new HashSet();
    private boolean hasOutcome_ = false;
    private boolean outcome_;
    private static final Logger logger_ = Logger.getLogger(ValidationState.class.getName());
    private static Common dummyCommon_ = new Common();

    public final boolean hasOutcome() {
        return this.hasOutcome_;
    }

    public final boolean isOutcomeFailed() {
        return this.hasOutcome_ && !this.outcome_;
    }

    public final boolean isOutcomeSuccess() {
        return this.hasOutcome_ && this.outcome_;
    }

    public abstract void fail(ValidationError var1);

    public final int getDepth() {
        return this.certificateChain_.size();
    }

    public final boolean hasSeenCertificateName(Name certificateName) {
        if (this.seenCertificateNames_.contains(certificateName)) {
            return true;
        }
        this.seenCertificateNames_.add(new Name(certificateName));
        return false;
    }

    public final void addCertificate(CertificateV2 certificate) throws CertificateV2.Error {
        this.certificateChain_.add(0, new CertificateV2(certificate));
    }

    protected final void setOutcome(boolean outcome) {
        if (this.hasOutcome_) {
            throw new IllegalArgumentException("The ValidationState already has an outcome");
        }
        this.hasOutcome_ = true;
        this.outcome_ = outcome;
    }

    public abstract void verifyOriginalPacket_(CertificateV2 var1);

    public abstract void bypassValidation_();

    public final CertificateV2 verifyCertificateChain_(CertificateV2 trustedCertificate) {
        CertificateV2 validatedCertificate = trustedCertificate;
        for (int i = 0; i < this.certificateChain_.size(); ++i) {
            CertificateV2 certificateToValidate = this.certificateChain_.get(i);
            if (!VerificationHelpers.verifyDataSignature((Data)certificateToValidate, validatedCertificate)) {
                this.fail(new ValidationError(1, "Invalid signature of certificate `" + certificateToValidate.getName().toUri() + "`"));
                while (this.certificateChain_.size() > i) {
                    this.certificateChain_.remove(i);
                }
                return null;
            }
            logger_.log(Level.FINE, "OK signature for certificate `{0}`", certificateToValidate.getName().toUri());
            validatedCertificate = certificateToValidate;
        }
        return validatedCertificate;
    }

    public final ArrayList<CertificateV2> getCertificateChain_() {
        return this.certificateChain_;
    }
}

