/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.tpm;

import java.nio.ByteBuffer;
import java.util.HashMap;
import net.named_data.jndn.Name;
import net.named_data.jndn.security.KeyParams;
import net.named_data.jndn.security.tpm.TpmBackEnd;
import net.named_data.jndn.security.tpm.TpmKeyHandle;
import net.named_data.jndn.security.tpm.TpmKeyHandleMemory;
import net.named_data.jndn.security.tpm.TpmPrivateKey;
import net.named_data.jndn.util.Blob;

public class TpmBackEndMemory
extends TpmBackEnd {
    private final HashMap<Name, TpmPrivateKey> keys_ = new HashMap();

    public static String getScheme() {
        return "tpm-memory";
    }

    @Override
    protected boolean doHasKey(Name keyName) throws TpmBackEnd.Error {
        return this.keys_.containsKey(keyName);
    }

    @Override
    protected TpmKeyHandle doGetKeyHandle(Name keyName) throws TpmBackEnd.Error {
        TpmPrivateKey key = this.keys_.get(keyName);
        if (key == null) {
            return null;
        }
        return new TpmKeyHandleMemory(key);
    }

    @Override
    protected TpmKeyHandle doCreateKey(Name identityName, KeyParams params) throws TpmBackEnd.Error {
        TpmPrivateKey key;
        try {
            key = TpmPrivateKey.generatePrivateKey(params);
        }
        catch (TpmPrivateKey.Error ex) {
            throw new TpmBackEnd.Error("Error in TpmPrivateKey.generatePrivateKey: " + ex);
        }
        TpmKeyHandleMemory keyHandle = new TpmKeyHandleMemory(key);
        TpmBackEndMemory.setKeyName(keyHandle, identityName, params);
        this.keys_.put(keyHandle.getKeyName(), key);
        return keyHandle;
    }

    @Override
    protected void doDeleteKey(Name keyName) throws TpmBackEnd.Error {
        this.keys_.remove(keyName);
    }

    @Override
    protected Blob doExportKey(Name keyName, ByteBuffer password) throws TpmBackEnd.Error {
        if (!this.hasKey(keyName)) {
            throw new TpmBackEnd.Error("exportKey: The key does not exist");
        }
        try {
            if (password != null) {
                return this.keys_.get(keyName).toEncryptedPkcs8(password);
            }
            return this.keys_.get(keyName).toPkcs8();
        }
        catch (TpmPrivateKey.Error ex) {
            throw new TpmBackEnd.Error("Error in toPkcs8: " + ex);
        }
    }

    @Override
    protected void doImportKey(Name keyName, ByteBuffer pkcs8, ByteBuffer password) throws TpmBackEnd.Error {
        try {
            TpmPrivateKey key = new TpmPrivateKey();
            if (password != null) {
                key.loadEncryptedPkcs8(pkcs8, password);
            } else {
                key.loadPkcs8(pkcs8);
            }
            this.keys_.put(new Name(keyName), key);
        }
        catch (TpmPrivateKey.Error ex) {
            throw new TpmBackEnd.Error("Cannot import private key: " + ex);
        }
    }
}

