/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.pib;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDoneException;
import android.database.sqlite.SQLiteStatement;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import net.named_data.jndn.Name;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.security.pib.Pib;
import net.named_data.jndn.security.pib.PibImpl;
import net.named_data.jndn.security.pib.PibSqlite3Base;
import net.named_data.jndn.security.v2.CertificateV2;
import net.named_data.jndn.util.Blob;

public class AndroidSqlite3Pib
extends PibSqlite3Base {
    private SQLiteDatabase database_;

    public AndroidSqlite3Pib(String databaseDirectoryPath, String databaseFilename) throws PibImpl.Error {
        this.construct(databaseDirectoryPath, databaseFilename);
    }

    public AndroidSqlite3Pib(String databaseDirectoryPath) throws PibImpl.Error {
        this.construct(databaseDirectoryPath, "pib.db");
    }

    private void construct(String databaseDirectoryPath, String databaseFilename) throws PibImpl.Error {
        new File(databaseDirectoryPath).mkdirs();
        File databaseFilePath = new File(databaseDirectoryPath, databaseFilename);
        this.database_ = SQLiteDatabase.openDatabase((String)databaseFilePath.getAbsolutePath(), null, (int)0x10000000);
        this.database_.execSQL("CREATE TABLE IF NOT EXISTS                         \n  tpmInfo(                                         \n    tpm_locator           BLOB                     \n  );                                               \n");
        this.database_.execSQL("CREATE TABLE IF NOT EXISTS                         \n  identities(                                      \n    id                    INTEGER PRIMARY KEY,     \n    identity              BLOB NOT NULL,           \n    is_default            INTEGER DEFAULT 0        \n  );                                               \n");
        this.database_.execSQL("CREATE UNIQUE INDEX IF NOT EXISTS                  \n  identityIndex ON identities(identity);           \n");
        this.database_.execSQL("CREATE TABLE IF NOT EXISTS                         \n  keys(                                            \n    id                    INTEGER PRIMARY KEY,     \n    identity_id           INTEGER NOT NULL,        \n    key_name              BLOB NOT NULL,           \n    key_bits              BLOB NOT NULL,           \n    is_default            INTEGER DEFAULT 0        \n  );                                               \n");
        this.database_.execSQL("CREATE UNIQUE INDEX IF NOT EXISTS                  \n  keyIndex ON keys(key_name);                      \n");
        this.database_.execSQL("CREATE TABLE IF NOT EXISTS                         \n  certificates(                                    \n    id                    INTEGER PRIMARY KEY,     \n    key_id                INTEGER NOT NULL,        \n    certificate_name      BLOB NOT NULL,           \n    certificate_data      BLOB NOT NULL,           \n    is_default            INTEGER DEFAULT 0        \n  );                                               \n");
        this.database_.execSQL("CREATE UNIQUE INDEX IF NOT EXISTS                  \n  certIndex ON certificates(certificate_name);     \n");
    }

    public static String getScheme() {
        return "pib-sqlite3";
    }

    @Override
    public void setTpmLocator(String tpmLocator) throws PibImpl.Error {
        if (this.getTpmLocator().equals("")) {
            ContentValues values = new ContentValues();
            values.put("tpm_locator", tpmLocator);
            if (this.database_.insert("tpmInfo", null, values) < 0L) {
                throw new PibImpl.Error("AndroidSqlite3Pib: SQLite error");
            }
        } else {
            ContentValues values = new ContentValues();
            values.put("tpm_locator", tpmLocator);
            this.database_.update("tpmInfo", values, null, null);
        }
    }

    @Override
    public String getTpmLocator() throws PibImpl.Error {
        try (Cursor cursor = this.database_.rawQuery("SELECT tpm_locator FROM TpmInfo", null);){
            if (cursor.moveToNext()) {
                String string = cursor.getString(0);
                return string;
            }
            String string = "";
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasIdentity(Name identityName) throws PibImpl.Error {
        try (SQLiteStatement statement = this.database_.compileStatement("SELECT id FROM identities WHERE identity=?");){
            statement.bindBlob(1, identityName.wireEncode().getImmutableArray());
            try {
                statement.simpleQueryForLong();
                boolean bl = true;
                return bl;
            }
            catch (SQLiteDoneException ex) {
                boolean bl = false;
                statement.close();
                return bl;
            }
        }
    }

    @Override
    public void addIdentity(Name identityName) throws PibImpl.Error {
        if (!this.hasIdentity(identityName)) {
            ContentValues values = new ContentValues();
            values.put("identity", identityName.wireEncode().getImmutableArray());
            if (this.database_.insert("identities", null, values) < 0L) {
                throw new PibImpl.Error("AndroidSqlite3Pib: SQLite error");
            }
        }
        if (!this.hasDefaultIdentity()) {
            this.setDefaultIdentity(identityName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeIdentity(Name identityName) throws PibImpl.Error {
        int keyId;
        byte[] identityBytes = identityName.wireEncode().getImmutableArray();
        ArrayList<Integer> keyIds = new ArrayList<Integer>();
        try (Cursor cursor = this.database_.rawQuery("SELECT keys.id FROM keys JOIN identities ON keys.identity_id=identities.id WHERE identities.identity=?".substring(0, "SELECT keys.id FROM keys JOIN identities ON keys.identity_id=identities.id WHERE identities.identity=?".length() - 1) + "x'" + identityName.wireEncode().toHex() + "'", null);){
            while (cursor.moveToNext()) {
                keyIds.add(cursor.getInt(0));
            }
        }
        Iterator iterator = keyIds.iterator();
        while (iterator.hasNext()) {
            keyId = (Integer)iterator.next();
            this.database_.execSQL("DELETE FROM certificates WHERE key_id=?", new Object[]{keyId});
        }
        iterator = keyIds.iterator();
        while (iterator.hasNext()) {
            keyId = (Integer)iterator.next();
            this.database_.execSQL("DELETE FROM keys WHERE id=?", new Object[]{keyId});
        }
        this.database_.execSQL("DELETE FROM identities WHERE identity=?", new Object[]{identityBytes});
    }

    @Override
    public void clearIdentities() throws PibImpl.Error {
        this.database_.execSQL("DELETE FROM certificates", new Object[0]);
        this.database_.execSQL("DELETE FROM keys", new Object[0]);
        this.database_.execSQL("DELETE FROM identities", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashSet<Name> getIdentities() throws PibImpl.Error {
        HashSet<Name> identityNames = new HashSet<Name>();
        try (Cursor cursor = this.database_.rawQuery("SELECT identity FROM identities", null);){
            while (cursor.moveToNext()) {
                Name name = new Name();
                try {
                    name.wireDecode(new Blob(cursor.getBlob(0)));
                }
                catch (EncodingException ex) {
                    throw new PibImpl.Error("PibSqlite3: Error decoding name: " + ex);
                }
                identityNames.add(name);
            }
        }
        return identityNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultIdentity(Name identityName) throws PibImpl.Error {
        byte[] identityBytes = identityName.wireEncode().getImmutableArray();
        if (!this.hasIdentity(identityName)) {
            ContentValues values = new ContentValues();
            values.put("identity", identityBytes);
            if (this.database_.insert("identities", null, values) < 0L) {
                throw new PibImpl.Error("AndroidSqlite3Pib: SQLite error");
            }
        }
        this.database_.execSQL("UPDATE identities SET is_default=0 WHERE is_default=1", new Object[0]);
        try (SQLiteStatement statement = this.database_.compileStatement("UPDATE identities SET is_default=1 WHERE identity=?");){
            statement.bindBlob(1, identityBytes);
            if (statement.executeUpdateDelete() <= 0) {
                throw new PibImpl.Error("AndroidSqlite3Pib: SQLite error");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Name getDefaultIdentity() throws Pib.Error, PibImpl.Error {
        Name name;
        block6: {
            name = new Name();
            try (Cursor cursor = this.database_.rawQuery("SELECT identity FROM identities WHERE is_default=1", null);){
                if (cursor.moveToNext()) {
                    try {
                        name.wireDecode(new Blob(cursor.getBlob(0)));
                        break block6;
                    }
                    catch (EncodingException ex) {
                        throw new PibImpl.Error("PibSqlite3: Error decoding name: " + ex);
                    }
                }
                throw new Pib.Error("No default identity");
            }
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasKey(Name keyName) throws PibImpl.Error {
        try (SQLiteStatement statement = this.database_.compileStatement("SELECT id FROM keys WHERE key_name=?");){
            statement.bindBlob(1, keyName.wireEncode().getImmutableArray());
            try {
                statement.simpleQueryForLong();
                boolean bl = true;
                return bl;
            }
            catch (SQLiteDoneException ex) {
                boolean bl = false;
                statement.close();
                return bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addKey(Name identityName, Name keyName, ByteBuffer key) throws PibImpl.Error {
        block12: {
            SQLiteStatement statement;
            this.addIdentity(identityName);
            if (!this.hasKey(keyName)) {
                statement = this.database_.compileStatement("INSERT INTO keys (identity_id, key_name, key_bits) VALUES ((SELECT id FROM identities WHERE identity=?), ?, ?)");
                try {
                    statement.bindBlob(1, identityName.wireEncode().getImmutableArray());
                    statement.bindBlob(2, keyName.wireEncode().getImmutableArray());
                    statement.bindBlob(3, new Blob(key, false).getImmutableArray());
                    if (statement.executeUpdateDelete() <= 0) {
                        throw new PibImpl.Error("AndroidSqlite3Pib: SQLite error");
                    }
                    break block12;
                }
                finally {
                    statement.close();
                }
            }
            statement = this.database_.compileStatement("UPDATE keys SET key_bits=? WHERE key_name=?");
            try {
                statement.bindBlob(1, new Blob(key, false).getImmutableArray());
                statement.bindBlob(2, keyName.wireEncode().getImmutableArray());
                if (statement.executeUpdateDelete() <= 0) {
                    throw new PibImpl.Error("AndroidSqlite3Pib: SQLite error");
                }
            }
            finally {
                statement.close();
            }
        }
        if (!this.hasDefaultKeyOfIdentity(identityName)) {
            try {
                this.setDefaultKeyOfIdentity(identityName, keyName);
            }
            catch (Pib.Error ex) {
                throw new PibImpl.Error("PibSqlite3: Error setting the default key: " + ex);
            }
        }
    }

    @Override
    public void removeKey(Name keyName) throws PibImpl.Error {
        byte[] keyNameBytes = keyName.wireEncode().getImmutableArray();
        this.database_.execSQL("DELETE FROM certificates WHERE key_id=(SELECT id FROM keys WHERE key_name=?)", new Object[]{keyNameBytes});
        this.database_.execSQL("DELETE FROM keys WHERE key_name=?", new Object[]{keyNameBytes});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob getKeyBits(Name keyName) throws Pib.Error, PibImpl.Error {
        long keyId;
        try (SQLiteStatement statement = this.database_.compileStatement("SELECT keys.id FROM keys WHERE key_name=?");){
            statement.bindBlob(1, keyName.wireEncode().getImmutableArray());
            try {
                keyId = statement.simpleQueryForLong();
            }
            catch (SQLiteDoneException ex) {
                throw new Pib.Error("Key `" + keyName.toUri() + "` does not exist");
            }
        }
        try (Cursor cursor = this.database_.rawQuery("SELECT key_bits FROM keys WHERE id=?", new String[]{Long.toString(keyId)});){
            if (cursor.moveToNext()) {
                Blob blob = new Blob(cursor.getBlob(0));
                return blob;
            }
            throw new Pib.Error("Key `" + keyName.toUri() + "` does not exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashSet<Name> getKeysOfIdentity(Name identityName) throws PibImpl.Error {
        HashSet<Name> keyNames = new HashSet<Name>();
        try (Cursor cursor = this.database_.rawQuery("SELECT key_name FROM keys JOIN identities ON keys.identity_id=identities.id WHERE identities.identity=?".substring(0, "SELECT key_name FROM keys JOIN identities ON keys.identity_id=identities.id WHERE identities.identity=?".length() - 1) + "x'" + identityName.wireEncode().toHex() + "'", null);){
            while (cursor.moveToNext()) {
                Name name = new Name();
                try {
                    name.wireDecode(new Blob(cursor.getBlob(0)));
                }
                catch (EncodingException ex) {
                    throw new PibImpl.Error("PibSqlite3: Error decoding name: " + ex);
                }
                keyNames.add(name);
            }
        }
        return keyNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultKeyOfIdentity(Name identityName, Name keyName) throws Pib.Error, PibImpl.Error {
        if (!this.hasKey(keyName)) {
            throw new Pib.Error("Key `" + keyName.toUri() + "` does not exist");
        }
        this.database_.execSQL("UPDATE keys SET is_default=0 WHERE is_default=1", new Object[0]);
        try (SQLiteStatement statement = this.database_.compileStatement("UPDATE keys SET is_default=1 WHERE key_name=?");){
            statement.bindBlob(1, keyName.wireEncode().getImmutableArray());
            if (statement.executeUpdateDelete() <= 0) {
                throw new PibImpl.Error("AndroidSqlite3Pib: SQLite error");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Name getDefaultKeyOfIdentity(Name identityName) throws Pib.Error, PibImpl.Error {
        long keyId;
        if (!this.hasIdentity(identityName)) {
            throw new Pib.Error("Identity `" + identityName.toUri() + "` does not exist");
        }
        try (SQLiteStatement statement = this.database_.compileStatement("SELECT keys.id FROM keys JOIN identities ON keys.identity_id=identities.id WHERE identities.identity=? AND keys.is_default=1");){
            statement.bindBlob(1, identityName.wireEncode().getImmutableArray());
            try {
                keyId = statement.simpleQueryForLong();
            }
            catch (SQLiteDoneException ex) {
                throw new Pib.Error("No default key for identity `" + identityName.toUri() + "`");
            }
        }
        try (Cursor cursor = this.database_.rawQuery("SELECT key_name FROM keys WHERE id=?", new String[]{Long.toString(keyId)});){
            if (cursor.moveToNext()) {
                Name name = new Name();
                try {
                    name.wireDecode(new Blob(cursor.getBlob(0)));
                }
                catch (EncodingException ex) {
                    throw new PibImpl.Error("PibSqlite3: Error decoding name: " + ex);
                }
                Name name2 = name;
                return name2;
            }
            throw new Pib.Error("No default key for identity `" + identityName.toUri() + "`");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasCertificate(Name certificateName) throws PibImpl.Error {
        try (SQLiteStatement statement = this.database_.compileStatement("SELECT id FROM certificates WHERE certificate_name=?");){
            statement.bindBlob(1, certificateName.wireEncode().getImmutableArray());
            try {
                statement.simpleQueryForLong();
                boolean bl = true;
                return bl;
            }
            catch (SQLiteDoneException ex) {
                boolean bl = false;
                statement.close();
                return bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCertificate(CertificateV2 certificate) throws PibImpl.Error {
        block12: {
            SQLiteStatement statement;
            Blob content = certificate.getContent();
            this.addKey(certificate.getIdentity(), certificate.getKeyName(), content.buf());
            if (!this.hasCertificate(certificate.getName())) {
                statement = this.database_.compileStatement("INSERT INTO certificates (key_id, certificate_name, certificate_data) VALUES ((SELECT id FROM keys WHERE key_name=?), ?, ?)");
                try {
                    statement.bindBlob(1, certificate.getKeyName().wireEncode().getImmutableArray());
                    statement.bindBlob(2, certificate.getName().wireEncode().getImmutableArray());
                    statement.bindBlob(3, certificate.wireEncode().getImmutableArray());
                    if (statement.executeUpdateDelete() <= 0) {
                        throw new PibImpl.Error("AndroidSqlite3Pib: SQLite error");
                    }
                    break block12;
                }
                finally {
                    statement.close();
                }
            }
            statement = this.database_.compileStatement("UPDATE certificates SET certificate_data=? WHERE certificate_name=?");
            try {
                statement.bindBlob(1, certificate.wireEncode().getImmutableArray());
                statement.bindBlob(2, certificate.getName().wireEncode().getImmutableArray());
                if (statement.executeUpdateDelete() <= 0) {
                    throw new PibImpl.Error("AndroidSqlite3Pib: SQLite error");
                }
            }
            finally {
                statement.close();
            }
        }
        if (!this.hasDefaultCertificateOfKey(certificate.getKeyName())) {
            try {
                this.setDefaultCertificateOfKey(certificate.getKeyName(), certificate.getName());
            }
            catch (Pib.Error ex) {
                throw new PibImpl.Error("PibSqlite3: Error setting the default certificate: " + ex);
            }
        }
    }

    @Override
    public void removeCertificate(Name certificateName) throws PibImpl.Error {
        this.database_.execSQL("DELETE FROM certificates WHERE certificate_name=?", new Object[]{certificateName.wireEncode().getImmutableArray()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CertificateV2 getCertificate(Name certificateName) throws Pib.Error, PibImpl.Error {
        long certificateId;
        try (SQLiteStatement statement = this.database_.compileStatement("SELECT certificates.id FROM certificates WHERE certificate_name=?");){
            statement.bindBlob(1, certificateName.wireEncode().getImmutableArray());
            try {
                certificateId = statement.simpleQueryForLong();
            }
            catch (SQLiteDoneException ex) {
                throw new Pib.Error("Certificate `" + certificateName.toUri() + "` does not exit");
            }
        }
        try (Cursor cursor = this.database_.rawQuery("SELECT certificate_data FROM certificates WHERE id=?", new String[]{Long.toString(certificateId)});){
            if (cursor.moveToNext()) {
                CertificateV2 certificate = new CertificateV2();
                try {
                    certificate.wireDecode(new Blob(cursor.getBlob(0)));
                }
                catch (EncodingException ex) {
                    throw new PibImpl.Error("PibSqlite3: Error decoding certificate: " + ex);
                }
                CertificateV2 certificateV2 = certificate;
                return certificateV2;
            }
            throw new Pib.Error("Certificate `" + certificateName.toUri() + "` does not exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashSet<Name> getCertificatesOfKey(Name keyName) throws PibImpl.Error {
        HashSet<Name> certNames = new HashSet<Name>();
        try (Cursor cursor = this.database_.rawQuery("SELECT certificate_name FROM certificates JOIN keys ON certificates.key_id=keys.id WHERE keys.key_name=?".substring(0, "SELECT certificate_name FROM certificates JOIN keys ON certificates.key_id=keys.id WHERE keys.key_name=?".length() - 1) + "x'" + keyName.wireEncode().toHex() + "'", null);){
            while (cursor.moveToNext()) {
                Name name = new Name();
                try {
                    name.wireDecode(new Blob(cursor.getBlob(0)));
                }
                catch (EncodingException ex) {
                    throw new PibImpl.Error("PibSqlite3: Error decoding name: " + ex);
                }
                certNames.add(name);
            }
        }
        return certNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultCertificateOfKey(Name keyName, Name certificateName) throws Pib.Error, PibImpl.Error {
        if (!this.hasCertificate(certificateName)) {
            throw new Pib.Error("Certificate `" + certificateName.toUri() + "` does not exist");
        }
        this.database_.execSQL("UPDATE certificates SET is_default=0 WHERE is_default=1", new Object[0]);
        try (SQLiteStatement statement = this.database_.compileStatement("UPDATE certificates SET is_default=1 WHERE certificate_name=?");){
            statement.bindBlob(1, certificateName.wireEncode().getImmutableArray());
            if (statement.executeUpdateDelete() <= 0) {
                throw new PibImpl.Error("AndroidSqlite3Pib: SQLite error");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CertificateV2 getDefaultCertificateOfKey(Name keyName) throws Pib.Error, PibImpl.Error {
        long certificateId;
        try (SQLiteStatement statement = this.database_.compileStatement("SELECT certificates.id FROM certificates JOIN keys ON certificates.key_id=keys.id WHERE certificates.is_default=1 AND keys.key_name=?");){
            statement.bindBlob(1, keyName.wireEncode().getImmutableArray());
            try {
                certificateId = statement.simpleQueryForLong();
            }
            catch (SQLiteDoneException ex) {
                throw new Pib.Error("No default certificate for key `" + keyName.toUri() + "`");
            }
        }
        try (Cursor cursor = this.database_.rawQuery("SELECT certificate_data FROM certificates WHERE id=?", new String[]{Long.toString(certificateId)});){
            if (cursor.moveToNext()) {
                CertificateV2 certificate = new CertificateV2();
                try {
                    certificate.wireDecode(new Blob(cursor.getBlob(0)));
                }
                catch (EncodingException ex) {
                    throw new PibImpl.Error("PibSqlite3: Error decoding certificate: " + ex);
                }
                CertificateV2 certificateV2 = certificate;
                return certificateV2;
            }
            throw new Pib.Error("No default certificate for key `" + keyName.toUri() + "`");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasDefaultIdentity() throws PibImpl.Error {
        try (SQLiteStatement statement = this.database_.compileStatement("SELECT id FROM identities WHERE is_default=1");){
            statement.simpleQueryForLong();
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasDefaultKeyOfIdentity(Name identityName) throws PibImpl.Error {
        try (SQLiteStatement statement = this.database_.compileStatement("SELECT keys.id FROM keys JOIN identities ON keys.identity_id=identities.id WHERE identities.identity=? AND keys.is_default=1");){
            statement.bindBlob(1, identityName.wireEncode().getImmutableArray());
            try {
                statement.simpleQueryForLong();
                boolean bl = true;
                return bl;
            }
            catch (SQLiteDoneException ex) {
                boolean bl = false;
                statement.close();
                return bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasDefaultCertificateOfKey(Name keyName) throws PibImpl.Error {
        try (SQLiteStatement statement = this.database_.compileStatement("SELECT certificates.id FROM certificates JOIN keys ON certificates.key_id=keys.id WHERE certificates.is_default=1 AND keys.key_name=?");){
            statement.bindBlob(1, keyName.wireEncode().getImmutableArray());
            try {
                statement.simpleQueryForLong();
                boolean bl = true;
                return bl;
            }
            catch (SQLiteDoneException ex) {
                boolean bl = false;
                statement.close();
                return bl;
            }
        }
    }
}

