/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.ContentType;
import net.named_data.jndn.Data;
import net.named_data.jndn.DigestSha256Signature;
import net.named_data.jndn.Face;
import net.named_data.jndn.HmacWithSha256Signature;
import net.named_data.jndn.Interest;
import net.named_data.jndn.KeyLocator;
import net.named_data.jndn.KeyLocatorType;
import net.named_data.jndn.Name;
import net.named_data.jndn.OnData;
import net.named_data.jndn.OnTimeout;
import net.named_data.jndn.Sha256WithEcdsaSignature;
import net.named_data.jndn.Sha256WithRsaSignature;
import net.named_data.jndn.Signature;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.encoding.der.DerDecodingException;
import net.named_data.jndn.security.DigestAlgorithm;
import net.named_data.jndn.security.KeyParams;
import net.named_data.jndn.security.KeyType;
import net.named_data.jndn.security.OnDataValidationFailed;
import net.named_data.jndn.security.OnInterestValidationFailed;
import net.named_data.jndn.security.OnVerified;
import net.named_data.jndn.security.OnVerifiedInterest;
import net.named_data.jndn.security.OnVerifyFailed;
import net.named_data.jndn.security.OnVerifyInterestFailed;
import net.named_data.jndn.security.RsaKeyParams;
import net.named_data.jndn.security.SafeBag;
import net.named_data.jndn.security.SecurityException;
import net.named_data.jndn.security.SigningInfo;
import net.named_data.jndn.security.UnrecognizedKeyFormatException;
import net.named_data.jndn.security.ValidationRequest;
import net.named_data.jndn.security.ValidityPeriod;
import net.named_data.jndn.security.VerificationHelpers;
import net.named_data.jndn.security.certificate.IdentityCertificate;
import net.named_data.jndn.security.certificate.PublicKey;
import net.named_data.jndn.security.identity.BasicIdentityStorage;
import net.named_data.jndn.security.identity.IdentityManager;
import net.named_data.jndn.security.pib.Pib;
import net.named_data.jndn.security.pib.PibIdentity;
import net.named_data.jndn.security.pib.PibImpl;
import net.named_data.jndn.security.pib.PibKey;
import net.named_data.jndn.security.pib.PibMemory;
import net.named_data.jndn.security.pib.PibSqlite3;
import net.named_data.jndn.security.policy.NoVerifyPolicyManager;
import net.named_data.jndn.security.policy.PolicyManager;
import net.named_data.jndn.security.tpm.Tpm;
import net.named_data.jndn.security.tpm.TpmBackEnd;
import net.named_data.jndn.security.tpm.TpmBackEndFile;
import net.named_data.jndn.security.tpm.TpmBackEndMemory;
import net.named_data.jndn.security.v2.CertificateV2;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.Common;
import net.named_data.jndn.util.ConfigFile;
import net.named_data.jndn.util.SignedBlob;

public class KeyChain {
    public static final RsaKeyParams DEFAULT_KEY_PARAMS = new RsaKeyParams();
    private boolean isSecurityV1_;
    private IdentityManager identityManager_;
    private PolicyManager policyManager_;
    private Face face_ = null;
    private Pib pib_;
    private Tpm tpm_;
    private static String defaultPibLocator_ = null;
    private static String defaultTpmLocator_ = null;
    private static HashMap<String, MakePibImpl> pibFactories_ = null;
    private static HashMap<String, MakeTpmBackEnd> tpmFactories_ = null;
    private static final SigningInfo defaultSigningInfo_ = new SigningInfo();
    private static final KeyParams defaultKeyParams_ = new RsaKeyParams();
    private static final Logger logger_ = Logger.getLogger(KeyChain.class.getName());

    public KeyChain(String pibLocator, String tpmLocator, boolean allowReset) throws Error, PibImpl.Error, SecurityException, IOException {
        this.isSecurityV1_ = false;
        this.construct(pibLocator, tpmLocator, allowReset);
    }

    public KeyChain(String pibLocator, String tpmLocator) throws Error, PibImpl.Error, SecurityException, IOException {
        this.isSecurityV1_ = false;
        this.construct(pibLocator, tpmLocator, false);
    }

    public KeyChain(PibImpl pibImpl, TpmBackEnd tpmBackEnd, PolicyManager policyManager) throws PibImpl.Error {
        this.isSecurityV1_ = false;
        this.policyManager_ = policyManager;
        this.pib_ = new Pib("", "", pibImpl);
        this.tpm_ = new Tpm("", "", tpmBackEnd);
    }

    public KeyChain(PibImpl pibImpl, TpmBackEnd tpmBackEnd) throws PibImpl.Error {
        this.isSecurityV1_ = false;
        this.policyManager_ = new NoVerifyPolicyManager();
        this.pib_ = new Pib("", "", pibImpl);
        this.tpm_ = new Tpm("", "", tpmBackEnd);
    }

    public KeyChain(IdentityManager identityManager, PolicyManager policyManager) {
        this.isSecurityV1_ = true;
        this.identityManager_ = identityManager;
        this.policyManager_ = policyManager;
    }

    public KeyChain(IdentityManager identityManager) {
        this.isSecurityV1_ = true;
        this.identityManager_ = identityManager;
        this.policyManager_ = new NoVerifyPolicyManager();
    }

    public KeyChain() throws SecurityException, Error, PibImpl.Error, IOException {
        this.isSecurityV1_ = false;
        if (BasicIdentityStorage.getDefaultDatabaseFilePath().exists() && !PibSqlite3.getDefaultDatabaseFilePath().exists()) {
            this.isSecurityV1_ = true;
            this.identityManager_ = new IdentityManager();
            this.policyManager_ = new NoVerifyPolicyManager();
            return;
        }
        this.construct("", "", true);
    }

    public final Pib getPib() {
        if (this.isSecurityV1_) {
            throw new AssertionError((Object)"getPib is not supported for security v1");
        }
        return this.pib_;
    }

    public final Tpm getTpm() {
        if (this.isSecurityV1_) {
            throw new AssertionError((Object)"getTpm is not supported for security v1");
        }
        return this.tpm_;
    }

    public final boolean getIsSecurityV1() {
        return this.isSecurityV1_;
    }

    public final PibIdentity createIdentityV2(Name identityName, KeyParams params) throws PibImpl.Error, Pib.Error, Tpm.Error, TpmBackEnd.Error, Error {
        PibKey key;
        PibIdentity id = this.pib_.addIdentity_(identityName);
        try {
            key = id.getDefaultKey();
        }
        catch (Pib.Error ex) {
            key = this.createKey(id, params);
        }
        try {
            key.getDefaultCertificate();
        }
        catch (Pib.Error ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "No default cert for " + key.getName() + ", requesting self-signing");
            this.selfSign(key);
        }
        return id;
    }

    public final PibIdentity createIdentityV2(Name identityName) throws PibImpl.Error, Pib.Error, Tpm.Error, TpmBackEnd.Error, Error {
        return this.createIdentityV2(identityName, KeyChain.getDefaultKeyParams());
    }

    public final void deleteIdentity(PibIdentity identity) throws PibImpl.Error, TpmBackEnd.Error {
        Name identityName = identity.getName();
        ArrayList<Name> keyNames = identity.getKeys_().getKeyNames();
        for (Name keyName : keyNames) {
            this.tpm_.deleteKey_(keyName);
        }
        this.pib_.removeIdentity_(identityName);
    }

    public final void setDefaultIdentity(PibIdentity identity) throws PibImpl.Error, Pib.Error {
        this.pib_.setDefaultIdentity_(identity.getName());
    }

    public final PibKey createKey(PibIdentity identity, KeyParams params) throws Tpm.Error, TpmBackEnd.Error, PibImpl.Error, Pib.Error, Error {
        Name keyName = this.tpm_.createKey_(identity.getName(), params);
        Blob publicKey = this.tpm_.getPublicKey(keyName);
        PibKey key = identity.addKey_(publicKey.buf(), keyName);
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Requesting self-signing for newly created key " + key.getName().toUri());
        this.selfSign(key);
        return key;
    }

    public final PibKey createKey(PibIdentity identity) throws Tpm.Error, TpmBackEnd.Error, PibImpl.Error, Pib.Error, Error {
        return this.createKey(identity, KeyChain.getDefaultKeyParams());
    }

    public final void deleteKey(PibIdentity identity, PibKey key) throws PibImpl.Error, TpmBackEnd.Error {
        Name keyName = key.getName();
        if (!identity.getName().equals(key.getIdentityName())) {
            throw new IllegalArgumentException("Identity `" + identity.getName().toUri() + "` does not match key `" + keyName.toUri() + "`");
        }
        identity.removeKey_(keyName);
        this.tpm_.deleteKey_(keyName);
    }

    public final void setDefaultKey(PibIdentity identity, PibKey key) throws Pib.Error, PibImpl.Error {
        if (!identity.getName().equals(key.getIdentityName())) {
            throw new IllegalArgumentException("Identity `" + identity.getName().toUri() + "` does not match key `" + key.getName().toUri() + "`");
        }
        identity.setDefaultKey_(key.getName());
    }

    public final void addCertificate(PibKey key, CertificateV2 certificate) throws CertificateV2.Error, PibImpl.Error {
        if (!key.getName().equals(certificate.getKeyName()) || !certificate.getContent().equals(key.getPublicKey())) {
            throw new IllegalArgumentException("Key `" + key.getName().toUri() + "` does not match certificate `" + certificate.getKeyName().toUri() + "`");
        }
        key.addCertificate_(certificate);
    }

    public final void deleteCertificate(PibKey key, Name certificateName) throws PibImpl.Error {
        if (!CertificateV2.isValidName(certificateName)) {
            throw new IllegalArgumentException("Wrong certificate name `" + certificateName.toUri() + "`");
        }
        key.removeCertificate_(certificateName);
    }

    public final void setDefaultCertificate(PibKey key, CertificateV2 certificate) throws PibImpl.Error, CertificateV2.Error, Pib.Error {
        this.addCertificate(key, certificate);
        key.setDefaultCertificate_(certificate.getName());
    }

    public final void sign(Data data, SigningInfo params, WireFormat wireFormat) throws TpmBackEnd.Error, PibImpl.Error, Error {
        Name[] keyName = new Name[1];
        Signature signatureInfo = this.prepareSignatureInfo(params, keyName);
        data.setSignature(signatureInfo);
        SignedBlob encoding = data.wireEncode(wireFormat);
        Blob signatureBytes = this.sign(encoding.signedBuf(), keyName[0], params.getDigestAlgorithm());
        data.getSignature().setSignature(signatureBytes);
        data.wireEncode(wireFormat);
    }

    public final void sign(Data data, SigningInfo params) throws TpmBackEnd.Error, PibImpl.Error, Error {
        this.sign(data, params, WireFormat.getDefaultWireFormat());
    }

    public final void sign(Data data, WireFormat wireFormat) throws SecurityException, TpmBackEnd.Error, PibImpl.Error, Error {
        if (this.isSecurityV1_) {
            this.identityManager_.signByCertificate(data, this.prepareDefaultCertificateName(), wireFormat);
            return;
        }
        this.sign(data, defaultSigningInfo_, wireFormat);
    }

    public final void sign(Data data) throws SecurityException, TpmBackEnd.Error, PibImpl.Error, Error {
        this.sign(data, WireFormat.getDefaultWireFormat());
    }

    public final void sign(Interest interest, SigningInfo params, WireFormat wireFormat) throws PibImpl.Error, Error, TpmBackEnd.Error {
        Name[] keyName = new Name[1];
        Signature signatureInfo = this.prepareSignatureInfo(params, keyName);
        interest.getName().append(wireFormat.encodeSignatureInfo(signatureInfo));
        interest.getName().append(new Name.Component());
        SignedBlob encoding = interest.wireEncode(wireFormat);
        Blob signatureBytes = this.sign(encoding.signedBuf(), keyName[0], params.getDigestAlgorithm());
        signatureInfo.setSignature(signatureBytes);
        interest.setName(interest.getName().getPrefix(-1).append(wireFormat.encodeSignatureValue(signatureInfo)));
    }

    public final void sign(Interest interest, SigningInfo params) throws PibImpl.Error, Error, TpmBackEnd.Error {
        this.sign(interest, params, WireFormat.getDefaultWireFormat());
    }

    public final void sign(Interest interest, WireFormat wireFormat) throws PibImpl.Error, Error, TpmBackEnd.Error, SecurityException {
        if (this.isSecurityV1_) {
            this.identityManager_.signInterestByCertificate(interest, this.prepareDefaultCertificateName(), wireFormat);
            return;
        }
        this.sign(interest, defaultSigningInfo_, wireFormat);
    }

    public final void sign(Interest interest) throws PibImpl.Error, Error, TpmBackEnd.Error, SecurityException {
        this.sign(interest, WireFormat.getDefaultWireFormat());
    }

    public final Blob sign(ByteBuffer buffer, SigningInfo params) throws PibImpl.Error, Error, TpmBackEnd.Error {
        Name[] keyName = new Name[1];
        Signature signatureInfo = this.prepareSignatureInfo(params, keyName);
        return this.sign(buffer, keyName[0], params.getDigestAlgorithm());
    }

    public final Blob sign(ByteBuffer buffer) throws PibImpl.Error, Error, TpmBackEnd.Error {
        return this.sign(buffer, defaultSigningInfo_);
    }

    public final CertificateV2 selfSign(PibKey key, WireFormat wireFormat) throws PibImpl.Error, Error, TpmBackEnd.Error {
        CertificateV2 certificate = new CertificateV2();
        double now = Common.getNowMilliseconds();
        Name certificateName = new Name(key.getName());
        certificateName.append("self").appendVersion((long)now);
        certificate.setName(certificateName);
        certificate.getMetaInfo().setType(ContentType.KEY);
        certificate.getMetaInfo().setFreshnessPeriod(3600000.0);
        certificate.setContent(key.getPublicKey());
        SigningInfo signingInfo = new SigningInfo(key);
        signingInfo.setValidityPeriod(new ValidityPeriod(now, now + 6.3072E11));
        this.sign((Data)certificate, signingInfo, wireFormat);
        try {
            key.addCertificate_(certificate);
        }
        catch (CertificateV2.Error ex) {
            throw new Error("Error encoding certificate: " + ex);
        }
        return certificate;
    }

    public final CertificateV2 selfSign(PibKey key) throws PibImpl.Error, Error, TpmBackEnd.Error {
        return this.selfSign(key, WireFormat.getDefaultWireFormat());
    }

    public final SafeBag exportSafeBag(CertificateV2 certificate, ByteBuffer password) throws Error {
        Blob encryptedKey;
        Name keyName = certificate.getKeyName();
        try {
            encryptedKey = this.tpm_.exportPrivateKey_(keyName, password);
        }
        catch (Throwable ex) {
            throw new Error("Failed to export private key `" + keyName.toUri() + "`: " + ex);
        }
        return new SafeBag(certificate, encryptedKey);
    }

    public final SafeBag exportSafeBag(CertificateV2 certificate) throws Error {
        return this.exportSafeBag(certificate, null);
    }

    public final void importSafeBag(SafeBag safeBag, ByteBuffer password) throws Error, CertificateV2.Error, TpmBackEnd.Error, PibImpl.Error, Pib.Error {
        CertificateV2 certificate = new CertificateV2(safeBag.getCertificate());
        Name identity = certificate.getIdentity();
        Name keyName = certificate.getKeyName();
        Blob publicKeyBits = certificate.getPublicKey();
        if (this.tpm_.hasKey(keyName)) {
            throw new Error("Private key `" + keyName.toUri() + "` already exists");
        }
        try {
            PibIdentity existingId = this.pib_.getIdentity(identity);
            existingId.getKey(keyName);
            throw new Error("Public key `" + keyName.toUri() + "` already exists");
        }
        catch (Pib.Error existingId) {
            PublicKey publicKey;
            Blob signatureBits;
            try {
                this.tpm_.importPrivateKey_(keyName, safeBag.getPrivateKeyBag().buf(), password);
            }
            catch (Exception ex) {
                throw new Error("Failed to import private key `" + keyName.toUri() + "`: " + ex);
            }
            Blob content = new Blob(new int[]{1, 2, 3, 4});
            try {
                signatureBits = this.tpm_.sign(content.buf(), keyName, DigestAlgorithm.SHA256);
            }
            catch (Exception ex) {
                this.tpm_.deleteKey_(keyName);
                throw new Error("Invalid private key `" + keyName.toUri() + "`");
            }
            try {
                publicKey = new PublicKey(publicKeyBits);
            }
            catch (UnrecognizedKeyFormatException ex) {
                this.tpm_.deleteKey_(keyName);
                throw new Error("Error decoding public key " + ex);
            }
            if (!VerificationHelpers.verifySignature(content, signatureBits, publicKey)) {
                this.tpm_.deleteKey_(keyName);
                throw new Error("Certificate `" + certificate.getName().toUri() + "` and private key `" + keyName.toUri() + "` do not match");
            }
            PibIdentity id = this.pib_.addIdentity_(identity);
            PibKey key = id.addKey_(certificate.getPublicKey().buf(), keyName);
            key.addCertificate_(certificate);
            return;
        }
    }

    public final void importSafeBag(SafeBag safeBag) throws Error, CertificateV2.Error, TpmBackEnd.Error, PibImpl.Error, Pib.Error {
        this.importSafeBag(safeBag, null);
    }

    public static void registerPibBackend(String scheme, MakePibImpl makePibImpl) {
        KeyChain.getPibFactories().put(scheme, makePibImpl);
    }

    public static void registerTpmBackend(String scheme, MakeTpmBackEnd makeTpmBackEnd) {
        KeyChain.getTpmFactories().put(scheme, makeTpmBackEnd);
    }

    public final Name createIdentityAndCertificate(Name identityName, KeyParams params) throws SecurityException {
        return this.identityManager_.createIdentityAndCertificate(identityName, params);
    }

    public final Name createIdentityAndCertificate(Name identityName) throws SecurityException {
        return this.createIdentityAndCertificate(identityName, KeyChain.getDefaultKeyParams());
    }

    public final Name createIdentity(Name identityName, KeyParams params) throws SecurityException {
        return IdentityCertificate.certificateNameToPublicKeyName(this.createIdentityAndCertificate(identityName, params));
    }

    public final Name createIdentity(Name identityName) throws SecurityException {
        return IdentityCertificate.certificateNameToPublicKeyName(this.createIdentityAndCertificate(identityName));
    }

    public final void deleteIdentity(Name identityName) throws SecurityException {
        if (!this.isSecurityV1_) {
            try {
                this.deleteIdentity(this.pib_.getIdentity(identityName));
            }
            catch (Pib.Error error) {
            }
            catch (PibImpl.Error error) {
            }
            catch (TpmBackEnd.Error error) {
                // empty catch block
            }
            return;
        }
        this.identityManager_.deleteIdentity(identityName);
    }

    public final Name getDefaultIdentity() throws SecurityException {
        if (!this.isSecurityV1_) {
            try {
                return this.pib_.getDefaultIdentity().getName();
            }
            catch (PibImpl.Error ex) {
                throw new SecurityException("Error in getDefaultIdentity: " + ex);
            }
            catch (Pib.Error ex) {
                throw new SecurityException("Error in getDefaultIdentity: " + ex);
            }
        }
        return this.identityManager_.getDefaultIdentity();
    }

    public final Name getDefaultCertificateName() throws SecurityException {
        if (!this.isSecurityV1_) {
            try {
                return this.pib_.getDefaultIdentity().getDefaultKey().getDefaultCertificate().getName();
            }
            catch (PibImpl.Error ex) {
                throw new SecurityException("Error in getDefaultCertificate: " + ex);
            }
            catch (Pib.Error ex) {
                throw new SecurityException("Error in getDefaultCertificate: " + ex);
            }
        }
        return this.identityManager_.getDefaultCertificateName();
    }

    public final Name generateRSAKeyPair(Name identityName, boolean isKsk, int keySize) throws SecurityException {
        if (!this.isSecurityV1_) {
            throw new SecurityException("generateRSAKeyPair is not supported for security v2. Use createIdentityV2.");
        }
        return this.identityManager_.generateRSAKeyPair(identityName, isKsk, keySize);
    }

    public final Name generateRSAKeyPair(Name identityName, boolean isKsk) throws SecurityException {
        if (!this.isSecurityV1_) {
            throw new SecurityException("generateRSAKeyPair is not supported for security v2. Use createIdentityV2.");
        }
        return this.identityManager_.generateRSAKeyPair(identityName, isKsk);
    }

    public final Name generateRSAKeyPair(Name identityName) throws SecurityException {
        if (!this.isSecurityV1_) {
            throw new SecurityException("generateRSAKeyPair is not supported for security v2. Use createIdentityV2.");
        }
        return this.identityManager_.generateRSAKeyPair(identityName);
    }

    public final Name generateEcdsaKeyPair(Name identityName, boolean isKsk, int keySize) throws SecurityException {
        if (!this.isSecurityV1_) {
            throw new SecurityException("generateEcdsaKeyPair is not supported for security v2. Use createIdentityV2.");
        }
        return this.identityManager_.generateEcdsaKeyPair(identityName, isKsk, keySize);
    }

    public final Name generateEcdsaKeyPair(Name identityName, boolean isKsk) throws SecurityException {
        if (!this.isSecurityV1_) {
            throw new SecurityException("generateEcdsaKeyPair is not supported for security v2. Use createIdentityV2.");
        }
        return this.identityManager_.generateEcdsaKeyPair(identityName, isKsk);
    }

    public final Name generateEcdsaKeyPair(Name identityName) throws SecurityException {
        if (!this.isSecurityV1_) {
            throw new SecurityException("generateEcdsaKeyPair is not supported for security v2. Use createIdentityV2.");
        }
        return this.identityManager_.generateEcdsaKeyPair(identityName);
    }

    public final void setDefaultKeyForIdentity(Name keyName, Name identityNameCheck) throws SecurityException {
        if (!this.isSecurityV1_) {
            throw new SecurityException("setDefaultKeyForIdentity is not supported for security v2. Use getPib() methods.");
        }
        this.identityManager_.setDefaultKeyForIdentity(keyName, identityNameCheck);
    }

    public final void setDefaultKeyForIdentity(Name keyName) throws SecurityException {
        if (!this.isSecurityV1_) {
            throw new SecurityException("setDefaultKeyForIdentity is not supported for security v2. Use getPib() methods.");
        }
        this.identityManager_.setDefaultKeyForIdentity(keyName);
    }

    public final Name generateRSAKeyPairAsDefault(Name identityName, boolean isKsk, int keySize) throws SecurityException {
        if (!this.isSecurityV1_) {
            throw new SecurityException("generateRSAKeyPairAsDefault is not supported for security v2. Use createIdentityV2.");
        }
        return this.identityManager_.generateRSAKeyPairAsDefault(identityName, isKsk, keySize);
    }

    public final Name generateRSAKeyPairAsDefault(Name identityName, boolean isKsk) throws SecurityException {
        if (!this.isSecurityV1_) {
            throw new SecurityException("generateRSAKeyPairAsDefault is not supported for security v2. Use createIdentityV2.");
        }
        return this.identityManager_.generateRSAKeyPairAsDefault(identityName, isKsk);
    }

    public final Name generateRSAKeyPairAsDefault(Name identityName) throws SecurityException {
        if (!this.isSecurityV1_) {
            throw new SecurityException("generateRSAKeyPairAsDefault is not supported for security v2. Use createIdentityV2.");
        }
        return this.identityManager_.generateRSAKeyPairAsDefault(identityName);
    }

    public final Name generateEcdsaKeyPairAsDefault(Name identityName, boolean isKsk, int keySize) throws SecurityException {
        if (!this.isSecurityV1_) {
            throw new SecurityException("generateEcdsaKeyPairAsDefault is not supported for security v2. Use createIdentityV2.");
        }
        return this.identityManager_.generateEcdsaKeyPairAsDefault(identityName, isKsk, keySize);
    }

    public final Name generateEcdsaKeyPairAsDefault(Name identityName, boolean isKsk) throws SecurityException {
        if (!this.isSecurityV1_) {
            throw new SecurityException("generateEcdsaKeyPairAsDefault is not supported for security v2. Use createIdentityV2.");
        }
        return this.identityManager_.generateEcdsaKeyPairAsDefault(identityName, isKsk);
    }

    public final Name generateEcdsaKeyPairAsDefault(Name identityName) throws SecurityException {
        if (!this.isSecurityV1_) {
            throw new SecurityException("generateEcdsaKeyPairAsDefault is not supported for security v2. Use createIdentityV2.");
        }
        return this.identityManager_.generateEcdsaKeyPairAsDefault(identityName);
    }

    public final Blob createSigningRequest(Name keyName) throws SecurityException {
        if (!this.isSecurityV1_) {
            try {
                return this.pib_.getIdentity(PibKey.extractIdentityFromKeyName(keyName)).getKey(keyName).getPublicKey();
            }
            catch (PibImpl.Error ex) {
                throw new SecurityException("Error in getKey: " + ex);
            }
            catch (Pib.Error ex) {
                throw new SecurityException("Error in getKey: " + ex);
            }
        }
        return this.identityManager_.getPublicKey(keyName).getKeyDer();
    }

    public final void installIdentityCertificate(IdentityCertificate certificate) throws SecurityException {
        if (!this.isSecurityV1_) {
            throw new SecurityException("installIdentityCertificate is not supported for security v2. Use getPib() methods.");
        }
        this.identityManager_.addCertificate(certificate);
    }

    public final void setDefaultCertificateForKey(IdentityCertificate certificate) throws SecurityException {
        if (!this.isSecurityV1_) {
            throw new SecurityException("setDefaultCertificateForKey is not supported for security v2. Use getPib() methods.");
        }
        this.identityManager_.setDefaultCertificateForKey(certificate);
    }

    public final IdentityCertificate getCertificate(Name certificateName) throws SecurityException, DerDecodingException {
        if (!this.isSecurityV1_) {
            throw new SecurityException("getCertificate is not supported for security v2. Use getPib() methods.");
        }
        return this.identityManager_.getCertificate(certificateName);
    }

    public final IdentityCertificate getIdentityCertificate(Name certificateName) throws SecurityException, DerDecodingException {
        if (!this.isSecurityV1_) {
            throw new SecurityException("getIdentityCertificate is not supported for security v2. Use getPib() methods.");
        }
        return this.identityManager_.getCertificate(certificateName);
    }

    public final void revokeKey(Name keyName) {
    }

    public final void revokeCertificate(Name certificateName) {
    }

    public final IdentityManager getIdentityManager() {
        if (!this.isSecurityV1_) {
            throw new AssertionError((Object)"getIdentityManager is not supported for security v2");
        }
        return this.identityManager_;
    }

    public final void sign(Data data, Name certificateName, WireFormat wireFormat) throws SecurityException {
        if (!this.isSecurityV1_) {
            SigningInfo signingInfo = new SigningInfo();
            signingInfo.setSigningCertificateName(certificateName);
            try {
                this.sign(data, signingInfo, wireFormat);
            }
            catch (TpmBackEnd.Error ex) {
                throw new SecurityException("Error in sign: " + ex);
            }
            catch (PibImpl.Error ex) {
                throw new SecurityException("Error in sign: " + ex);
            }
            catch (Error ex) {
                throw new SecurityException("Error in sign: " + ex);
            }
            return;
        }
        this.identityManager_.signByCertificate(data, certificateName, wireFormat);
    }

    public final void sign(Data data, Name certificateName) throws SecurityException {
        this.sign(data, certificateName, WireFormat.getDefaultWireFormat());
    }

    public final void sign(Interest interest, Name certificateName, WireFormat wireFormat) throws SecurityException {
        if (!this.isSecurityV1_) {
            SigningInfo signingInfo = new SigningInfo();
            signingInfo.setSigningCertificateName(certificateName);
            try {
                this.sign(interest, signingInfo, wireFormat);
            }
            catch (PibImpl.Error ex) {
                throw new SecurityException("Error in sign: " + ex);
            }
            catch (Error ex) {
                throw new SecurityException("Error in sign: " + ex);
            }
            catch (TpmBackEnd.Error ex) {
                throw new SecurityException("Error in sign: " + ex);
            }
            return;
        }
        this.identityManager_.signInterestByCertificate(interest, certificateName, wireFormat);
    }

    public final void sign(Interest interest, Name certificateName) throws SecurityException {
        this.sign(interest, certificateName, WireFormat.getDefaultWireFormat());
    }

    public Signature sign(ByteBuffer buffer, Name certificateName) throws SecurityException {
        if (!this.isSecurityV1_) {
            throw new SecurityException("sign(buffer, certificateName) is not supported for security v2. Use sign with SigningInfo.");
        }
        return this.identityManager_.signByCertificate(buffer, certificateName);
    }

    public final void signByIdentity(Data data, Name identityName, WireFormat wireFormat) throws SecurityException {
        Name inferredIdentity;
        if (!this.isSecurityV1_) {
            SigningInfo signingInfo = new SigningInfo();
            signingInfo.setSigningIdentity(identityName);
            try {
                this.sign(data, signingInfo, wireFormat);
            }
            catch (TpmBackEnd.Error ex) {
                throw new SecurityException("Error in sign: " + ex);
            }
            catch (PibImpl.Error ex) {
                throw new SecurityException("Error in sign: " + ex);
            }
            catch (Error ex) {
                throw new SecurityException("Error in sign: " + ex);
            }
            return;
        }
        Name signingCertificateName = identityName.size() == 0 ? ((inferredIdentity = this.policyManager_.inferSigningIdentity(data.getName())).size() == 0 ? this.identityManager_.getDefaultCertificateName() : this.identityManager_.getDefaultCertificateNameForIdentity(inferredIdentity)) : this.identityManager_.getDefaultCertificateNameForIdentity(identityName);
        if (signingCertificateName.size() == 0) {
            throw new SecurityException("No qualified certificate name found!");
        }
        if (!this.policyManager_.checkSigningPolicy(data.getName(), signingCertificateName)) {
            throw new SecurityException("Signing Cert name does not comply with signing policy");
        }
        this.identityManager_.signByCertificate(data, signingCertificateName, wireFormat);
    }

    public final void signByIdentity(Data data, Name identityName) throws SecurityException {
        this.signByIdentity(data, identityName, WireFormat.getDefaultWireFormat());
    }

    public final void signByIdentity(Data data) throws SecurityException {
        this.signByIdentity(data, new Name(), WireFormat.getDefaultWireFormat());
    }

    public Signature signByIdentity(ByteBuffer buffer, Name identityName) throws SecurityException {
        if (!this.isSecurityV1_) {
            throw new SecurityException("signByIdentity(buffer, identityName) is not supported for security v2. Use sign with SigningInfo.");
        }
        Name signingCertificateName = this.identityManager_.getDefaultCertificateNameForIdentity(identityName);
        if (signingCertificateName.size() == 0) {
            throw new SecurityException("No qualified certificate name found!");
        }
        return this.identityManager_.signByCertificate(buffer, signingCertificateName);
    }

    public final void signWithSha256(Data data, WireFormat wireFormat) throws SecurityException {
        if (!this.isSecurityV1_) {
            SigningInfo signingInfo = new SigningInfo();
            signingInfo.setSha256Signing();
            try {
                this.sign(data, signingInfo, wireFormat);
            }
            catch (TpmBackEnd.Error ex) {
                throw new SecurityException("Error in sign: " + ex);
            }
            catch (PibImpl.Error ex) {
                throw new SecurityException("Error in sign: " + ex);
            }
            catch (Error ex) {
                throw new SecurityException("Error in sign: " + ex);
            }
            return;
        }
        this.identityManager_.signWithSha256(data, wireFormat);
    }

    public final void signWithSha256(Data data) throws SecurityException {
        this.signWithSha256(data, WireFormat.getDefaultWireFormat());
    }

    public final void signWithSha256(Interest interest, WireFormat wireFormat) throws SecurityException {
        if (!this.isSecurityV1_) {
            SigningInfo signingInfo = new SigningInfo();
            signingInfo.setSha256Signing();
            try {
                this.sign(interest, signingInfo, wireFormat);
            }
            catch (PibImpl.Error ex) {
                throw new SecurityException("Error in sign: " + ex);
            }
            catch (Error ex) {
                throw new SecurityException("Error in sign: " + ex);
            }
            catch (TpmBackEnd.Error ex) {
                throw new SecurityException("Error in sign: " + ex);
            }
            return;
        }
        this.identityManager_.signInterestWithSha256(interest, wireFormat);
    }

    public final void signWithSha256(Interest interest) throws SecurityException {
        this.signWithSha256(interest, WireFormat.getDefaultWireFormat());
    }

    public final void verifyData(Data data, OnVerified onVerified, OnDataValidationFailed onValidationFailed, int stepCount) throws SecurityException {
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Enter Verify");
        if (this.policyManager_.requireVerify(data)) {
            ValidationRequest nextStep = this.policyManager_.checkVerificationPolicy(data, stepCount, onVerified, onValidationFailed);
            if (nextStep != null) {
                VerifyCallbacks callbacks = new VerifyCallbacks(nextStep, nextStep.retry_, onValidationFailed, data);
                try {
                    this.face_.expressInterest(nextStep.interest_, (OnData)callbacks, (OnTimeout)callbacks);
                }
                catch (IOException ex) {
                    try {
                        onValidationFailed.onDataValidationFailed(data, "Error calling expressInterest " + ex);
                    }
                    catch (Throwable exception) {
                        logger_.log(Level.SEVERE, "Error in onDataValidationFailed", exception);
                    }
                }
            }
        } else if (this.policyManager_.skipVerifyAndTrust(data)) {
            try {
                onVerified.onVerified(data);
            }
            catch (Throwable ex) {
                logger_.log(Level.SEVERE, "Error in onVerified", ex);
            }
        } else {
            try {
                onValidationFailed.onDataValidationFailed(data, "The packet has no verify rule but skipVerifyAndTrust is false");
            }
            catch (Throwable ex) {
                logger_.log(Level.SEVERE, "Error in onDataValidationFailed", ex);
            }
        }
    }

    public final void verifyData(Data data, OnVerified onVerified, OnDataValidationFailed onValidationFailed) throws SecurityException {
        this.verifyData(data, onVerified, onValidationFailed, 0);
    }

    public final void verifyData(Data data, OnVerified onVerified, final OnVerifyFailed onVerifyFailed) throws SecurityException {
        this.verifyData(data, onVerified, new OnDataValidationFailed(){

            @Override
            public void onDataValidationFailed(Data localData, String reason) {
                onVerifyFailed.onVerifyFailed(localData);
            }
        });
    }

    public final void verifyInterest(Interest interest, OnVerifiedInterest onVerified, OnInterestValidationFailed onValidationFailed, int stepCount) throws SecurityException {
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Enter Verify");
        if (this.policyManager_.requireVerify(interest)) {
            ValidationRequest nextStep = this.policyManager_.checkVerificationPolicy(interest, stepCount, onVerified, onValidationFailed);
            if (nextStep != null) {
                VerifyCallbacksForVerifyInterest callbacks = new VerifyCallbacksForVerifyInterest(nextStep, nextStep.retry_, onValidationFailed, interest);
                try {
                    this.face_.expressInterest(nextStep.interest_, (OnData)callbacks, (OnTimeout)callbacks);
                }
                catch (IOException ex) {
                    try {
                        onValidationFailed.onInterestValidationFailed(interest, "Error calling expressInterest " + ex);
                    }
                    catch (Throwable exception) {
                        logger_.log(Level.SEVERE, "Error in onInterestValidationFailed", exception);
                    }
                }
            }
        } else if (this.policyManager_.skipVerifyAndTrust(interest)) {
            try {
                onVerified.onVerifiedInterest(interest);
            }
            catch (Throwable ex) {
                logger_.log(Level.SEVERE, "Error in onVerifiedInterest", ex);
            }
        } else {
            try {
                onValidationFailed.onInterestValidationFailed(interest, "The packet has no verify rule but skipVerifyAndTrust is false");
            }
            catch (Throwable ex) {
                logger_.log(Level.SEVERE, "Error in onInterestValidationFailed", ex);
            }
        }
    }

    public final void verifyInterest(Interest interest, OnVerifiedInterest onVerified, OnInterestValidationFailed onValidationFailed) throws SecurityException {
        this.verifyInterest(interest, onVerified, onValidationFailed, 0);
    }

    public final void verifyInterest(Interest interest, OnVerifiedInterest onVerified, final OnVerifyInterestFailed onVerifyFailed) throws SecurityException {
        this.verifyInterest(interest, onVerified, new OnInterestValidationFailed(){

            @Override
            public void onInterestValidationFailed(Interest localInterest, String reason) {
                onVerifyFailed.onVerifyInterestFailed(localInterest);
            }
        });
    }

    public final void setFace(Face face) {
        this.face_ = face;
    }

    public static void signWithHmacWithSha256(Data data, Blob key, WireFormat wireFormat) {
        SignedBlob encoding = data.wireEncode(wireFormat);
        byte[] signatureBytes = Common.computeHmacWithSha256(key.getImmutableArray(), encoding.signedBuf());
        data.getSignature().setSignature(new Blob(signatureBytes, false));
    }

    public static void signWithHmacWithSha256(Data data, Blob key) {
        KeyChain.signWithHmacWithSha256(data, key, WireFormat.getDefaultWireFormat());
    }

    public static void signWithHmacWithSha256(Interest interest, Blob key, Name keyName, WireFormat wireFormat) {
        HmacWithSha256Signature signature = new HmacWithSha256Signature();
        signature.getKeyLocator().setType(KeyLocatorType.KEYNAME);
        signature.getKeyLocator().setKeyName(keyName);
        interest.getName().append(wireFormat.encodeSignatureInfo(signature));
        interest.getName().append(new Name.Component());
        SignedBlob encoding = interest.wireEncode(wireFormat);
        byte[] signatureBytes = Common.computeHmacWithSha256(key.getImmutableArray(), encoding.signedBuf());
        signature.setSignature(new Blob(signatureBytes, false));
        interest.setName(interest.getName().getPrefix(-1).append(wireFormat.encodeSignatureValue(signature)));
    }

    public static void signWithHmacWithSha256(Interest interest, Blob key, Name keyName) {
        KeyChain.signWithHmacWithSha256(interest, key, keyName, WireFormat.getDefaultWireFormat());
    }

    public static boolean verifyDataWithHmacWithSha256(Data data, Blob key, WireFormat wireFormat) {
        SignedBlob encoding = data.wireEncode(wireFormat);
        byte[] newSignatureBytes = Common.computeHmacWithSha256(key.getImmutableArray(), encoding.signedBuf());
        return ByteBuffer.wrap(newSignatureBytes).equals(data.getSignature().getSignature().buf());
    }

    public static boolean verifyDataWithHmacWithSha256(Data data, Blob key) {
        return KeyChain.verifyDataWithHmacWithSha256(data, key, WireFormat.getDefaultWireFormat());
    }

    public static boolean verifyInterestWithHmacWithSha256(Interest interest, Blob key, WireFormat wireFormat) {
        Signature signature;
        try {
            signature = wireFormat.decodeSignatureInfoAndValue(interest.getName().get(-2).getValue().buf(), interest.getName().get(-1).getValue().buf());
        }
        catch (EncodingException ex) {
            return false;
        }
        SignedBlob encoding = interest.wireEncode(wireFormat);
        byte[] newSignatureBytes = Common.computeHmacWithSha256(key.getImmutableArray(), encoding.signedBuf());
        return ByteBuffer.wrap(newSignatureBytes).equals(signature.getSignature().buf());
    }

    public static boolean verifyInterestWithHmacWithSha256(Interest interest, Blob key) {
        return KeyChain.verifyInterestWithHmacWithSha256(interest, key, WireFormat.getDefaultWireFormat());
    }

    public static KeyParams getDefaultKeyParams() {
        return defaultKeyParams_;
    }

    private void construct(String pibLocator, String tpmLocator, boolean allowReset) throws Error, PibImpl.Error, SecurityException, IOException {
        String[] pibScheme = new String[1];
        String[] pibLocation = new String[1];
        KeyChain.parseAndCheckPibLocator(pibLocator, pibScheme, pibLocation);
        String canonicalPibLocator = pibScheme[0] + ":" + pibLocation[0];
        this.pib_ = KeyChain.createPib(canonicalPibLocator);
        String oldTpmLocator = "";
        try {
            oldTpmLocator = this.pib_.getTpmLocator();
        }
        catch (Pib.Error error) {
            // empty catch block
        }
        String[] tpmScheme = new String[1];
        String[] tpmLocation = new String[1];
        KeyChain.parseAndCheckTpmLocator(tpmLocator, tpmScheme, tpmLocation);
        String canonicalTpmLocator = tpmScheme[0] + ":" + tpmLocation[0];
        ConfigFile config = new ConfigFile();
        if (canonicalPibLocator.equals(KeyChain.getDefaultPibLocator(config))) {
            if (!oldTpmLocator.equals("") && !oldTpmLocator.equals(KeyChain.getDefaultTpmLocator(config))) {
                this.pib_.reset_();
                canonicalTpmLocator = KeyChain.getDefaultTpmLocator(config);
            }
        } else if (!oldTpmLocator.equals("") && !oldTpmLocator.equals(canonicalTpmLocator)) {
            if (allowReset) {
                this.pib_.reset_();
            } else {
                throw new LocatorMismatchError("The supplied TPM locator does not match the TPM locator in the PIB: " + oldTpmLocator + " != " + canonicalTpmLocator);
            }
        }
        this.tpm_ = KeyChain.createTpm(canonicalTpmLocator);
        this.pib_.setTpmLocator(canonicalTpmLocator);
    }

    private static HashMap<String, MakePibImpl> getPibFactories() {
        if (pibFactories_ == null) {
            pibFactories_ = new HashMap();
            pibFactories_.put(PibSqlite3.getScheme(), new MakePibImpl(){

                @Override
                public PibImpl makePibImpl(String location) throws PibImpl.Error {
                    return new PibSqlite3(location);
                }
            });
            pibFactories_.put(PibMemory.getScheme(), new MakePibImpl(){

                @Override
                public PibImpl makePibImpl(String location) throws PibImpl.Error {
                    return new PibMemory();
                }
            });
        }
        return pibFactories_;
    }

    private static HashMap<String, MakeTpmBackEnd> getTpmFactories() {
        if (tpmFactories_ == null) {
            tpmFactories_ = new HashMap();
            tpmFactories_.put(TpmBackEndFile.getScheme(), new MakeTpmBackEnd(){

                @Override
                public TpmBackEnd makeTpmBackEnd(String location) {
                    return new TpmBackEndFile(location);
                }
            });
            tpmFactories_.put(TpmBackEndMemory.getScheme(), new MakeTpmBackEnd(){

                @Override
                public TpmBackEnd makeTpmBackEnd(String location) {
                    return new TpmBackEndMemory();
                }
            });
        }
        return tpmFactories_;
    }

    private static void parseLocatorUri(String uri, String[] scheme, String[] location) {
        int iColon = uri.indexOf(58);
        if (iColon >= 0) {
            scheme[0] = uri.substring(0, iColon);
            location[0] = uri.substring(iColon + 1);
        } else {
            scheme[0] = uri;
            location[0] = "";
        }
    }

    private static void parseAndCheckPibLocator(String pibLocator, String[] pibScheme, String[] pibLocation) throws Error {
        KeyChain.parseLocatorUri(pibLocator, pibScheme, pibLocation);
        if (pibScheme[0].equals("")) {
            pibScheme[0] = KeyChain.getDefaultPibScheme();
        }
        if (!KeyChain.getPibFactories().containsKey(pibScheme[0])) {
            throw new Error("PIB scheme `" + pibScheme[0] + "` is not supported");
        }
    }

    private static void parseAndCheckTpmLocator(String tpmLocator, String[] tpmScheme, String[] tpmLocation) throws SecurityException, Error {
        KeyChain.parseLocatorUri(tpmLocator, tpmScheme, tpmLocation);
        if (tpmScheme[0].equals("")) {
            tpmScheme[0] = KeyChain.getDefaultTpmScheme();
        }
        if (!KeyChain.getTpmFactories().containsKey(tpmScheme[0])) {
            throw new Error("TPM scheme `" + tpmScheme[0] + "` is not supported");
        }
    }

    private static String getDefaultPibScheme() {
        return PibSqlite3.getScheme();
    }

    private static String getDefaultTpmScheme() throws SecurityException {
        if (Common.platformIsOSX()) {
            throw new SecurityException("TpmBackEndOsx is not implemented yet. You must use tpm-file.");
        }
        return TpmBackEndFile.getScheme();
    }

    private static Pib createPib(String pibLocator) throws Error, PibImpl.Error {
        String[] pibScheme = new String[1];
        String[] pibLocation = new String[1];
        KeyChain.parseAndCheckPibLocator(pibLocator, pibScheme, pibLocation);
        MakePibImpl pibFactory = KeyChain.getPibFactories().get(pibScheme[0]);
        return new Pib(pibScheme[0], pibLocation[0], pibFactory.makePibImpl(pibLocation[0]));
    }

    private static Tpm createTpm(String tpmLocator) throws SecurityException, Error {
        String[] tpmScheme = new String[1];
        String[] tpmLocation = new String[1];
        KeyChain.parseAndCheckTpmLocator(tpmLocator, tpmScheme, tpmLocation);
        MakeTpmBackEnd tpmFactory = KeyChain.getTpmFactories().get(tpmScheme[0]);
        return new Tpm(tpmScheme[0], tpmLocation[0], tpmFactory.makeTpmBackEnd(tpmLocation[0]));
    }

    private static String getDefaultPibLocator(ConfigFile config) {
        if (defaultPibLocator_ != null) {
            return defaultPibLocator_;
        }
        String clientPib = System.getenv("NDN_CLIENT_PIB");
        defaultPibLocator_ = clientPib != null && clientPib != "" ? clientPib : config.get("pib", KeyChain.getDefaultPibScheme() + ":");
        return defaultPibLocator_;
    }

    private static String getDefaultTpmLocator(ConfigFile config) throws SecurityException {
        if (defaultTpmLocator_ != null) {
            return defaultTpmLocator_;
        }
        String clientTpm = System.getenv("NDN_CLIENT_TPM");
        defaultTpmLocator_ = clientTpm != null && clientTpm != "" ? clientTpm : config.get("tpm", KeyChain.getDefaultTpmScheme() + ":");
        return defaultTpmLocator_;
    }

    private Signature prepareSignatureInfo(SigningInfo params, Name[] keyName) throws PibImpl.Error, InvalidSigningInfoError, Error {
        Signature signatureInfo;
        Name identityName;
        PibIdentity identity = null;
        PibKey key = null;
        if (params.getSignerType() == SigningInfo.SignerType.NULL) {
            try {
                identity = this.pib_.getDefaultIdentity();
            }
            catch (Pib.Error ex) {
                keyName[0] = SigningInfo.getDigestSha256Identity();
                return new DigestSha256Signature();
            }
        } else if (params.getSignerType() == SigningInfo.SignerType.ID) {
            identity = params.getPibIdentity();
            if (identity == null) {
                try {
                    identity = this.pib_.getIdentity(params.getSignerName());
                }
                catch (Pib.Error ex) {
                    throw new InvalidSigningInfoError("Signing identity `" + params.getSignerName().toUri() + "` does not exist");
                }
            }
        } else if (params.getSignerType() == SigningInfo.SignerType.KEY) {
            key = params.getPibKey();
            if (key == null) {
                identityName = PibKey.extractIdentityFromKeyName(params.getSignerName());
                try {
                    identity = this.pib_.getIdentity(identityName);
                    key = identity.getKey(params.getSignerName());
                    identity = null;
                }
                catch (Pib.Error ex) {
                    throw new InvalidSigningInfoError("Signing key `" + params.getSignerName().toUri() + "` does not exist");
                }
            }
        } else if (params.getSignerType() == SigningInfo.SignerType.CERT) {
            identityName = CertificateV2.extractIdentityFromCertName(params.getSignerName());
            try {
                identity = this.pib_.getIdentity(identityName);
                key = identity.getKey(CertificateV2.extractKeyNameFromCertName(params.getSignerName()));
            }
            catch (Pib.Error ex) {
                throw new InvalidSigningInfoError("Signing certificate `" + params.getSignerName().toUri() + "` does not exist");
            }
        } else {
            if (params.getSignerType() == SigningInfo.SignerType.SHA256) {
                keyName[0] = SigningInfo.getDigestSha256Identity();
                return new DigestSha256Signature();
            }
            throw new InvalidSigningInfoError("Unrecognized signer type");
        }
        if (identity == null && key == null) {
            throw new InvalidSigningInfoError("Cannot determine signing parameters");
        }
        if (identity != null && key == null) {
            try {
                key = identity.getDefaultKey();
            }
            catch (Pib.Error ex) {
                throw new InvalidSigningInfoError("Signing identity `" + identity.getName().toUri() + "` does not have default certificate");
            }
        }
        if (key.getKeyType() == KeyType.RSA && params.getDigestAlgorithm() == DigestAlgorithm.SHA256) {
            signatureInfo = new Sha256WithRsaSignature();
        } else if (key.getKeyType() == KeyType.EC && params.getDigestAlgorithm() == DigestAlgorithm.SHA256) {
            signatureInfo = new Sha256WithEcdsaSignature();
        } else {
            throw new Error("Unsupported key type");
        }
        if (params.getValidityPeriod().hasPeriod() && ValidityPeriod.canGetFromSignature(signatureInfo)) {
            ValidityPeriod.getFromSignature(signatureInfo).setPeriod(params.getValidityPeriod().getNotBefore(), params.getValidityPeriod().getNotAfter());
        }
        KeyLocator keyLocator = KeyLocator.getFromSignature(signatureInfo);
        keyLocator.setType(KeyLocatorType.KEYNAME);
        keyLocator.setKeyName(key.getName());
        keyName[0] = key.getName();
        return signatureInfo;
    }

    private Blob sign(ByteBuffer buffer, Name keyName, DigestAlgorithm digestAlgorithm) throws TpmBackEnd.Error {
        if (keyName.equals(SigningInfo.getDigestSha256Identity())) {
            return new Blob(Common.digestSha256(buffer));
        }
        return this.tpm_.sign(buffer, keyName, digestAlgorithm);
    }

    private Name prepareDefaultCertificateName() throws SecurityException {
        IdentityCertificate signingCertificate = this.identityManager_.getDefaultCertificate();
        if (signingCertificate == null) {
            this.setDefaultCertificate();
            signingCertificate = this.identityManager_.getDefaultCertificate();
        }
        return signingCertificate.getName();
    }

    private void setDefaultCertificate() throws SecurityException {
        if (this.identityManager_.getDefaultCertificate() == null) {
            Name defaultIdentity;
            try {
                defaultIdentity = this.identityManager_.getDefaultIdentity();
            }
            catch (SecurityException e) {
                ByteBuffer randomComponent = ByteBuffer.allocate(4);
                Common.getRandom().nextBytes(randomComponent.array());
                defaultIdentity = new Name().append("tmp-identity").append(new Blob(randomComponent, false));
            }
            this.createIdentityAndCertificate(defaultIdentity);
            this.identityManager_.setDefaultIdentity(defaultIdentity);
        }
    }

    private class VerifyCallbacksForVerifyInterest
    implements OnData,
    OnTimeout {
        private final ValidationRequest nextStep_;
        private final int retry_;
        private final OnInterestValidationFailed onValidationFailed_;
        private final Interest originalInterest_;

        public VerifyCallbacksForVerifyInterest(ValidationRequest nextStep, int retry, OnInterestValidationFailed onValidationFailed, Interest originalInterest) {
            this.nextStep_ = nextStep;
            this.retry_ = retry;
            this.onValidationFailed_ = onValidationFailed;
            this.originalInterest_ = originalInterest;
        }

        @Override
        public final void onData(Interest interest, Data data) {
            try {
                KeyChain.this.verifyData(data, this.nextStep_.onVerified_, this.nextStep_.onValidationFailed_, this.nextStep_.stepCount_);
            }
            catch (SecurityException ex) {
                Logger.getLogger(KeyChain.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        @Override
        public final void onTimeout(Interest interest) {
            if (this.retry_ > 0) {
                VerifyCallbacksForVerifyInterest callbacks = new VerifyCallbacksForVerifyInterest(this.nextStep_, this.retry_ - 1, this.onValidationFailed_, this.originalInterest_);
                try {
                    KeyChain.this.face_.expressInterest(interest, (OnData)callbacks, (OnTimeout)callbacks);
                }
                catch (IOException ex) {
                    try {
                        this.onValidationFailed_.onInterestValidationFailed(this.originalInterest_, "Error in expressInterest to retry after timeout for fetching " + interest.getName().toUri() + ": " + ex);
                    }
                    catch (Throwable exception) {
                        logger_.log(Level.SEVERE, "Error in onInterestValidationFailed", exception);
                    }
                }
            } else {
                try {
                    this.onValidationFailed_.onInterestValidationFailed(this.originalInterest_, "The retry count is zero after timeout for fetching " + interest.getName().toUri());
                }
                catch (Throwable ex) {
                    logger_.log(Level.SEVERE, "Error in onInterestValidationFailed", ex);
                }
            }
        }
    }

    private class VerifyCallbacks
    implements OnData,
    OnTimeout {
        private final ValidationRequest nextStep_;
        private final int retry_;
        private final OnDataValidationFailed onValidationFailed_;
        private final Data originalData_;

        public VerifyCallbacks(ValidationRequest nextStep, int retry, OnDataValidationFailed onValidationFailed, Data originalData) {
            this.nextStep_ = nextStep;
            this.retry_ = retry;
            this.onValidationFailed_ = onValidationFailed;
            this.originalData_ = originalData;
        }

        @Override
        public final void onData(Interest interest, Data data) {
            try {
                KeyChain.this.verifyData(data, this.nextStep_.onVerified_, this.nextStep_.onValidationFailed_, this.nextStep_.stepCount_);
            }
            catch (SecurityException ex) {
                Logger.getLogger(KeyChain.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        @Override
        public final void onTimeout(Interest interest) {
            if (this.retry_ > 0) {
                VerifyCallbacks callbacks = new VerifyCallbacks(this.nextStep_, this.retry_ - 1, this.onValidationFailed_, this.originalData_);
                try {
                    KeyChain.this.face_.expressInterest(interest, (OnData)callbacks, (OnTimeout)callbacks);
                }
                catch (IOException ex) {
                    try {
                        this.onValidationFailed_.onDataValidationFailed(this.originalData_, "Error in expressInterest to retry after timeout for fetching " + interest.getName().toUri() + ": " + ex);
                    }
                    catch (Throwable exception) {
                        logger_.log(Level.SEVERE, "Error in onDataValidationFailed", exception);
                    }
                }
            } else {
                try {
                    this.onValidationFailed_.onDataValidationFailed(this.originalData_, "The retry count is zero after timeout for fetching " + interest.getName().toUri());
                }
                catch (Throwable ex) {
                    logger_.log(Level.SEVERE, "Error in onDataValidationFailed", ex);
                }
            }
        }
    }

    public static interface MakeTpmBackEnd {
        public TpmBackEnd makeTpmBackEnd(String var1);
    }

    public static interface MakePibImpl {
        public PibImpl makePibImpl(String var1) throws PibImpl.Error;
    }

    public static class LocatorMismatchError
    extends Error {
        public LocatorMismatchError(String message) {
            super(message);
        }
    }

    public static class InvalidSigningInfoError
    extends Error {
        public InvalidSigningInfoError(String message) {
            super(message);
        }
    }

    public static class Error
    extends Exception {
        public Error(String message) {
            super(message);
        }
    }
}

