/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.encrypt;

import java.nio.ByteBuffer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.TimeZone;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encoding.tlv.TlvDecoder;
import net.named_data.jndn.encoding.tlv.TlvEncoder;
import net.named_data.jndn.encrypt.Interval;
import net.named_data.jndn.encrypt.RepetitiveInterval;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.Common;

public class Schedule {
    private final HashSet<RepetitiveInterval> whiteIntervalList_ = new HashSet();
    private final HashSet<RepetitiveInterval> blackIntervalList_ = new HashSet();
    private static final SimpleDateFormat dateFormat = Schedule.getDateFormat();
    private static final long MILLISECONDS_IN_DAY = 86400000L;

    public Schedule() {
    }

    public Schedule(Schedule schedule) {
        this.whiteIntervalList_.addAll(schedule.whiteIntervalList_);
        this.blackIntervalList_.addAll(schedule.blackIntervalList_);
    }

    public final Schedule addWhiteInterval(RepetitiveInterval repetitiveInterval) {
        this.whiteIntervalList_.add(repetitiveInterval);
        return this;
    }

    public final Schedule addBlackInterval(RepetitiveInterval repetitiveInterval) {
        this.blackIntervalList_.add(repetitiveInterval);
        return this;
    }

    public final Result getCoveringInterval(double timeStamp) {
        Interval blackPositiveResult = new Interval(true);
        Interval whitePositiveResult = new Interval(true);
        Interval blackNegativeResult = new Interval();
        Interval whiteNegativeResult = new Interval();
        Schedule.calculateIntervalResult(this.blackIntervalList_, timeStamp, blackPositiveResult, blackNegativeResult);
        if (!blackPositiveResult.isEmpty()) {
            return new Result(false, blackPositiveResult);
        }
        Schedule.calculateIntervalResult(this.whiteIntervalList_, timeStamp, whitePositiveResult, whiteNegativeResult);
        if (whitePositiveResult.isEmpty() && !whiteNegativeResult.isValid()) {
            double timeStampDateOnly = RepetitiveInterval.toDateOnlyMilliseconds(timeStamp);
            return new Result(false, new Interval(timeStampDateOnly, timeStampDateOnly + 8.64E7));
        }
        if (!whitePositiveResult.isEmpty()) {
            if (blackNegativeResult.isValid()) {
                return new Result(true, whitePositiveResult.intersectWith(blackNegativeResult));
            }
            return new Result(true, whitePositiveResult);
        }
        return new Result(false, whiteNegativeResult);
    }

    public final Blob wireEncode() {
        RepetitiveInterval element;
        int i;
        TlvEncoder encoder = new TlvEncoder(256);
        int saveLength = encoder.getLength();
        int saveLengthForList = encoder.getLength();
        Object[] array = this.blackIntervalList_.toArray();
        Arrays.sort(array);
        for (i = array.length - 1; i >= 0; --i) {
            element = (RepetitiveInterval)array[i];
            Schedule.encodeRepetitiveInterval(element, encoder);
        }
        encoder.writeTypeAndLength(142, encoder.getLength() - saveLengthForList);
        saveLengthForList = encoder.getLength();
        array = this.whiteIntervalList_.toArray();
        Arrays.sort(array);
        for (i = array.length - 1; i >= 0; --i) {
            element = (RepetitiveInterval)array[i];
            Schedule.encodeRepetitiveInterval(element, encoder);
        }
        encoder.writeTypeAndLength(141, encoder.getLength() - saveLengthForList);
        encoder.writeTypeAndLength(143, encoder.getLength() - saveLength);
        return new Blob(encoder.getOutput(), false);
    }

    public final void wireDecode(ByteBuffer input) throws EncodingException {
        TlvDecoder decoder = new TlvDecoder(input);
        int endOffset = decoder.readNestedTlvsStart(143);
        this.whiteIntervalList_.clear();
        int listEndOffset = decoder.readNestedTlvsStart(141);
        while (decoder.getOffset() < listEndOffset) {
            this.whiteIntervalList_.add(Schedule.decodeRepetitiveInterval(decoder));
        }
        decoder.finishNestedTlvs(listEndOffset);
        this.blackIntervalList_.clear();
        listEndOffset = decoder.readNestedTlvsStart(142);
        while (decoder.getOffset() < listEndOffset) {
            this.blackIntervalList_.add(Schedule.decodeRepetitiveInterval(decoder));
        }
        decoder.finishNestedTlvs(listEndOffset);
        decoder.finishNestedTlvs(endOffset);
    }

    public final void wireDecode(Blob input) throws EncodingException {
        this.wireDecode(input.buf());
    }

    private static void encodeRepetitiveInterval(RepetitiveInterval repetitiveInterval, TlvEncoder encoder) {
        int saveLength = encoder.getLength();
        encoder.writeNonNegativeIntegerTlv(139, RepetitiveInterval.getRepeatUnitNumericType(repetitiveInterval.getRepeatUnit()));
        encoder.writeNonNegativeIntegerTlv(138, repetitiveInterval.getNRepeats());
        encoder.writeNonNegativeIntegerTlv(137, repetitiveInterval.getIntervalEndHour());
        encoder.writeNonNegativeIntegerTlv(136, repetitiveInterval.getIntervalStartHour());
        encoder.writeBlobTlv(135, new Blob(Schedule.toIsoString(repetitiveInterval.getEndDate())).buf());
        encoder.writeBlobTlv(134, new Blob(Schedule.toIsoString(repetitiveInterval.getStartDate())).buf());
        encoder.writeTypeAndLength(140, encoder.getLength() - saveLength);
    }

    private static RepetitiveInterval decodeRepetitiveInterval(TlvDecoder decoder) throws EncodingException {
        RepetitiveInterval.RepeatUnit repeatUnit;
        int endOffset = decoder.readNestedTlvsStart(140);
        double startDate = Schedule.fromIsoString(new Blob(decoder.readBlobTlv(134), true).toString());
        double endDate = Schedule.fromIsoString(new Blob(decoder.readBlobTlv(135), true).toString());
        int startHour = (int)decoder.readNonNegativeIntegerTlv(136);
        int endHour = (int)decoder.readNonNegativeIntegerTlv(137);
        int nRepeats = (int)decoder.readNonNegativeIntegerTlv(138);
        int repeatUnitCode = (int)decoder.readNonNegativeIntegerTlv(139);
        if (repeatUnitCode == 0) {
            repeatUnit = RepetitiveInterval.RepeatUnit.NONE;
        } else if (repeatUnitCode == 1) {
            repeatUnit = RepetitiveInterval.RepeatUnit.DAY;
        } else if (repeatUnitCode == 2) {
            repeatUnit = RepetitiveInterval.RepeatUnit.MONTH;
        } else if (repeatUnitCode == 3) {
            repeatUnit = RepetitiveInterval.RepeatUnit.YEAR;
        } else {
            throw new EncodingException("Unrecognized RepetitiveInterval RepeatUnit code: " + repeatUnitCode);
        }
        decoder.finishNestedTlvs(endOffset);
        return new RepetitiveInterval(startDate, endDate, startHour, endHour, nRepeats, repeatUnit);
    }

    private static void calculateIntervalResult(HashSet<RepetitiveInterval> list, double timeStamp, Interval positiveResult, Interval negativeResult) {
        Object[] array = list.toArray();
        Arrays.sort(array);
        for (Object elementObj : array) {
            RepetitiveInterval element = (RepetitiveInterval)elementObj;
            RepetitiveInterval.Result result = element.getInterval(timeStamp);
            Interval tempInterval = result.interval;
            if (result.isPositive) {
                try {
                    positiveResult.unionWith(tempInterval);
                    continue;
                }
                catch (Interval.Error ex) {
                    throw new Error("Error in Interval.unionWith: " + ex.getMessage());
                }
            }
            if (!negativeResult.isValid()) {
                negativeResult.set(tempInterval);
                continue;
            }
            negativeResult.intersectWith(tempInterval);
        }
    }

    public static double fromIsoString(String dateString) throws EncodingException {
        try {
            return Common.dateToMillisecondsSince1970(dateFormat.parse(dateString));
        }
        catch (ParseException ex) {
            throw new EncodingException("Cannot parse date string " + dateString);
        }
    }

    public static String toIsoString(double msSince1970) {
        return dateFormat.format(Common.millisecondsSince1970ToDate(Math.round(msSince1970)));
    }

    private static SimpleDateFormat getDateFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat;
    }

    public static class Result {
        public boolean isPositive;
        public Interval interval;

        public Result(boolean isPositive, Interval interval) {
            this.isPositive = isPositive;
            this.interval = interval;
        }
    }
}

