/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn;

import java.nio.ByteBuffer;
import java.util.Random;
import net.named_data.jndn.Data;
import net.named_data.jndn.DelegationSet;
import net.named_data.jndn.Exclude;
import net.named_data.jndn.KeyLocator;
import net.named_data.jndn.KeyLocatorType;
import net.named_data.jndn.Link;
import net.named_data.jndn.Name;
import net.named_data.jndn.Signature;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.lp.IncomingFaceId;
import net.named_data.jndn.lp.LpPacket;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.ChangeCountable;
import net.named_data.jndn.util.ChangeCounter;
import net.named_data.jndn.util.SignedBlob;

public class Interest
implements ChangeCountable {
    public static final int CHILD_SELECTOR_LEFT = 0;
    public static final int CHILD_SELECTOR_RIGHT = 1;
    private final ChangeCounter name_ = new ChangeCounter(new Name());
    private int minSuffixComponents_ = -1;
    private int maxSuffixComponents_ = -1;
    private final ChangeCounter keyLocator_ = new ChangeCounter(new KeyLocator());
    private final ChangeCounter exclude_ = new ChangeCounter(new Exclude());
    private int childSelector_ = -1;
    private boolean mustBeFresh_ = true;
    private double interestLifetimeMilliseconds_ = -1.0;
    private Blob nonce_ = new Blob();
    private long getNonceChangeCount_ = 0L;
    private LpPacket lpPacket_ = null;
    private Blob linkWireEncoding_ = new Blob();
    private WireFormat linkWireEncodingFormat_ = null;
    private final ChangeCounter forwardingHint_ = new ChangeCounter(new DelegationSet());
    private final ChangeCounter link_ = new ChangeCounter(null);
    private int selectedDelegationIndex_ = -1;
    private SignedBlob defaultWireEncoding_ = new SignedBlob();
    private WireFormat defaultWireEncodingFormat_;
    private long getDefaultWireEncodingChangeCount_ = 0L;
    private long changeCount_ = 0L;
    private static final Random random_ = new Random();

    public Interest(Name name, double interestLifetimeMilliseconds) {
        if (name != null) {
            this.name_.set(new Name(name));
        }
        this.interestLifetimeMilliseconds_ = interestLifetimeMilliseconds;
    }

    public Interest(Name name) {
        if (name != null) {
            this.name_.set(new Name(name));
        }
    }

    public Interest(Interest interest) {
        this.name_.set(new Name(interest.getName()));
        this.minSuffixComponents_ = interest.minSuffixComponents_;
        this.maxSuffixComponents_ = interest.maxSuffixComponents_;
        this.keyLocator_.set(new KeyLocator(interest.getKeyLocator()));
        this.exclude_.set(new Exclude(interest.getExclude()));
        this.childSelector_ = interest.childSelector_;
        this.mustBeFresh_ = interest.mustBeFresh_;
        this.interestLifetimeMilliseconds_ = interest.interestLifetimeMilliseconds_;
        this.nonce_ = interest.getNonce();
        this.forwardingHint_.set(new DelegationSet(interest.getForwardingHint()));
        this.linkWireEncoding_ = interest.linkWireEncoding_;
        this.linkWireEncodingFormat_ = interest.linkWireEncodingFormat_;
        if (interest.link_.get() != null) {
            this.link_.set(new Link((Link)interest.link_.get()));
        }
        this.selectedDelegationIndex_ = interest.selectedDelegationIndex_;
        this.setDefaultWireEncoding(interest.getDefaultWireEncoding(), interest.defaultWireEncodingFormat_);
    }

    public Interest() {
    }

    public final SignedBlob wireEncode(WireFormat wireFormat) {
        if (!this.getDefaultWireEncoding().isNull() && this.getDefaultWireEncodingFormat() == wireFormat) {
            return this.getDefaultWireEncoding();
        }
        int[] signedPortionBeginOffset = new int[1];
        int[] signedPortionEndOffset = new int[1];
        Blob encoding = wireFormat.encodeInterest(this, signedPortionBeginOffset, signedPortionEndOffset);
        SignedBlob wireEncoding = new SignedBlob(encoding, signedPortionBeginOffset[0], signedPortionEndOffset[0]);
        if (wireFormat == WireFormat.getDefaultWireFormat()) {
            this.setDefaultWireEncoding(wireEncoding, WireFormat.getDefaultWireFormat());
        }
        return wireEncoding;
    }

    public final SignedBlob wireEncode() {
        return this.wireEncode(WireFormat.getDefaultWireFormat());
    }

    public final void wireDecode(ByteBuffer input, WireFormat wireFormat) throws EncodingException {
        this.wireDecodeHelper(input, wireFormat, true);
    }

    private void wireDecodeHelper(ByteBuffer input, WireFormat wireFormat, boolean copy) throws EncodingException {
        int[] signedPortionBeginOffset = new int[1];
        int[] signedPortionEndOffset = new int[1];
        wireFormat.decodeInterest(this, input, signedPortionBeginOffset, signedPortionEndOffset, copy);
        if (wireFormat == WireFormat.getDefaultWireFormat()) {
            this.setDefaultWireEncoding(new SignedBlob(input, copy, signedPortionBeginOffset[0], signedPortionEndOffset[0]), WireFormat.getDefaultWireFormat());
        } else {
            this.setDefaultWireEncoding(new SignedBlob(), null);
        }
    }

    public final void wireDecode(ByteBuffer input) throws EncodingException {
        this.wireDecode(input, WireFormat.getDefaultWireFormat());
    }

    public final void wireDecode(Blob input, WireFormat wireFormat) throws EncodingException {
        this.wireDecodeHelper(input.buf(), wireFormat, false);
    }

    public final void wireDecode(Blob input) throws EncodingException {
        this.wireDecode(input, WireFormat.getDefaultWireFormat());
    }

    public final String toUri() {
        StringBuffer selectors = new StringBuffer();
        if (this.minSuffixComponents_ >= 0) {
            selectors.append("&ndn.MinSuffixComponents=").append(this.minSuffixComponents_);
        }
        if (this.maxSuffixComponents_ >= 0) {
            selectors.append("&ndn.MaxSuffixComponents=").append(this.maxSuffixComponents_);
        }
        if (this.childSelector_ >= 0) {
            selectors.append("&ndn.ChildSelector=").append(this.childSelector_);
        }
        selectors.append("&ndn.MustBeFresh=").append(this.mustBeFresh_ ? 1 : 0);
        if (this.interestLifetimeMilliseconds_ >= 0.0) {
            selectors.append("&ndn.InterestLifetime=").append(Math.round(this.interestLifetimeMilliseconds_));
        }
        if (this.nonce_.size() > 0) {
            selectors.append("&ndn.Nonce=");
            Name.toEscapedString(this.nonce_.buf(), selectors);
        }
        if (this.getExclude().size() > 0) {
            selectors.append("&ndn.Exclude=").append(this.getExclude().toUri());
        }
        StringBuffer result = new StringBuffer();
        result.append(this.getName().toUri());
        String selectorsString = selectors.toString();
        if (selectorsString.length() > 0) {
            result.append("?").append(selectorsString.substring(1));
        }
        return result.toString();
    }

    public final Name getName() {
        return (Name)this.name_.get();
    }

    public final int getMinSuffixComponents() {
        return this.minSuffixComponents_;
    }

    public final int getMaxSuffixComponents() {
        return this.maxSuffixComponents_;
    }

    public final boolean getCanBePrefix() {
        return this.maxSuffixComponents_ != 1;
    }

    public final KeyLocator getKeyLocator() {
        return (KeyLocator)this.keyLocator_.get();
    }

    public final Exclude getExclude() {
        return (Exclude)this.exclude_.get();
    }

    public final int getChildSelector() {
        return this.childSelector_;
    }

    public final boolean getMustBeFresh() {
        return this.mustBeFresh_;
    }

    public final double getInterestLifetimeMilliseconds() {
        return this.interestLifetimeMilliseconds_;
    }

    public final Blob getNonce() {
        if (this.getNonceChangeCount_ != this.getChangeCount()) {
            this.nonce_ = new Blob();
            this.getNonceChangeCount_ = this.getChangeCount();
        }
        return this.nonce_;
    }

    public final DelegationSet getForwardingHint() {
        return (DelegationSet)this.forwardingHint_.get();
    }

    public final boolean hasLink() {
        return this.link_.get() != null || !this.linkWireEncoding_.isNull();
    }

    public final Link getLink() throws EncodingException {
        if (this.link_.get() != null) {
            return (Link)this.link_.get();
        }
        if (!this.linkWireEncoding_.isNull()) {
            Link link = new Link();
            link.wireDecode(this.linkWireEncoding_, this.linkWireEncodingFormat_);
            this.link_.set(link);
            this.linkWireEncoding_ = new Blob();
            this.linkWireEncodingFormat_ = null;
            return link;
        }
        return null;
    }

    public final Blob getLinkWireEncoding(WireFormat wireFormat) throws EncodingException {
        if (!this.linkWireEncoding_.isNull() && this.linkWireEncodingFormat_ == wireFormat) {
            return this.linkWireEncoding_;
        }
        Link link = this.getLink();
        if (link != null) {
            return link.wireEncode(wireFormat);
        }
        return new Blob();
    }

    public final Blob getLinkWireEncoding() throws EncodingException {
        return this.getLinkWireEncoding(WireFormat.getDefaultWireFormat());
    }

    public final int getSelectedDelegationIndex() {
        return this.selectedDelegationIndex_;
    }

    public final long getIncomingFaceId() {
        IncomingFaceId field = this.lpPacket_ == null ? null : IncomingFaceId.getFirstHeader(this.lpPacket_);
        return field == null ? -1L : field.getFaceId();
    }

    public final Interest setName(Name name) {
        this.name_.set(name == null ? new Name() : new Name(name));
        ++this.changeCount_;
        return this;
    }

    public final Interest setMinSuffixComponents(int minSuffixComponents) {
        this.minSuffixComponents_ = minSuffixComponents;
        ++this.changeCount_;
        return this;
    }

    public final Interest setMaxSuffixComponents(int maxSuffixComponents) {
        this.maxSuffixComponents_ = maxSuffixComponents;
        ++this.changeCount_;
        return this;
    }

    public final Interest setCanBePrefix(boolean canBePrefix) {
        this.maxSuffixComponents_ = canBePrefix ? -1 : 1;
        ++this.changeCount_;
        return this;
    }

    public final Interest setChildSelector(int childSelector) {
        this.childSelector_ = childSelector;
        ++this.changeCount_;
        return this;
    }

    public final Interest setMustBeFresh(boolean mustBeFresh) {
        this.mustBeFresh_ = mustBeFresh;
        ++this.changeCount_;
        return this;
    }

    public final Interest setInterestLifetimeMilliseconds(double interestLifetimeMilliseconds) {
        this.interestLifetimeMilliseconds_ = interestLifetimeMilliseconds;
        ++this.changeCount_;
        return this;
    }

    public final Interest setNonce(Blob nonce) {
        this.nonce_ = nonce == null ? new Blob() : nonce;
        ++this.changeCount_;
        this.getNonceChangeCount_ = this.getChangeCount();
        return this;
    }

    public final Interest setKeyLocator(KeyLocator keyLocator) {
        this.keyLocator_.set(keyLocator == null ? new KeyLocator() : new KeyLocator(keyLocator));
        ++this.changeCount_;
        return this;
    }

    public final Interest setExclude(Exclude exclude) {
        this.exclude_.set(exclude == null ? new Exclude() : new Exclude(exclude));
        ++this.changeCount_;
        return this;
    }

    public final Interest setForwardingHint(DelegationSet forwardingHint) {
        this.forwardingHint_.set(forwardingHint == null ? new DelegationSet() : new DelegationSet(forwardingHint));
        ++this.changeCount_;
        return this;
    }

    public final Interest setLinkWireEncoding(Blob encoding, WireFormat wireFormat) {
        this.linkWireEncoding_ = encoding;
        this.linkWireEncodingFormat_ = wireFormat;
        this.link_.set(null);
        ++this.changeCount_;
        return this;
    }

    public final Interest setLinkWireEncoding(Blob encoding) {
        return this.setLinkWireEncoding(encoding, WireFormat.getDefaultWireFormat());
    }

    public final Interest unsetLink() {
        return this.setLinkWireEncoding(new Blob(), null);
    }

    public final Interest setSelectedDelegationIndex(int selectedDelegationIndex) {
        this.selectedDelegationIndex_ = selectedDelegationIndex;
        ++this.changeCount_;
        return this;
    }

    final Interest setLpPacket(LpPacket lpPacket) {
        this.lpPacket_ = lpPacket;
        return this;
    }

    public final void refreshNonce() {
        Blob currentNonce = this.getNonce();
        if (currentNonce.size() == 0) {
            return;
        }
        ByteBuffer newNonce = ByteBuffer.allocate(currentNonce.size());
        do {
            random_.nextBytes(newNonce.array());
        } while (newNonce.equals(currentNonce.buf()));
        this.nonce_ = new Blob(newNonce, false);
        ++this.changeCount_;
        this.getNonceChangeCount_ = this.getChangeCount();
    }

    public final boolean matchesName(Name name) {
        if (!this.getName().match(name)) {
            return false;
        }
        if (this.minSuffixComponents_ >= 0 && name.size() + 1 - this.getName().size() < this.minSuffixComponents_) {
            return false;
        }
        if (this.maxSuffixComponents_ >= 0 && name.size() + 1 - this.getName().size() > this.maxSuffixComponents_) {
            return false;
        }
        return this.getExclude().size() <= 0 || name.size() <= this.getName().size() || !this.getExclude().matches(name.get(this.getName().size()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean matchesData(Data data, WireFormat wireFormat) throws EncodingException {
        boolean hasMaxSuffixComponents;
        int minSuffixComponents;
        int interestNameLength = this.getName().size();
        Name dataName = data.getName();
        int fullNameLength = dataName.size() + 1;
        boolean hasMinSuffixComponents = this.getMinSuffixComponents() >= 0;
        int n = minSuffixComponents = hasMinSuffixComponents ? this.getMinSuffixComponents() : 0;
        if (interestNameLength + minSuffixComponents > fullNameLength) {
            return false;
        }
        boolean bl = hasMaxSuffixComponents = this.getMaxSuffixComponents() >= 0;
        if (hasMaxSuffixComponents && interestNameLength + this.getMaxSuffixComponents() < fullNameLength) {
            return false;
        }
        if (interestNameLength == fullNameLength) {
            if (!this.getName().get(-1).isImplicitSha256Digest()) return false;
            if (!this.getName().equals(data.getFullName(wireFormat))) {
                return false;
            }
        } else if (!this.getName().isPrefixOf(dataName)) {
            return false;
        }
        if (this.getExclude().size() > 0 && fullNameLength > interestNameLength && (interestNameLength == fullNameLength - 1 ? this.getExclude().matches(data.getFullName(wireFormat).get(interestNameLength)) : this.getExclude().matches(dataName.get(interestNameLength)))) {
            return false;
        }
        KeyLocator publisherPublicKeyLocator = this.getKeyLocator();
        if (publisherPublicKeyLocator.getType() == KeyLocatorType.NONE) return true;
        Signature signature = data.getSignature();
        if (!KeyLocator.canGetFromSignature(signature)) {
            return false;
        }
        if (publisherPublicKeyLocator.equals(KeyLocator.getFromSignature(signature))) return true;
        return false;
    }

    public final boolean matchesData(Data data) throws EncodingException {
        return this.matchesData(data, WireFormat.getDefaultWireFormat());
    }

    public final SignedBlob getDefaultWireEncoding() {
        if (this.getDefaultWireEncodingChangeCount_ != this.getChangeCount()) {
            this.defaultWireEncoding_ = new SignedBlob();
            this.defaultWireEncodingFormat_ = null;
            this.getDefaultWireEncodingChangeCount_ = this.getChangeCount();
        }
        return this.defaultWireEncoding_;
    }

    WireFormat getDefaultWireEncodingFormat() {
        return this.defaultWireEncodingFormat_;
    }

    @Override
    public final long getChangeCount() {
        boolean changed = this.name_.checkChanged();
        changed = this.keyLocator_.checkChanged() || changed;
        changed = this.exclude_.checkChanged() || changed;
        changed = this.forwardingHint_.checkChanged() || changed;
        boolean bl = changed = this.link_.checkChanged() || changed;
        if (changed) {
            ++this.changeCount_;
        }
        return this.changeCount_;
    }

    private void setDefaultWireEncoding(SignedBlob defaultWireEncoding, WireFormat defaultWireEncodingFormat) {
        this.defaultWireEncoding_ = defaultWireEncoding;
        this.defaultWireEncodingFormat_ = defaultWireEncodingFormat;
        this.getDefaultWireEncodingChangeCount_ = this.getChangeCount();
    }
}

