/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.transport;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import net.named_data.jndn.encoding.ElementListener;
import net.named_data.jndn.encoding.ElementReader;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.transport.Transport;

public class TcpTransport
extends Transport {
    SocketChannel channel_;
    ByteBuffer inputBuffer_ = ByteBuffer.allocate(8800);
    private ElementReader elementReader_;
    private ConnectionInfo connectionInfo_;
    private boolean isLocal_;

    @Override
    public boolean isLocal(Transport.ConnectionInfo connectionInfo) throws IOException {
        if (this.connectionInfo_ == null || !((ConnectionInfo)connectionInfo).getHost().equals(this.connectionInfo_.getHost())) {
            this.isLocal_ = TcpTransport.getIsLocal(((ConnectionInfo)connectionInfo).getHost());
            this.connectionInfo_ = (ConnectionInfo)connectionInfo;
        }
        return this.isLocal_;
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    public void connect(Transport.ConnectionInfo connectionInfo, ElementListener elementListener, Runnable onConnected) throws IOException {
        this.close();
        this.channel_ = SocketChannel.open(new InetSocketAddress(((ConnectionInfo)connectionInfo).getHost(), ((ConnectionInfo)connectionInfo).getPort()));
        this.channel_.configureBlocking(false);
        this.elementReader_ = new ElementReader(elementListener);
        if (onConnected != null) {
            onConnected.run();
        }
    }

    @Override
    public void send(ByteBuffer data) throws IOException {
        if (this.channel_ == null) {
            throw new IOException("Cannot send because the socket is not open.  Use connect.");
        }
        int savePosition = data.position();
        try {
            while (data.hasRemaining()) {
                this.channel_.write(data);
            }
        }
        finally {
            data.position(savePosition);
        }
    }

    @Override
    public void processEvents() throws IOException, EncodingException {
        if (!this.getIsConnected()) {
            return;
        }
        while (true) {
            this.inputBuffer_.limit(this.inputBuffer_.capacity());
            this.inputBuffer_.position(0);
            int bytesRead = this.channel_.read(this.inputBuffer_);
            if (bytesRead <= 0) {
                return;
            }
            this.inputBuffer_.flip();
            this.elementReader_.onReceivedData(this.inputBuffer_);
        }
    }

    @Override
    public boolean getIsConnected() throws IOException {
        if (this.channel_ == null) {
            return false;
        }
        return this.channel_.isConnected();
    }

    @Override
    public void close() throws IOException {
        if (this.channel_ != null) {
            if (this.channel_.isConnected()) {
                this.channel_.close();
            }
            this.channel_ = null;
        }
    }

    public static boolean getIsLocal(String host) throws IOException {
        InetAddress address = InetAddress.getByName(host);
        return address.isLoopbackAddress();
    }

    public static class ConnectionInfo
    extends Transport.ConnectionInfo {
        private final String host_;
        private final int port_;

        public ConnectionInfo(String host, int port) {
            this.host_ = host;
            this.port_ = port;
        }

        public ConnectionInfo(String host) {
            this.host_ = host;
            this.port_ = 6363;
        }

        public final String getHost() {
            return this.host_;
        }

        public final int getPort() {
            return this.port_;
        }
    }
}

