/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.v2;

import java.util.ArrayList;
import net.named_data.jndn.Data;
import net.named_data.jndn.Interest;
import net.named_data.jndn.Name;
import net.named_data.jndn.security.ValidatorConfigError;
import net.named_data.jndn.security.v2.CertificateV2;
import net.named_data.jndn.security.v2.InterestValidationState;
import net.named_data.jndn.security.v2.InterestValidationSuccessCallback;
import net.named_data.jndn.security.v2.ValidationError;
import net.named_data.jndn.security.v2.ValidationPolicy;
import net.named_data.jndn.security.v2.ValidationState;
import net.named_data.jndn.util.Common;

public class ValidationPolicyCommandInterest
extends ValidationPolicy {
    private final Options options_;
    private final ArrayList<LastTimestampRecord> container_ = new ArrayList();
    private double nowOffsetMilliseconds_ = 0.0;
    private static Common dummyCommon_ = new Common();

    public ValidationPolicyCommandInterest(ValidationPolicy innerPolicy, Options options) {
        this.options_ = new Options(options);
        if (innerPolicy == null) {
            throw new AssertionError((Object)"inner policy is missing");
        }
        this.setInnerPolicy(innerPolicy);
        if (this.options_.gracePeriod_ < 0.0) {
            this.options_.gracePeriod_ = 0.0;
        }
    }

    public ValidationPolicyCommandInterest(ValidationPolicy innerPolicy) {
        this.options_ = new Options();
        if (innerPolicy == null) {
            throw new AssertionError((Object)"inner policy is missing");
        }
        this.setInnerPolicy(innerPolicy);
    }

    @Override
    public void checkPolicy(Data data, ValidationState state, ValidationPolicy.ValidationContinuation continueValidation) throws CertificateV2.Error, ValidatorConfigError {
        this.getInnerPolicy().checkPolicy(data, state, continueValidation);
    }

    @Override
    public void checkPolicy(Interest interest, ValidationState state, ValidationPolicy.ValidationContinuation continueValidation) throws CertificateV2.Error, ValidatorConfigError {
        Name[] keyName = new Name[1];
        double[] timestamp = new double[1];
        if (!ValidationPolicyCommandInterest.parseCommandInterest(interest, state, keyName, timestamp)) {
            return;
        }
        if (!this.checkTimestamp(state, keyName[0], timestamp[0])) {
            return;
        }
        this.getInnerPolicy().checkPolicy(interest, state, continueValidation);
    }

    public final void setNowOffsetMilliseconds_(double nowOffsetMilliseconds) {
        this.nowOffsetMilliseconds_ = nowOffsetMilliseconds;
    }

    private void cleanUp() {
        double now = Common.getNowMilliseconds() + this.nowOffsetMilliseconds_;
        double expiring = now - this.options_.recordLifetime_;
        while (this.container_.size() > 0 && this.container_.get((int)0).lastRefreshed_ <= expiring || this.options_.maxRecords_ >= 0 && this.container_.size() > this.options_.maxRecords_) {
            this.container_.remove(0);
        }
    }

    private static boolean parseCommandInterest(Interest interest, ValidationState state, Name[] keyLocatorName, double[] timestamp) {
        keyLocatorName[0] = new Name();
        timestamp[0] = 0.0;
        Name name = interest.getName();
        if (name.size() < 4) {
            state.fail(new ValidationError(9, "Command interest name `" + interest.getName().toUri() + "` is too short"));
            return false;
        }
        timestamp[0] = name.get(-4).toNumber();
        keyLocatorName[0] = ValidationPolicyCommandInterest.getKeyLocatorName(interest, state);
        return !state.isOutcomeFailed();
    }

    private boolean checkTimestamp(ValidationState state, final Name keyName, final double timestamp) {
        this.cleanUp();
        double now = Common.getNowMilliseconds() + this.nowOffsetMilliseconds_;
        if (timestamp < now - this.options_.gracePeriod_ || timestamp > now + this.options_.gracePeriod_) {
            state.fail(new ValidationError(9, "Timestamp is outside the grace period for key " + keyName.toUri()));
            return false;
        }
        int index = this.findByKeyName(keyName);
        if (index >= 0 && timestamp <= this.container_.get((int)index).timestamp_) {
            state.fail(new ValidationError(9, "Timestamp is reordered for key " + keyName.toUri()));
            return false;
        }
        InterestValidationState interestState = (InterestValidationState)state;
        interestState.addSuccessCallback(new InterestValidationSuccessCallback(){

            @Override
            public void successCallback(Interest interest) {
                ValidationPolicyCommandInterest.this.insertNewRecord(interest, keyName, timestamp);
            }
        });
        return true;
    }

    private void insertNewRecord(Interest interest, Name keyName, double timestamp) {
        double now = Common.getNowMilliseconds() + this.nowOffsetMilliseconds_;
        LastTimestampRecord newRecord = new LastTimestampRecord(keyName, timestamp, now);
        int index = this.findByKeyName(keyName);
        if (index >= 0) {
            this.container_.remove(index);
        }
        this.container_.add(newRecord);
    }

    int findByKeyName(Name keyName) {
        for (int i = 0; i < this.container_.size(); ++i) {
            if (!this.container_.get((int)i).keyName_.equals(keyName)) continue;
            return i;
        }
        return -1;
    }

    private static class LastTimestampRecord {
        public Name keyName_;
        public double timestamp_;
        public double lastRefreshed_;

        public LastTimestampRecord(Name keyName, double timestamp, double lastRefreshed) {
            this.keyName_ = new Name(keyName);
            this.timestamp_ = timestamp;
            this.lastRefreshed_ = lastRefreshed;
        }
    }

    public static class Options {
        public double gracePeriod_;
        public int maxRecords_;
        public double recordLifetime_;

        public Options(double gracePeriod, int maxRecords, double recordLifetime) {
            this.gracePeriod_ = gracePeriod;
            this.maxRecords_ = maxRecords;
            this.recordLifetime_ = recordLifetime;
        }

        public Options(double gracePeriod, int maxRecords) {
            this.gracePeriod_ = gracePeriod;
            this.maxRecords_ = maxRecords;
            this.recordLifetime_ = 3600000.0;
        }

        public Options(double gracePeriod) {
            this.gracePeriod_ = gracePeriod;
            this.maxRecords_ = 1000;
            this.recordLifetime_ = 3600000.0;
        }

        public Options() {
            this.gracePeriod_ = 120000.0;
            this.maxRecords_ = 1000;
            this.recordLifetime_ = 3600000.0;
        }

        public Options(Options options) {
            this.gracePeriod_ = options.gracePeriod_;
            this.maxRecords_ = options.maxRecords_;
            this.recordLifetime_ = options.recordLifetime_;
        }
    }
}

