/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.v2;

public class ValidationError {
    public static final int NO_ERROR = 0;
    public static final int INVALID_SIGNATURE = 1;
    public static final int NO_SIGNATURE = 2;
    public static final int CANNOT_RETRIEVE_CERTIFICATE = 3;
    public static final int EXPIRED_CERTIFICATE = 4;
    public static final int LOOP_DETECTED = 5;
    public static final int MALFORMED_CERTIFICATE = 6;
    public static final int EXCEEDED_DEPTH_LIMIT = 7;
    public static final int INVALID_KEY_LOCATOR = 8;
    public static final int POLICY_ERROR = 9;
    public static final int IMPLEMENTATION_ERROR = 255;
    public static final int USER_MIN = 256;
    private int code_;
    private String info_;

    public ValidationError(int code, String info) {
        this.code_ = code;
        this.info_ = info;
    }

    public ValidationError(int code) {
        this.code_ = code;
        this.info_ = "";
    }

    public final int getCode() {
        return this.code_;
    }

    public final String getInfo() {
        return this.info_;
    }

    public String toString() {
        String result = this.code_ == 0 ? "No error" : (this.code_ == 1 ? "Invalid signature" : (this.code_ == 2 ? "Missing signature" : (this.code_ == 3 ? "Cannot retrieve certificate" : (this.code_ == 4 ? "Certificate expired" : (this.code_ == 5 ? "Loop detected in certification chain" : (this.code_ == 6 ? "Malformed certificate" : (this.code_ == 7 ? "Exceeded validation depth limit" : (this.code_ == 8 ? "Key locator violates validation policy" : (this.code_ == 9 ? "Validation policy error" : (this.code_ == 255 ? "Internal implementation error" : (this.code_ >= 256 ? "Custom error code " + this.code_ : "Unrecognized error code " + this.code_)))))))))));
        if (this.info_.length() > 0) {
            result = result + " (" + this.info_ + ")";
        }
        return result;
    }
}

