/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.v2;

import java.io.File;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.Name;
import net.named_data.jndn.security.v2.CertificateContainerInterface;
import net.named_data.jndn.security.v2.CertificateV2;
import net.named_data.jndn.security.v2.TrustAnchorGroup;
import net.named_data.jndn.util.Common;

public class DynamicTrustAnchorGroup
extends TrustAnchorGroup {
    private final boolean isDirectory_;
    private final String path_;
    private final double refreshPeriod_;
    private double expireTime_;
    private static final Logger logger_ = Logger.getLogger(DynamicTrustAnchorGroup.class.getName());
    private static Common dummyCommon_ = new Common();

    public DynamicTrustAnchorGroup(CertificateContainerInterface certificateContainer, String id, String path, double refreshPeriod, boolean isDirectory) {
        super(certificateContainer, id);
        this.isDirectory_ = isDirectory;
        this.path_ = path;
        this.refreshPeriod_ = refreshPeriod;
        this.expireTime_ = 0.0;
        if (refreshPeriod <= 0.0) {
            throw new IllegalArgumentException("Refresh period for the dynamic group must be positive");
        }
        logger_.log(Level.INFO, "Create a dynamic trust anchor group " + id + " for file/dir " + path + " with refresh time " + refreshPeriod);
        this.refresh();
    }

    @Override
    public void refresh() {
        double now = Common.getNowMilliseconds();
        if (this.expireTime_ > now) {
            return;
        }
        this.expireTime_ = now + this.refreshPeriod_;
        logger_.log(Level.INFO, "Reloading the dynamic trust anchor group");
        HashSet<Name> oldAnchorNames = new HashSet<Name>(this.anchorNames_);
        if (!this.isDirectory_) {
            this.loadCertificate(this.path_, oldAnchorNames);
        } else {
            File[] allFiles = new File(this.path_).listFiles();
            if (allFiles != null) {
                for (int i = 0; i < allFiles.length; ++i) {
                    this.loadCertificate(allFiles[i].getAbsolutePath(), oldAnchorNames);
                }
            }
        }
        for (Name name : oldAnchorNames) {
            this.anchorNames_.remove(name);
            this.certificates_.remove(name);
        }
    }

    private void loadCertificate(String file, HashSet<Name> oldAnchorNames) {
        CertificateV2 certificate = DynamicTrustAnchorGroup.readCertificate(file);
        if (certificate != null) {
            if (!this.anchorNames_.contains(certificate.getName())) {
                this.anchorNames_.add(certificate.getName());
                this.certificates_.add(certificate);
            } else {
                oldAnchorNames.remove(certificate.getName());
            }
        }
    }
}

