/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.encrypt.algo;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import net.named_data.jndn.encrypt.DecryptKey;
import net.named_data.jndn.encrypt.EncryptKey;
import net.named_data.jndn.encrypt.algo.EncryptParams;
import net.named_data.jndn.security.RsaKeyParams;
import net.named_data.jndn.security.SecurityException;
import net.named_data.jndn.security.UnrecognizedKeyFormatException;
import net.named_data.jndn.security.certificate.PublicKey;
import net.named_data.jndn.security.tpm.TpmPrivateKey;
import net.named_data.jndn.util.Blob;

public class RsaAlgorithm {
    public static DecryptKey generateKey(RsaKeyParams params) throws SecurityException {
        TpmPrivateKey privateKey;
        try {
            privateKey = TpmPrivateKey.generatePrivateKey(params);
        }
        catch (IllegalArgumentException ex) {
            throw new SecurityException("generateKey: Error in generatePrivateKey: " + ex);
        }
        catch (TpmPrivateKey.Error ex) {
            throw new SecurityException("generateKey: Error in generatePrivateKey: " + ex);
        }
        try {
            return new DecryptKey(privateKey.toPkcs8());
        }
        catch (TpmPrivateKey.Error ex) {
            throw new SecurityException("generateKey: Error in toPkcs8: " + ex);
        }
    }

    public static EncryptKey deriveEncryptKey(Blob keyBits) throws SecurityException {
        TpmPrivateKey privateKey = new TpmPrivateKey();
        try {
            privateKey.loadPkcs8(keyBits.buf());
        }
        catch (TpmPrivateKey.Error ex) {
            throw new SecurityException("deriveEncryptKey: Error in loadPkcs8: " + ex);
        }
        try {
            return new EncryptKey(privateKey.derivePublicKey());
        }
        catch (TpmPrivateKey.Error ex) {
            throw new SecurityException("deriveEncryptKey: Error in derivePublicKey: " + ex);
        }
    }

    public static Blob decrypt(Blob keyBits, Blob encryptedData, EncryptParams params) throws SecurityException {
        TpmPrivateKey privateKey = new TpmPrivateKey();
        try {
            privateKey.loadPkcs8(keyBits.buf());
        }
        catch (TpmPrivateKey.Error ex) {
            throw new SecurityException("decrypt: Error in loadPkcs8: " + ex);
        }
        try {
            return privateKey.decrypt(encryptedData.buf(), params.getAlgorithmType());
        }
        catch (TpmPrivateKey.Error ex) {
            throw new SecurityException("decrypt: Error in decrypt: " + ex);
        }
    }

    public static Blob encrypt(Blob keyBits, Blob plainData, EncryptParams params) throws InvalidKeySpecException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        try {
            return new PublicKey(keyBits).encrypt(plainData, params.getAlgorithmType());
        }
        catch (UnrecognizedKeyFormatException ex) {
            throw new InvalidKeyException(ex.getMessage());
        }
    }
}

