/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.encoding.tlv;

import java.nio.ByteBuffer;
import net.named_data.jndn.util.DynamicByteBuffer;

public class TlvEncoder {
    private final DynamicByteBuffer output_;

    public TlvEncoder(int initialCapacity) {
        this.output_ = new DynamicByteBuffer(initialCapacity);
        this.output_.position(this.output_.limit());
    }

    public TlvEncoder() {
        this.output_ = new DynamicByteBuffer(16);
        this.output_.position(this.output_.limit());
    }

    public final int getLength() {
        return this.output_.remaining();
    }

    public final void writeVarNumber(int varNumber) {
        if (varNumber < 253) {
            int position = this.output_.setRemainingFromBack(this.output_.remaining() + 1);
            this.output_.buffer().put(position, (byte)(varNumber & 0xFF));
        } else if (varNumber <= 65535) {
            int position = this.output_.setRemainingFromBack(this.output_.remaining() + 3);
            this.output_.buffer().put(position, (byte)-3);
            this.output_.buffer().put(position + 1, (byte)(varNumber >> 8 & 0xFF));
            this.output_.buffer().put(position + 2, (byte)(varNumber & 0xFF));
        } else {
            int position = this.output_.setRemainingFromBack(this.output_.remaining() + 5);
            this.output_.buffer().put(position, (byte)-2);
            this.output_.buffer().put(position + 1, (byte)(varNumber >> 24 & 0xFF));
            this.output_.buffer().put(position + 2, (byte)(varNumber >> 16 & 0xFF));
            this.output_.buffer().put(position + 3, (byte)(varNumber >> 8 & 0xFF));
            this.output_.buffer().put(position + 4, (byte)(varNumber & 0xFF));
        }
    }

    public final void writeTypeAndLength(int type, int length) {
        this.writeVarNumber(length);
        this.writeVarNumber(type);
    }

    public final void writeNonNegativeInteger(long value) {
        if (value < 0L) {
            throw new Error("TLV integer value may not be negative");
        }
        if (value <= 255L) {
            int position = this.output_.setRemainingFromBack(this.output_.remaining() + 1);
            this.output_.buffer().put(position, (byte)(value & 0xFFL));
        } else if (value <= 65535L) {
            int position = this.output_.setRemainingFromBack(this.output_.remaining() + 2);
            this.output_.buffer().put(position, (byte)(value >> 8 & 0xFFL));
            this.output_.buffer().put(position + 1, (byte)(value & 0xFFL));
        } else if (value <= 0xFFFFFFFFL) {
            int position = this.output_.setRemainingFromBack(this.output_.remaining() + 4);
            this.output_.buffer().put(position, (byte)(value >> 24 & 0xFFL));
            this.output_.buffer().put(position + 1, (byte)(value >> 16 & 0xFFL));
            this.output_.buffer().put(position + 2, (byte)(value >> 8 & 0xFFL));
            this.output_.buffer().put(position + 3, (byte)(value & 0xFFL));
        } else {
            int position = this.output_.setRemainingFromBack(this.output_.remaining() + 8);
            this.output_.buffer().put(position, (byte)(value >> 56 & 0xFFL));
            this.output_.buffer().put(position + 1, (byte)(value >> 48 & 0xFFL));
            this.output_.buffer().put(position + 2, (byte)(value >> 40 & 0xFFL));
            this.output_.buffer().put(position + 3, (byte)(value >> 32 & 0xFFL));
            this.output_.buffer().put(position + 4, (byte)(value >> 24 & 0xFFL));
            this.output_.buffer().put(position + 5, (byte)(value >> 16 & 0xFFL));
            this.output_.buffer().put(position + 6, (byte)(value >> 8 & 0xFFL));
            this.output_.buffer().put(position + 7, (byte)(value & 0xFFL));
        }
    }

    public final void writeNonNegativeIntegerTlv(int type, long value) {
        int saveNBytes = this.output_.remaining();
        this.writeNonNegativeInteger(value);
        this.writeTypeAndLength(type, this.output_.remaining() - saveNBytes);
    }

    public final void writeOptionalNonNegativeIntegerTlv(int type, long value) {
        if (value >= 0L) {
            this.writeNonNegativeIntegerTlv(type, value);
        }
    }

    public final void writeOptionalNonNegativeIntegerTlvFromDouble(int type, double value) {
        if (value >= 0.0) {
            this.writeNonNegativeIntegerTlv(type, Math.round(value));
        }
    }

    public final void writeBuffer(ByteBuffer buffer) {
        if (buffer == null) {
            return;
        }
        int position = this.output_.setRemainingFromBack(this.output_.remaining() + buffer.remaining());
        int saveBufferValuePosition = buffer.position();
        this.output_.buffer().put(buffer);
        this.output_.position(position);
        buffer.position(saveBufferValuePosition);
    }

    public final void writeBlobTlv(int type, ByteBuffer value) {
        if (value == null) {
            this.writeTypeAndLength(type, 0);
            return;
        }
        this.writeBuffer(value);
        this.writeTypeAndLength(type, value.remaining());
    }

    public final void writeOptionalBlobTlv(int type, ByteBuffer value) {
        if (value != null && value.remaining() > 0) {
            this.writeBlobTlv(type, value);
        }
    }

    public final ByteBuffer getOutput() {
        return this.output_.buffer().slice();
    }
}

