/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import net.named_data.jndn.ComponentType;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.encoding.tlv.TlvEncoder;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.ChangeCountable;

public class Name
implements ChangeCountable,
Comparable {
    private final ArrayList<Component> components_;
    private long changeCount_ = 0L;
    private boolean haveHashCode_ = false;
    private int hashCode_;
    private long hashCodeChangeCount_ = 0L;

    public Name() {
        this.components_ = new ArrayList();
    }

    public Name(Name name) {
        this.components_ = new ArrayList<Component>(name.components_);
    }

    public Name(ArrayList components) {
        this.components_ = new ArrayList(components);
    }

    public Name(Component[] components) {
        this.components_ = new ArrayList();
        for (int i = 0; i < components.length; ++i) {
            this.components_.add(components[i]);
        }
    }

    public Name(String uri) {
        this.components_ = new ArrayList();
        this.set(uri);
    }

    public final int size() {
        return this.components_.size();
    }

    public final Component get(int i) {
        if (i >= 0) {
            return this.components_.get(i);
        }
        return this.components_.get(this.components_.size() - -i);
    }

    public final void set(String uri) {
        int iFirstSlash;
        this.clear();
        uri = uri.trim();
        if (uri.length() == 0) {
            return;
        }
        int iColon = uri.indexOf(58);
        if (iColon >= 0 && ((iFirstSlash = uri.indexOf(47)) < 0 || iColon < iFirstSlash)) {
            uri = uri.substring(iColon + 1).trim();
        }
        if (uri.charAt(0) == '/') {
            if (uri.length() >= 2 && uri.charAt(1) == '/') {
                int iAfterAuthority = uri.indexOf(47, 2);
                if (iAfterAuthority < 0) {
                    return;
                }
                uri = uri.substring(iAfterAuthority + 1).trim();
            } else {
                uri = uri.substring(1).trim();
            }
        }
        int iComponentStart = 0;
        String sha256digestPrefix = "sha256digest=";
        while (iComponentStart < uri.length()) {
            Component component;
            int iComponentEnd = uri.indexOf("/", iComponentStart);
            if (iComponentEnd < 0) {
                iComponentEnd = uri.length();
            }
            if (sha256digestPrefix.regionMatches(0, uri, iComponentStart, sha256digestPrefix.length())) {
                try {
                    component = Component.fromImplicitSha256Digest(Name.fromHex(uri, iComponentStart + sha256digestPrefix.length(), iComponentEnd));
                }
                catch (EncodingException ex) {
                    throw new Error(ex.getMessage());
                }
            }
            ComponentType type = ComponentType.GENERIC;
            int otherTypeCode = -1;
            int iTypeCodeEnd = uri.indexOf("=", iComponentStart);
            if (iTypeCodeEnd >= 0 && iTypeCodeEnd < iComponentEnd) {
                String typeString = uri.substring(iComponentStart, iTypeCodeEnd);
                try {
                    otherTypeCode = Integer.parseInt(typeString);
                }
                catch (NumberFormatException ex) {
                    throw new Error("Can't parse decimal Name Component type: " + typeString + " in URI " + uri);
                }
                if (otherTypeCode == ComponentType.GENERIC.getNumericType() || otherTypeCode == ComponentType.IMPLICIT_SHA256_DIGEST.getNumericType()) {
                    throw new Error("Unexpected Name Component type: " + typeString + " in URI " + uri);
                }
                type = ComponentType.OTHER_CODE;
                iComponentStart = iTypeCodeEnd + 1;
            }
            component = new Component(Name.fromEscapedString(uri, iComponentStart, iComponentEnd), type, otherTypeCode);
            if (!component.getValue().isNull()) {
                this.append(component);
            }
            iComponentStart = iComponentEnd + 1;
        }
    }

    public final void clear() {
        this.components_.clear();
        ++this.changeCount_;
    }

    public final Name append(byte[] value) {
        return this.append(new Component(value));
    }

    public final Name append(byte[] value, ComponentType type) {
        if (type == ComponentType.OTHER_CODE) {
            throw new AssertionError((Object)"To use an other code, call append(value, ComponentType.OTHER_CODE, otherTypeCode)");
        }
        return this.append(new Component(value, type));
    }

    public final Name append(byte[] value, ComponentType type, int otherTypeCode) {
        return this.append(new Component(value, type, otherTypeCode));
    }

    public final Name append(Blob value) {
        return this.append(new Component(value));
    }

    public final Name append(Blob value, ComponentType type) {
        if (type == ComponentType.OTHER_CODE) {
            throw new AssertionError((Object)"To use an other code, call append(value, ComponentType.OTHER_CODE, otherTypeCode)");
        }
        return this.append(new Component(value, type));
    }

    public final Name append(Blob value, ComponentType type, int otherTypeCode) {
        return this.append(new Component(value, type, otherTypeCode));
    }

    public final Name append(Component component) {
        this.components_.add(component);
        ++this.changeCount_;
        return this;
    }

    public final Name append(Name name) {
        if (name == this) {
            return this.append(new Name(name));
        }
        for (int i = 0; i < name.components_.size(); ++i) {
            this.append(name.get(i));
        }
        return this;
    }

    public final Name append(String value) {
        return this.append(new Component(value));
    }

    public final Name append(String value, ComponentType type) {
        if (type == ComponentType.OTHER_CODE) {
            throw new AssertionError((Object)"To use an other code, call append(value, ComponentType.OTHER_CODE, otherTypeCode)");
        }
        return this.append(new Component(value, type));
    }

    public final Name append(String value, ComponentType type, int otherTypeCode) {
        return this.append(new Component(value, type, otherTypeCode));
    }

    public final Name getSubName(int iStartComponent, int nComponents) {
        if (iStartComponent < 0) {
            iStartComponent = this.components_.size() - -iStartComponent;
        }
        Name result = new Name();
        int iEnd = iStartComponent + nComponents;
        for (int i = iStartComponent; i < iEnd && i < this.components_.size(); ++i) {
            result.components_.add(this.components_.get(i));
        }
        return result;
    }

    public final Name getSubName(int iStartComponent) {
        return this.getSubName(iStartComponent, this.components_.size());
    }

    public final Name getPrefix(int nComponents) {
        if (nComponents < 0) {
            return this.getSubName(0, this.components_.size() + nComponents);
        }
        return this.getSubName(0, nComponents);
    }

    public final String toUri(boolean includeScheme) {
        if (this.components_.isEmpty()) {
            return includeScheme ? "ndn:/" : "/";
        }
        StringBuffer result = new StringBuffer();
        if (includeScheme) {
            result.append("ndn:");
        }
        for (int i = 0; i < this.components_.size(); ++i) {
            result.append("/");
            this.get(i).toEscapedString(result);
        }
        return result.toString();
    }

    public final String toUri() {
        return this.toUri(false);
    }

    public String toString() {
        return this.toUri();
    }

    public final Name appendSegment(long segment) {
        return this.append(Component.fromSegment(segment));
    }

    public final Name appendSegmentOffset(long segmentOffset) {
        return this.append(Component.fromSegmentOffset(segmentOffset));
    }

    public final Name appendVersion(long version) {
        return this.append(Component.fromVersion(version));
    }

    public final Name appendTimestamp(long timestamp) {
        return this.append(Component.fromTimestamp(timestamp));
    }

    public final Name appendSequenceNumber(long sequenceNumber) {
        return this.append(Component.fromSequenceNumber(sequenceNumber));
    }

    public final Name appendImplicitSha256Digest(Blob digest) throws EncodingException {
        return this.append(Component.fromImplicitSha256Digest(digest));
    }

    public final Name appendImplicitSha256Digest(byte[] digest) throws EncodingException {
        return this.append(Component.fromImplicitSha256Digest(digest));
    }

    public boolean equals(Name name) {
        if (this.components_.size() != name.components_.size()) {
            return false;
        }
        for (int i = this.components_.size() - 1; i >= 0; --i) {
            if (this.get(i).getValue().equals(name.get(i).getValue())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Name)) {
            return false;
        }
        return this.equals((Name)other);
    }

    public int hashCode() {
        if (this.hashCodeChangeCount_ != this.getChangeCount()) {
            this.haveHashCode_ = false;
            this.hashCodeChangeCount_ = this.getChangeCount();
        }
        if (!this.haveHashCode_) {
            int hashCode = 0;
            for (int i = 0; i < this.components_.size(); ++i) {
                hashCode = 37 * hashCode + this.components_.get(i).hashCode();
            }
            this.hashCode_ = hashCode;
            this.haveHashCode_ = true;
        }
        return this.hashCode_;
    }

    public final Name getSuccessor() {
        if (this.size() == 0) {
            Name result = new Name();
            result.append(new byte[1]);
            return result;
        }
        return this.getPrefix(-1).append(this.get(-1).getSuccessor());
    }

    public final boolean match(Name name) {
        if (this.components_.size() > name.components_.size()) {
            return false;
        }
        for (int i = this.components_.size() - 1; i >= 0; --i) {
            if (this.get(i).getValue().equals(name.get(i).getValue())) continue;
            return false;
        }
        return true;
    }

    public final boolean isPrefixOf(Name name) {
        return this.match(name);
    }

    public final Blob wireEncode(WireFormat wireFormat) {
        return wireFormat.encodeName(this);
    }

    public final Blob wireEncode() {
        return this.wireEncode(WireFormat.getDefaultWireFormat());
    }

    public final void wireDecode(ByteBuffer input, WireFormat wireFormat) throws EncodingException {
        wireFormat.decodeName(this, input, true);
    }

    public final void wireDecode(ByteBuffer input) throws EncodingException {
        this.wireDecode(input, WireFormat.getDefaultWireFormat());
    }

    public final void wireDecode(Blob input, WireFormat wireFormat) throws EncodingException {
        wireFormat.decodeName(this, input.buf(), false);
    }

    public final void wireDecode(Blob input) throws EncodingException {
        this.wireDecode(input, WireFormat.getDefaultWireFormat());
    }

    public final int compare(Name other) {
        return this.compare(0, this.components_.size(), other);
    }

    public final int compare(int iStartComponent, int nComponents, Name other, int iOtherStartComponent, int nOtherComponents) {
        if (iStartComponent < 0) {
            iStartComponent = this.size() - -iStartComponent;
        }
        if (iOtherStartComponent < 0) {
            iOtherStartComponent = other.size() - -iOtherStartComponent;
        }
        nComponents = Math.min(nComponents, this.size() - iStartComponent);
        nOtherComponents = Math.min(nOtherComponents, other.size() - iOtherStartComponent);
        int count = Math.min(nComponents, nOtherComponents);
        for (int i = 0; i < count; ++i) {
            int comparison = this.components_.get(iStartComponent + i).compare(other.components_.get(iOtherStartComponent + i));
            if (comparison == 0) continue;
            return comparison;
        }
        if (nComponents < nOtherComponents) {
            return -1;
        }
        if (nComponents > nOtherComponents) {
            return 1;
        }
        return 0;
    }

    public final int compare(int iStartComponent, int nComponents, Name other, int iOtherStartComponent) {
        return this.compare(iStartComponent, nComponents, other, iOtherStartComponent, other.components_.size());
    }

    public final int compare(int iStartComponent, int nComponents, Name other) {
        return this.compare(iStartComponent, nComponents, other, 0, other.components_.size());
    }

    public final int compareTo(Object o) {
        return this.compare((Name)o);
    }

    public final int CompareTo(Object o) {
        return this.compare((Name)o);
    }

    @Override
    public final long getChangeCount() {
        return this.changeCount_;
    }

    public static Blob fromEscapedString(String escapedString, int beginOffset, int endOffset) {
        String trimmedString = escapedString.substring(beginOffset, endOffset).trim();
        ByteBuffer value = Name.unescape(trimmedString);
        boolean gotNonDot = false;
        for (int i = value.position(); i < value.limit(); ++i) {
            if (value.get(i) == 46) continue;
            gotNonDot = true;
            break;
        }
        if (!gotNonDot) {
            if (value.remaining() <= 2) {
                return new Blob();
            }
            value.position(value.position() + 3);
            return new Blob(value, false);
        }
        return new Blob(value, false);
    }

    public static Blob fromEscapedString(String escapedString) {
        return Name.fromEscapedString(escapedString, 0, escapedString.length());
    }

    public static void toEscapedString(ByteBuffer value, StringBuffer result) {
        int i;
        boolean gotNonDot = false;
        for (i = value.position(); i < value.limit(); ++i) {
            if (value.get(i) == 46) continue;
            gotNonDot = true;
            break;
        }
        if (!gotNonDot) {
            result.append("...");
            for (i = value.position(); i < value.limit(); ++i) {
                result.append('.');
            }
        } else {
            for (i = value.position(); i < value.limit(); ++i) {
                int x = value.get(i) & 0xFF;
                if (x >= 48 && x <= 57 || x >= 65 && x <= 90 || x >= 97 && x <= 122 || x == 43 || x == 45 || x == 46 || x == 95) {
                    result.append((char)x);
                    continue;
                }
                result.append('%');
                if (x < 16) {
                    result.append('0');
                }
                result.append(Integer.toHexString(x).toUpperCase());
            }
        }
    }

    public static String toEscapedString(ByteBuffer value) {
        StringBuffer result = new StringBuffer(value.remaining());
        Name.toEscapedString(value, result);
        return result.toString();
    }

    public static Blob fromHex(String hexString, int beginOffset, int endOffset) {
        ByteBuffer result = ByteBuffer.allocate((endOffset - beginOffset) / 2);
        for (int i = beginOffset; i < endOffset; ++i) {
            if (hexString.charAt(i) == ' ') continue;
            if (i + 1 >= endOffset) break;
            int hi = Name.fromHexChar(hexString.charAt(i));
            int lo = Name.fromHexChar(hexString.charAt(i + 1));
            if (hi < 0 || lo < 0) {
                return new Blob();
            }
            result.put((byte)(16 * hi + lo));
            ++i;
        }
        result.flip();
        return new Blob(result, false);
    }

    private static int fromHexChar(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        return -1;
    }

    private static ByteBuffer unescape(String str) {
        ByteBuffer result = ByteBuffer.allocate(str.length());
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '%' && i + 2 < str.length()) {
                int hi = Name.fromHexChar(str.charAt(i + 1));
                int lo = Name.fromHexChar(str.charAt(i + 2));
                if (hi < 0 || lo < 0) {
                    result.put((byte)str.charAt(i)).put((byte)str.charAt(i + 1)).put((byte)str.charAt(i + 2));
                } else {
                    result.put((byte)(16 * hi + lo));
                }
                i += 2;
                continue;
            }
            result.put((byte)str.charAt(i));
        }
        result.flip();
        return result;
    }

    public static class Component
    implements Comparable {
        private ComponentType type_;
        private int otherTypeCode_ = -1;
        private final Blob value_;

        public Component() {
            this.value_ = new Blob(ByteBuffer.allocate(0), false);
            this.type_ = ComponentType.GENERIC;
        }

        public Component(Blob value) {
            if (value == null) {
                throw new NullPointerException("Component: Blob value may not be null");
            }
            this.value_ = value;
            this.type_ = ComponentType.GENERIC;
        }

        public Component(Blob value, ComponentType type) {
            if (value == null) {
                throw new NullPointerException("Component: Blob value may not be null");
            }
            if (type == ComponentType.OTHER_CODE) {
                throw new AssertionError((Object)"To use an other code, call Name.Component(value, ComponentType.OTHER_CODE, otherTypeCode)");
            }
            this.value_ = value;
            this.type_ = type;
        }

        public Component(Blob value, ComponentType type, int otherTypeCode) {
            if (value == null) {
                throw new NullPointerException("Component: Blob value may not be null");
            }
            if (type == ComponentType.OTHER_CODE && otherTypeCode < 0) {
                throw new AssertionError((Object)"Name.Component other type code must be non-negative");
            }
            this.value_ = value;
            this.type_ = type;
            this.otherTypeCode_ = type == ComponentType.OTHER_CODE ? otherTypeCode : -1;
        }

        public Component(Component component) {
            this.value_ = component.value_;
            this.type_ = component.type_;
            this.otherTypeCode_ = component.otherTypeCode_;
        }

        public Component(byte[] value) {
            this.value_ = new Blob(value, true);
            this.type_ = ComponentType.GENERIC;
        }

        public Component(byte[] value, ComponentType type) {
            if (type == ComponentType.OTHER_CODE) {
                throw new AssertionError((Object)"To use an other code, call Name.Component(value, ComponentType.OTHER_CODE, otherTypeCode)");
            }
            this.value_ = new Blob(value, true);
            this.type_ = type;
        }

        public Component(byte[] value, ComponentType type, int otherTypeCode) {
            if (type == ComponentType.OTHER_CODE && otherTypeCode < 0) {
                throw new AssertionError((Object)"Name.Component other type code must be non-negative");
            }
            this.value_ = new Blob(value, true);
            this.type_ = type;
            this.otherTypeCode_ = type == ComponentType.OTHER_CODE ? otherTypeCode : -1;
        }

        public Component(String value) {
            this.value_ = new Blob(value);
            this.type_ = ComponentType.GENERIC;
        }

        public Component(String value, ComponentType type) {
            if (type == ComponentType.OTHER_CODE) {
                throw new AssertionError((Object)"To use an other code, call Name.Component(value, ComponentType.OTHER_CODE, otherTypeCode)");
            }
            this.value_ = new Blob(value);
            this.type_ = type;
        }

        public Component(String value, ComponentType type, int otherTypeCode) {
            if (type == ComponentType.OTHER_CODE && otherTypeCode < 0) {
                throw new AssertionError((Object)"Name.Component other type code must be non-negative");
            }
            this.value_ = new Blob(value);
            this.type_ = type;
            this.otherTypeCode_ = type == ComponentType.OTHER_CODE ? otherTypeCode : -1;
        }

        public final Blob getValue() {
            return this.value_;
        }

        public final ComponentType getType() {
            return this.type_;
        }

        public final int getOtherTypeCode() {
            return this.otherTypeCode_;
        }

        public final void toEscapedString(StringBuffer result) {
            if (this.type_ == ComponentType.IMPLICIT_SHA256_DIGEST) {
                result.append("sha256digest=");
                Blob.toHex(this.value_.buf(), result);
                return;
            }
            if (this.type_ != ComponentType.GENERIC) {
                result.append(this.type_ == ComponentType.OTHER_CODE ? this.otherTypeCode_ : this.type_.getNumericType());
                result.append('=');
            }
            Name.toEscapedString(this.value_.buf(), result);
        }

        public final String toEscapedString() {
            StringBuffer result = new StringBuffer(this.value_.buf().remaining());
            this.toEscapedString(result);
            return result.toString();
        }

        public final boolean isSegment() {
            return this.value_.size() >= 1 && this.value_.buf().get(0) == 0 && this.isGeneric();
        }

        public final boolean isSegmentOffset() {
            return this.value_.size() >= 1 && this.value_.buf().get(0) == -5 && this.isGeneric();
        }

        public final boolean isVersion() {
            return this.value_.size() >= 1 && this.value_.buf().get(0) == -3 && this.isGeneric();
        }

        public final boolean isTimestamp() {
            return this.value_.size() >= 1 && this.value_.buf().get(0) == -4 && this.isGeneric();
        }

        public final boolean isSequenceNumber() {
            return this.value_.size() >= 1 && this.value_.buf().get(0) == -2 && this.isGeneric();
        }

        public final boolean isGeneric() {
            return this.type_ == ComponentType.GENERIC;
        }

        public final boolean isImplicitSha256Digest() {
            return this.type_ == ComponentType.IMPLICIT_SHA256_DIGEST;
        }

        public final long toNumber() {
            ByteBuffer buffer = this.value_.buf();
            if (buffer == null) {
                return 0L;
            }
            long result = 0L;
            for (int i = buffer.position(); i < buffer.limit(); ++i) {
                result *= 256L;
                result += (long)(buffer.get(i) & 0xFF);
            }
            return result;
        }

        public final long toNumberWithMarker(int marker) throws EncodingException {
            ByteBuffer buffer = this.value_.buf();
            if (buffer == null || buffer.remaining() <= 0 || buffer.get(0) != (byte)marker) {
                throw new EncodingException("Name component does not begin with the expected marker.");
            }
            long result = 0L;
            for (int i = buffer.position() + 1; i < buffer.limit(); ++i) {
                result *= 256L;
                result += (long)(buffer.get(i) & 0xFF);
            }
            return result;
        }

        public final long toSegment() throws EncodingException {
            return this.toNumberWithMarker(0);
        }

        public final long toSegmentOffset() throws EncodingException {
            return this.toNumberWithMarker(251);
        }

        public final long toVersion() throws EncodingException {
            return this.toNumberWithMarker(253);
        }

        public final long toTimestamp() throws EncodingException {
            return this.toNumberWithMarker(252);
        }

        public final long toSequenceNumber() throws EncodingException {
            return this.toNumberWithMarker(254);
        }

        public static Component fromNumber(long number) {
            return Component.fromNumber(number, ComponentType.GENERIC, -1);
        }

        public static Component fromNumber(long number, ComponentType type) {
            if (type == ComponentType.OTHER_CODE) {
                throw new AssertionError((Object)"To use an other code, call fromNumber(value, ComponentType.OTHER_CODE, otherTypeCode)");
            }
            return Component.fromNumber(number, type, -1);
        }

        public static Component fromNumber(long number, ComponentType type, int otherTypeCode) {
            if (number < 0L) {
                number = 0L;
            }
            if (type == ComponentType.OTHER_CODE && otherTypeCode < 0) {
                throw new AssertionError((Object)"Name.Component other type code must be non-negative");
            }
            TlvEncoder encoder = new TlvEncoder(8);
            encoder.writeNonNegativeInteger(number);
            return new Component(new Blob(encoder.getOutput(), false), type, otherTypeCode);
        }

        public static Component fromNumberWithMarker(long number, int marker) {
            if (number < 0L) {
                number = 0L;
            }
            TlvEncoder encoder = new TlvEncoder(9);
            encoder.writeNonNegativeInteger(number);
            encoder.writeNonNegativeInteger(marker);
            return new Component(new Blob(encoder.getOutput(), false));
        }

        public static Component fromSegment(long segment) {
            return Component.fromNumberWithMarker(segment, 0);
        }

        public static Component fromSegmentOffset(long segmentOffset) {
            return Component.fromNumberWithMarker(segmentOffset, 251);
        }

        public static Component fromVersion(long version) {
            return Component.fromNumberWithMarker(version, 253);
        }

        public static Component fromTimestamp(long timestamp) {
            return Component.fromNumberWithMarker(timestamp, 252);
        }

        public static Component fromSequenceNumber(long sequenceNumber) {
            return Component.fromNumberWithMarker(sequenceNumber, 254);
        }

        public static Component fromImplicitSha256Digest(Blob digest) throws EncodingException {
            if (digest.size() != 32) {
                throw new EncodingException("Name.Component.fromImplicitSha256Digest: The digest length must be 32 bytes");
            }
            Component result = new Component(digest);
            result.type_ = ComponentType.IMPLICIT_SHA256_DIGEST;
            return result;
        }

        public static Component fromImplicitSha256Digest(byte[] digest) throws EncodingException {
            return Component.fromImplicitSha256Digest(new Blob(digest));
        }

        public final Component getSuccessor() {
            ByteBuffer result = ByteBuffer.allocate(this.value_.size() + 1);
            boolean carry = true;
            for (int i = this.value_.size() - 1; i >= 0; --i) {
                if (carry) {
                    int x = this.value_.buf().get(this.value_.buf().position() + i) & 0xFF;
                    x = x + 1 & 0xFF;
                    result.put(i, (byte)x);
                    carry = x == 0;
                    continue;
                }
                result.put(i, this.value_.buf().get(this.value_.buf().position() + i));
            }
            if (carry) {
                result.put(result.limit() - 1, (byte)0);
            } else {
                result.limit(this.value_.size());
            }
            return new Component(new Blob(result, false), this.type_, this.otherTypeCode_);
        }

        public final boolean equals(Component other) {
            if (this.type_ == ComponentType.OTHER_CODE) {
                return this.value_.equals(other.value_) && other.type_ == ComponentType.OTHER_CODE && this.otherTypeCode_ == other.otherTypeCode_;
            }
            return this.value_.equals(other.value_) && this.type_ == other.type_;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Component)) {
                return false;
            }
            return this.equals((Component)other);
        }

        public int hashCode() {
            return 37 * (this.type_ == ComponentType.OTHER_CODE ? this.otherTypeCode_ : this.type_.getNumericType()) + this.value_.hashCode();
        }

        public final int compare(Component other) {
            int otherTypeCode;
            int myTypeCode = this.type_ == ComponentType.OTHER_CODE ? this.otherTypeCode_ : this.type_.getNumericType();
            int n = otherTypeCode = other.type_ == ComponentType.OTHER_CODE ? other.otherTypeCode_ : other.type_.getNumericType();
            if (myTypeCode < otherTypeCode) {
                return -1;
            }
            if (myTypeCode > otherTypeCode) {
                return 1;
            }
            if (this.value_.size() < other.value_.size()) {
                return -1;
            }
            if (this.value_.size() > other.value_.size()) {
                return 1;
            }
            return this.value_.compare(other.value_);
        }

        public final int compareTo(Object o) {
            return this.compare((Component)o);
        }

        public final int CompareTo(Object o) {
            return this.compare((Component)o);
        }

        private static void reverse(ByteBuffer buffer, int position, int limit) {
            int from = position;
            for (int to = limit - 1; from < to; --to, ++from) {
                byte temp = buffer.get(from);
                buffer.put(from, buffer.get(to));
                buffer.put(to, temp);
            }
        }
    }
}

