/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.sync;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.Data;
import net.named_data.jndn.Face;
import net.named_data.jndn.Interest;
import net.named_data.jndn.InterestFilter;
import net.named_data.jndn.Name;
import net.named_data.jndn.OnData;
import net.named_data.jndn.OnInterestCallback;
import net.named_data.jndn.OnRegisterFailed;
import net.named_data.jndn.OnTimeout;
import net.named_data.jndn.security.KeyChain;
import net.named_data.jndn.security.SecurityException;
import net.named_data.jndn.sync.DigestTree;
import net.named_data.jndn.sync.SyncStateProto;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.MemoryContentCache;

public class ChronoSync2013
implements OnInterestCallback,
OnData,
OnTimeout {
    Face face_;
    KeyChain keyChain_;
    Name certificateName_;
    double syncLifetime_;
    OnReceivedSyncState onReceivedSyncState_;
    OnInitialized onInitialized_;
    ArrayList digestLog_ = new ArrayList();
    DigestTree digestTree_ = new DigestTree();
    String applicationDataPrefixUri_;
    Name applicationBroadcastPrefix_;
    long sessionNo_;
    long sequenceNo_ = -1L;
    MemoryContentCache contentCache_;
    boolean enabled_ = true;
    private static final Logger logger_ = Logger.getLogger(ChronoSync2013.class.getName());

    public ChronoSync2013(OnReceivedSyncState onReceivedSyncState, OnInitialized onInitialized, Name applicationDataPrefix, Name applicationBroadcastPrefix, long sessionNo, Face face, KeyChain keyChain, Name certificateName, double syncLifetime, OnRegisterFailed onRegisterFailed) throws IOException, SecurityException {
        this.onReceivedSyncState_ = onReceivedSyncState;
        this.onInitialized_ = onInitialized;
        this.applicationDataPrefixUri_ = applicationDataPrefix.toUri();
        this.applicationBroadcastPrefix_ = new Name(applicationBroadcastPrefix);
        this.sessionNo_ = sessionNo;
        this.face_ = face;
        this.keyChain_ = keyChain;
        this.certificateName_ = new Name(certificateName);
        this.syncLifetime_ = syncLifetime;
        this.contentCache_ = new MemoryContentCache(face);
        SyncStateProto.SyncStateMsg emptyContent = SyncStateProto.SyncStateMsg.newBuilder().build();
        this.digestLog_.add(new DigestLogEntry("00", emptyContent.getSsList()));
        this.contentCache_.registerPrefix(this.applicationBroadcastPrefix_, onRegisterFailed, this);
        Interest interest = new Interest(this.applicationBroadcastPrefix_);
        interest.getName().append("00");
        interest.setInterestLifetimeMilliseconds(1000.0);
        face.expressInterest(interest, (OnData)this, (OnTimeout)new InitialTimeout());
        logger_.log(Level.FINE, "initial sync expressed");
        logger_.log(Level.FINE, interest.getName().toUri());
    }

    public final List<PrefixAndSessionNo> getProducerPrefixes() {
        ArrayList<PrefixAndSessionNo> prefixes = new ArrayList<PrefixAndSessionNo>();
        for (int i = 0; i < this.digestTree_.size(); ++i) {
            DigestTree.Node node = this.digestTree_.get(i);
            prefixes.add(new PrefixAndSessionNo(node.getDataPrefix(), node.getSessionNo()));
        }
        return prefixes;
    }

    public final long getProducerSequenceNo(String dataPrefix, long sessionNo) {
        int index = this.digestTree_.find(dataPrefix, sessionNo);
        if (index < 0) {
            return -1L;
        }
        return this.digestTree_.get(index).getSequenceNo();
    }

    public final void publishNextSequenceNo(Blob applicationInfo) throws IOException, SecurityException {
        ++this.sequenceNo_;
        SyncStateProto.SyncStateMsg.Builder builder = SyncStateProto.SyncStateMsg.newBuilder();
        builder.addSsBuilder().setName(this.applicationDataPrefixUri_).setType(SyncStateProto.SyncState.ActionType.UPDATE).getSeqnoBuilder().setSeq(this.sequenceNo_).setSession(this.sessionNo_);
        if (!applicationInfo.isNull() && applicationInfo.size() > 0) {
            builder.getSsBuilder(0).setApplicationInfo(ByteString.copyFrom((ByteBuffer)applicationInfo.buf()));
        }
        SyncStateProto.SyncStateMsg syncMessage = builder.build();
        this.broadcastSyncState(this.digestTree_.getRoot(), syncMessage);
        if (!this.update(syncMessage.getSsList())) {
            throw new Error("ChronoSync: update did not create a new digest log entry");
        }
        Interest interest = new Interest(this.applicationBroadcastPrefix_);
        interest.getName().append(this.digestTree_.getRoot());
        interest.setInterestLifetimeMilliseconds(this.syncLifetime_);
        this.face_.expressInterest(interest, (OnData)this, (OnTimeout)this);
    }

    public final void publishNextSequenceNo() throws IOException, SecurityException {
        this.publishNextSequenceNo(new Blob());
    }

    public final long getSequenceNo() {
        return this.sequenceNo_;
    }

    public final void shutdown() {
        this.enabled_ = false;
        this.contentCache_.unregisterAll();
    }

    private void broadcastSyncState(String digest, SyncStateProto.SyncStateMsg syncMessage) throws SecurityException {
        Data data = new Data(this.applicationBroadcastPrefix_);
        data.getName().append(digest);
        data.setContent(new Blob(syncMessage.toByteArray(), false));
        this.keyChain_.sign(data, this.certificateName_);
        this.contentCache_.add(data);
    }

    private boolean update(List content) {
        for (int i = 0; i < content.size(); ++i) {
            SyncStateProto.SyncState syncState = (SyncStateProto.SyncState)content.get(i);
            if (!syncState.getType().equals((Object)SyncStateProto.SyncState.ActionType.UPDATE) || !this.digestTree_.update(syncState.getName(), syncState.getSeqno().getSession(), syncState.getSeqno().getSeq()) || !this.applicationDataPrefixUri_.equals(syncState.getName())) continue;
            this.sequenceNo_ = syncState.getSeqno().getSeq();
        }
        if (this.logFind(this.digestTree_.getRoot()) == -1) {
            this.digestLog_.add(new DigestLogEntry(this.digestTree_.getRoot(), content));
            return true;
        }
        return false;
    }

    private int logFind(String digest) {
        for (int i = 0; i < this.digestLog_.size(); ++i) {
            if (!digest.equals(((DigestLogEntry)this.digestLog_.get(i)).getDigest())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final void onInterest(Name prefix, Interest interest, Face face, long interestFilterId, InterestFilter filter) {
        if (!this.enabled_) {
            return;
        }
        logger_.log(Level.FINE, "Sync Interest received in callback.");
        logger_.log(Level.FINE, interest.getName().toUri());
        String syncDigest = interest.getName().get(this.applicationBroadcastPrefix_.size()).toEscapedString();
        if (interest.getName().size() == this.applicationBroadcastPrefix_.size() + 2) {
            syncDigest = interest.getName().get(this.applicationBroadcastPrefix_.size() + 1).toEscapedString();
        }
        logger_.log(Level.FINE, "syncDigest: {0}", syncDigest);
        if (interest.getName().size() == this.applicationBroadcastPrefix_.size() + 2 || syncDigest.equals("00")) {
            this.processRecoveryInterest(interest, syncDigest, face);
        } else {
            this.contentCache_.storePendingInterest(interest, face);
            if (!syncDigest.equals(this.digestTree_.getRoot())) {
                int index = this.logFind(syncDigest);
                if (index == -1) {
                    Interest timeout = new Interest(new Name("/local/timeout"));
                    timeout.setInterestLifetimeMilliseconds(2000.0);
                    try {
                        this.face_.expressInterest(timeout, DummyOnData.onData_, (OnTimeout)new JudgeRecovery(syncDigest, face));
                    }
                    catch (IOException ex) {
                        logger_.log(Level.SEVERE, null, ex);
                        return;
                    }
                    logger_.log(Level.FINE, "set timer recover");
                } else {
                    try {
                        this.processSyncInterest(index, syncDigest, face);
                    }
                    catch (SecurityException ex) {
                        logger_.log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
    }

    @Override
    public final void onData(Interest interest, Data data) {
        boolean isRecovery;
        SyncStateProto.SyncStateMsg tempContent;
        if (!this.enabled_) {
            return;
        }
        logger_.log(Level.FINE, "Sync ContentObject received in callback");
        logger_.log(Level.FINE, "name: {0}", data.getName().toUri());
        try {
            tempContent = SyncStateProto.SyncStateMsg.parseFrom(data.getContent().getImmutableArray());
        }
        catch (InvalidProtocolBufferException ex) {
            logger_.log(Level.SEVERE, null, ex);
            return;
        }
        List<SyncStateProto.SyncState> content = tempContent.getSsList();
        if (this.digestTree_.getRoot().equals("00")) {
            isRecovery = true;
            try {
                this.initialOndata(content);
            }
            catch (SecurityException ex) {
                logger_.log(Level.SEVERE, null, ex);
                return;
            }
        } else {
            this.update(content);
            isRecovery = interest.getName().size() == this.applicationBroadcastPrefix_.size() + 2;
        }
        ArrayList<SyncState> syncStates = new ArrayList<SyncState>();
        for (int i = 0; i < content.size(); ++i) {
            SyncStateProto.SyncState syncState = content.get(i);
            if (!syncState.getType().equals((Object)SyncStateProto.SyncState.ActionType.UPDATE)) continue;
            Blob applicationInfo = syncState.hasApplicationInfo() && syncState.getApplicationInfo().size() > 0 ? new Blob(syncState.getApplicationInfo().asReadOnlyByteBuffer(), true) : new Blob();
            syncStates.add(new SyncState(syncState.getName(), syncState.getSeqno().getSession(), syncState.getSeqno().getSeq(), applicationInfo));
        }
        try {
            this.onReceivedSyncState_.onReceivedSyncState(syncStates, isRecovery);
        }
        catch (Throwable ex) {
            logger_.log(Level.SEVERE, "Error in onReceivedSyncState", ex);
        }
        Name name = new Name(this.applicationBroadcastPrefix_);
        name.append(this.digestTree_.getRoot());
        Interest syncInterest = new Interest(name);
        syncInterest.setInterestLifetimeMilliseconds(this.syncLifetime_);
        try {
            this.face_.expressInterest(syncInterest, (OnData)this, (OnTimeout)this);
        }
        catch (IOException ex) {
            logger_.log(Level.SEVERE, null, ex);
            return;
        }
        logger_.log(Level.FINE, "Syncinterest expressed:");
        logger_.log(Level.FINE, name.toUri());
    }

    private void processRecoveryInterest(Interest interest, String syncDigest, Face face) {
        logger_.log(Level.FINE, "processRecoveryInterest");
        if (this.logFind(syncDigest) != -1) {
            SyncStateProto.SyncStateMsg.Builder builder = SyncStateProto.SyncStateMsg.newBuilder();
            for (int i = 0; i < this.digestTree_.size(); ++i) {
                builder.addSsBuilder().setName(this.digestTree_.get(i).getDataPrefix()).setType(SyncStateProto.SyncState.ActionType.UPDATE).getSeqnoBuilder().setSeq(this.digestTree_.get(i).getSequenceNo()).setSession(this.digestTree_.get(i).getSessionNo());
            }
            SyncStateProto.SyncStateMsg tempContent = builder.build();
            if (tempContent.getSsCount() != 0) {
                byte[] array = tempContent.toByteArray();
                Data data = new Data(interest.getName());
                data.setContent(new Blob(array, false));
                if (interest.getName().get(-1).toEscapedString().equals("00")) {
                    data.getMetaInfo().setFreshnessPeriod(1000.0);
                }
                try {
                    this.keyChain_.sign(data, this.certificateName_);
                }
                catch (SecurityException ex) {
                    logger_.log(Level.SEVERE, null, ex);
                    return;
                }
                try {
                    face.putData(data);
                }
                catch (IOException ex) {
                    logger_.log(Level.SEVERE, ex.getMessage());
                    return;
                }
                logger_.log(Level.FINE, "send recovery data back");
                logger_.log(Level.FINE, interest.getName().toUri());
            }
        }
    }

    private boolean processSyncInterest(int index, String syncDigest, Face face) throws SecurityException {
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<Long> sequenceNoList = new ArrayList<Long>();
        ArrayList<Long> sessionNoList = new ArrayList<Long>();
        for (int j = index + 1; j < this.digestLog_.size(); ++j) {
            List temp = ((DigestLogEntry)this.digestLog_.get(j)).getData();
            for (int i = 0; i < temp.size(); ++i) {
                SyncStateProto.SyncState syncState = (SyncStateProto.SyncState)temp.get(i);
                if (!syncState.getType().equals((Object)SyncStateProto.SyncState.ActionType.UPDATE) || this.digestTree_.find(syncState.getName(), syncState.getSeqno().getSession()) == -1) continue;
                int n = -1;
                for (int k = 0; k < nameList.size(); ++k) {
                    if (!((String)nameList.get(k)).equals(syncState.getName())) continue;
                    n = k;
                    break;
                }
                if (n == -1) {
                    nameList.add(syncState.getName());
                    sequenceNoList.add(syncState.getSeqno().getSeq());
                    sessionNoList.add(syncState.getSeqno().getSession());
                    continue;
                }
                sequenceNoList.set(n, syncState.getSeqno().getSeq());
                sessionNoList.set(n, syncState.getSeqno().getSession());
            }
        }
        SyncStateProto.SyncStateMsg.Builder builder = SyncStateProto.SyncStateMsg.newBuilder();
        for (int i = 0; i < nameList.size(); ++i) {
            builder.addSsBuilder().setName((String)nameList.get(i)).setType(SyncStateProto.SyncState.ActionType.UPDATE).getSeqnoBuilder().setSeq((Long)sequenceNoList.get(i)).setSession((Long)sessionNoList.get(i));
        }
        SyncStateProto.SyncStateMsg tempContent = builder.build();
        boolean sent = false;
        if (tempContent.getSsCount() != 0) {
            Name name = new Name(this.applicationBroadcastPrefix_);
            name.append(syncDigest);
            byte[] array = tempContent.toByteArray();
            Data data = new Data(name);
            data.setContent(new Blob(array, false));
            this.keyChain_.sign(data, this.certificateName_);
            try {
                face.putData(data);
            }
            catch (IOException ex) {
                logger_.log(Level.SEVERE, ex.getMessage());
                return false;
            }
            sent = true;
            logger_.log(Level.FINE, "Sync Data send");
            logger_.log(Level.FINE, name.toUri());
        }
        return sent;
    }

    private void sendRecovery(String syncDigest) throws IOException {
        logger_.log(Level.FINE, "unknown digest: ");
        Name name = new Name(this.applicationBroadcastPrefix_);
        name.append("recovery").append(syncDigest);
        Interest interest = new Interest(name);
        interest.setInterestLifetimeMilliseconds(this.syncLifetime_);
        this.face_.expressInterest(interest, (OnData)this, (OnTimeout)this);
        logger_.log(Level.FINE, "Recovery Syncinterest expressed:");
        logger_.log(Level.FINE, name.toUri());
    }

    @Override
    public void onTimeout(Interest interest) {
        if (!this.enabled_) {
            return;
        }
        logger_.log(Level.FINE, "Sync Interest time out.");
        logger_.log(Level.FINE, "Sync Interest name: {0}", interest.getName().toUri());
        String component = interest.getName().get(4).toEscapedString();
        if (component.equals(this.digestTree_.getRoot())) {
            Name name = new Name(interest.getName());
            Interest retryInterest = new Interest(interest.getName());
            retryInterest.setInterestLifetimeMilliseconds(this.syncLifetime_);
            try {
                this.face_.expressInterest(retryInterest, (OnData)this, (OnTimeout)this);
            }
            catch (IOException ex) {
                logger_.log(Level.SEVERE, null, ex);
                return;
            }
            logger_.log(Level.FINE, "Syncinterest expressed:");
            logger_.log(Level.FINE, name.toUri());
        }
    }

    private void initialOndata(List content) throws SecurityException {
        SyncStateProto.SyncStateMsg tempContent2;
        SyncStateProto.SyncStateMsg.Builder builder;
        this.update(content);
        String digest = this.digestTree_.getRoot();
        for (int i = 0; i < content.size(); ++i) {
            SyncStateProto.SyncState syncState = (SyncStateProto.SyncState)content.get(i);
            if (!syncState.getName().equals(this.applicationDataPrefixUri_) || syncState.getSeqno().getSession() != this.sessionNo_) continue;
            SyncStateProto.SyncStateMsg.Builder builder2 = SyncStateProto.SyncStateMsg.newBuilder();
            builder2.addSsBuilder().setName(this.applicationDataPrefixUri_).setType(SyncStateProto.SyncState.ActionType.UPDATE).getSeqnoBuilder().setSeq(syncState.getSeqno().getSeq() + 1L).setSession(this.sessionNo_);
            SyncStateProto.SyncStateMsg tempContent = builder2.build();
            if (!this.update(tempContent.getSsList())) continue;
            try {
                this.onInitialized_.onInitialized();
                continue;
            }
            catch (Throwable ex) {
                logger_.log(Level.SEVERE, null, ex);
            }
        }
        if (this.sequenceNo_ >= 0L) {
            builder = SyncStateProto.SyncStateMsg.newBuilder();
            builder.addSsBuilder().setName(this.applicationDataPrefixUri_).setType(SyncStateProto.SyncState.ActionType.UPDATE).getSeqnoBuilder().setSeq(this.sequenceNo_).setSession(this.sessionNo_);
            tempContent2 = builder.build();
        } else {
            builder = SyncStateProto.SyncStateMsg.newBuilder();
            builder.addSsBuilder().setName(this.applicationDataPrefixUri_).setType(SyncStateProto.SyncState.ActionType.UPDATE).getSeqnoBuilder().setSeq(0L).setSession(this.sessionNo_);
            tempContent2 = builder.build();
        }
        this.broadcastSyncState(digest, tempContent2);
        if (this.digestTree_.find(this.applicationDataPrefixUri_, this.sessionNo_) == -1) {
            logger_.log(Level.FINE, "initial state");
            ++this.sequenceNo_;
            builder = SyncStateProto.SyncStateMsg.newBuilder();
            builder.addSsBuilder().setName(this.applicationDataPrefixUri_).setType(SyncStateProto.SyncState.ActionType.UPDATE).getSeqnoBuilder().setSeq(this.sequenceNo_).setSession(this.sessionNo_);
            SyncStateProto.SyncStateMsg tempContent = builder.build();
            if (this.update(tempContent.getSsList())) {
                try {
                    this.onInitialized_.onInitialized();
                }
                catch (Throwable ex) {
                    logger_.log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private static class DummyOnData
    implements OnData {
        public static final OnData onData_ = new DummyOnData();

        private DummyOnData() {
        }

        @Override
        public final void onData(Interest interest, Data data) {
        }
    }

    private class JudgeRecovery
    implements OnTimeout {
        private final String syncDigest_;
        private final Face face_;

        public JudgeRecovery(String syncDigest, Face face) {
            this.syncDigest_ = syncDigest;
            this.face_ = face;
        }

        @Override
        public final void onTimeout(Interest interest) {
            if (!ChronoSync2013.this.enabled_) {
                return;
            }
            int index2 = ChronoSync2013.this.logFind(this.syncDigest_);
            if (index2 != -1) {
                if (!this.syncDigest_.equals(ChronoSync2013.this.digestTree_.getRoot())) {
                    try {
                        ChronoSync2013.this.processSyncInterest(index2, this.syncDigest_, this.face_);
                    }
                    catch (SecurityException ex) {
                        logger_.log(Level.SEVERE, null, ex);
                        return;
                    }
                }
            } else {
                try {
                    ChronoSync2013.this.sendRecovery(this.syncDigest_);
                }
                catch (IOException ex) {
                    logger_.log(Level.SEVERE, null, ex);
                    return;
                }
            }
        }
    }

    private class InitialTimeout
    implements OnTimeout {
        private InitialTimeout() {
        }

        @Override
        public final void onTimeout(Interest interest) {
            if (!ChronoSync2013.this.enabled_) {
                return;
            }
            logger_.log(Level.FINE, "initial sync timeout");
            logger_.log(Level.FINE, "no other people");
            ++ChronoSync2013.this.sequenceNo_;
            if (ChronoSync2013.this.sequenceNo_ != 0L) {
                throw new Error("ChronoSync: sequenceNo_ is not the expected value of 0 for first use.");
            }
            SyncStateProto.SyncStateMsg.Builder builder = SyncStateProto.SyncStateMsg.newBuilder();
            builder.addSsBuilder().setName(ChronoSync2013.this.applicationDataPrefixUri_).setType(SyncStateProto.SyncState.ActionType.UPDATE).getSeqnoBuilder().setSeq(ChronoSync2013.this.sequenceNo_).setSession(ChronoSync2013.this.sessionNo_);
            SyncStateProto.SyncStateMsg tempContent = builder.build();
            ChronoSync2013.this.update(tempContent.getSsList());
            try {
                ChronoSync2013.this.onInitialized_.onInitialized();
            }
            catch (Throwable ex) {
                logger_.log(Level.SEVERE, null, ex);
            }
            Name name = new Name(ChronoSync2013.this.applicationBroadcastPrefix_);
            name.append(ChronoSync2013.this.digestTree_.getRoot());
            Interest retryInterest = new Interest(name);
            retryInterest.setInterestLifetimeMilliseconds(ChronoSync2013.this.syncLifetime_);
            try {
                ChronoSync2013.this.face_.expressInterest(retryInterest, (OnData)ChronoSync2013.this, (OnTimeout)ChronoSync2013.this);
            }
            catch (IOException ex) {
                logger_.log(Level.SEVERE, null, ex);
                return;
            }
            logger_.log(Level.FINE, "Syncinterest expressed:");
            logger_.log(Level.FINE, name.toUri());
        }
    }

    private static class DigestLogEntry {
        private final String digest_;
        List data_;

        public DigestLogEntry(String digest, List data) {
            this.digest_ = digest;
            this.data_ = new ArrayList(data);
        }

        public final String getDigest() {
            return this.digest_;
        }

        List getData() {
            return this.data_;
        }
    }

    public static class PrefixAndSessionNo {
        private final String dataPrefixUri_;
        private final long sessionNo_;

        public PrefixAndSessionNo(String dataPrefixUri, long sessionNo) {
            this.dataPrefixUri_ = dataPrefixUri;
            this.sessionNo_ = sessionNo;
        }

        public final String getDataPrefix() {
            return this.dataPrefixUri_;
        }

        public final long getSessionNo() {
            return this.sessionNo_;
        }
    }

    public static class SyncState {
        private final String dataPrefixUri_;
        private final long sessionNo_;
        private final long sequenceNo_;
        private final Blob applicationInfo_;

        public SyncState(String dataPrefixUri, long sessionNo, long sequenceNo, Blob applicationInfo) {
            this.dataPrefixUri_ = dataPrefixUri;
            this.sessionNo_ = sessionNo;
            this.sequenceNo_ = sequenceNo;
            this.applicationInfo_ = applicationInfo;
        }

        public final String getDataPrefix() {
            return this.dataPrefixUri_;
        }

        public final long getSessionNo() {
            return this.sessionNo_;
        }

        public final long getSequenceNo() {
            return this.sequenceNo_;
        }

        public final Blob getApplicationInfo() {
            return this.applicationInfo_;
        }
    }

    public static interface OnInitialized {
        public void onInitialized();
    }

    public static interface OnReceivedSyncState {
        public void onReceivedSyncState(List var1, boolean var2);
    }
}

