/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.v2;

import net.named_data.jndn.Interest;
import net.named_data.jndn.Name;
import net.named_data.jndn.security.v2.CertificateCacheV2;
import net.named_data.jndn.security.v2.CertificateV2;
import net.named_data.jndn.security.v2.TrustAnchorContainer;

public class CertificateStorage {
    protected TrustAnchorContainer trustAnchors_ = new TrustAnchorContainer();
    protected CertificateCacheV2 verifiedCertificateCache_ = new CertificateCacheV2(3600000.0);
    protected CertificateCacheV2 unverifiedCertificateCache_ = new CertificateCacheV2(300000.0);

    public final CertificateV2 findTrustedCertificate(Interest interestForCertificate) {
        CertificateV2 certificate = this.trustAnchors_.find(interestForCertificate);
        if (certificate != null) {
            return certificate;
        }
        certificate = this.verifiedCertificateCache_.find(interestForCertificate);
        return certificate;
    }

    public final boolean isCertificateKnown(Name certificatePrefix) {
        return this.trustAnchors_.find(certificatePrefix) != null || this.verifiedCertificateCache_.find(certificatePrefix) != null || this.unverifiedCertificateCache_.find(certificatePrefix) != null;
    }

    public final void cacheUnverifiedCertificate(CertificateV2 certificate) throws CertificateV2.Error {
        this.unverifiedCertificateCache_.insert(certificate);
    }

    public final TrustAnchorContainer getTrustAnchors() {
        return this.trustAnchors_;
    }

    public final CertificateCacheV2 getVerifiedCertificateCache() {
        return this.verifiedCertificateCache_;
    }

    public final CertificateCacheV2 getUnverifiedCertificateCache() {
        return this.unverifiedCertificateCache_;
    }

    public final void loadAnchor(String groupId, CertificateV2 certificate) throws TrustAnchorContainer.Error {
        this.trustAnchors_.insert(groupId, certificate);
    }

    public final void loadAnchor(String groupId, String path, double refreshPeriod, boolean isDirectory) throws TrustAnchorContainer.Error {
        this.trustAnchors_.insert(groupId, path, refreshPeriod, isDirectory);
    }

    public final void loadAnchor(String groupId, String path, double refreshPeriod) throws TrustAnchorContainer.Error {
        this.loadAnchor(groupId, path, refreshPeriod, false);
    }

    public final void resetAnchors() {
        this.trustAnchors_.clear();
    }

    public final void cacheVerifiedCertificate(CertificateV2 certificate) throws CertificateV2.Error {
        this.verifiedCertificateCache_.insert(certificate);
    }

    public final void resetVerifiedCertificates() {
        this.verifiedCertificateCache_.clear();
    }

    public final void setCacheNowOffsetMilliseconds_(double nowOffsetMilliseconds) {
        this.verifiedCertificateCache_.setNowOffsetMilliseconds_(nowOffsetMilliseconds);
        this.unverifiedCertificateCache_.setNowOffsetMilliseconds_(nowOffsetMilliseconds);
    }
}

