/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.tpm;

import java.nio.ByteBuffer;
import java.util.HashMap;
import net.named_data.jndn.Name;
import net.named_data.jndn.security.DigestAlgorithm;
import net.named_data.jndn.security.KeyParams;
import net.named_data.jndn.security.KeyType;
import net.named_data.jndn.security.tpm.TpmBackEnd;
import net.named_data.jndn.security.tpm.TpmKeyHandle;
import net.named_data.jndn.util.Blob;

public class Tpm {
    private final String scheme_;
    private final String location_;
    HashMap<Name, TpmKeyHandle> keys_ = new HashMap();
    private final TpmBackEnd backEnd_;

    public String getTpmLocator() {
        return this.scheme_ + ":" + this.location_;
    }

    public final boolean hasKey(Name keyName) throws TpmBackEnd.Error {
        return this.backEnd_.hasKey(keyName);
    }

    public final Blob getPublicKey(Name keyName) throws TpmBackEnd.Error {
        TpmKeyHandle key = this.findKey(keyName);
        if (key == null) {
            return new Blob();
        }
        return key.derivePublicKey();
    }

    public final Blob sign(ByteBuffer data, Name keyName, DigestAlgorithm digestAlgorithm) throws TpmBackEnd.Error {
        TpmKeyHandle key = this.findKey(keyName);
        if (key == null) {
            return new Blob();
        }
        return key.sign(digestAlgorithm, data);
    }

    public final Blob decrypt(ByteBuffer cipherText, Name keyName) throws TpmBackEnd.Error {
        TpmKeyHandle key = this.findKey(keyName);
        if (key == null) {
            return new Blob();
        }
        return key.decrypt(cipherText);
    }

    public final boolean isTerminalMode() throws TpmBackEnd.Error {
        return this.backEnd_.isTerminalMode();
    }

    public final void setTerminalMode(boolean isTerminal) throws TpmBackEnd.Error {
        this.backEnd_.setTerminalMode(isTerminal);
    }

    public final boolean isTpmLocked() throws TpmBackEnd.Error {
        return this.backEnd_.isTpmLocked();
    }

    public final boolean unlockTpm(ByteBuffer password) throws TpmBackEnd.Error {
        return this.backEnd_.unlockTpm(password);
    }

    public Tpm(String scheme, String location, TpmBackEnd backEnd) {
        this.scheme_ = scheme;
        this.location_ = location;
        this.backEnd_ = backEnd;
    }

    public final TpmBackEnd getBackEnd_() {
        return this.backEnd_;
    }

    public final Name createKey_(Name identityName, KeyParams params) throws Error, TpmBackEnd.Error {
        if (params.getKeyType() == KeyType.RSA || params.getKeyType() == KeyType.ECDSA) {
            TpmKeyHandle keyHandle = this.backEnd_.createKey(identityName, params);
            Name keyName = keyHandle.getKeyName();
            this.keys_.put(keyName, keyHandle);
            return keyName;
        }
        throw new Error("createKey: Unsupported key type");
    }

    public final void deleteKey_(Name keyName) throws TpmBackEnd.Error {
        this.keys_.remove(keyName);
        this.backEnd_.deleteKey(keyName);
    }

    public final Blob exportPrivateKey_(Name keyName, ByteBuffer password) throws TpmBackEnd.Error {
        return this.backEnd_.exportKey(keyName, password);
    }

    public final boolean importPrivateKey_(Name keyName, ByteBuffer pkcs8, ByteBuffer password) {
        try {
            this.backEnd_.importKey(keyName, pkcs8, password);
        }
        catch (TpmBackEnd.Error ex) {
            return false;
        }
        return true;
    }

    private TpmKeyHandle findKey(Name keyName) throws TpmBackEnd.Error {
        TpmKeyHandle handle = this.keys_.get(keyName);
        if (handle != null) {
            return handle;
        }
        handle = this.backEnd_.getKeyHandle(keyName);
        if (handle != null) {
            this.keys_.put(new Name(keyName), handle);
            return handle;
        }
        return null;
    }

    public static class Error
    extends Exception {
        public Error(String message) {
            super(message);
        }
    }
}

