/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security;

import java.nio.ByteBuffer;
import net.named_data.jndn.ContentType;
import net.named_data.jndn.Data;
import net.named_data.jndn.KeyLocator;
import net.named_data.jndn.KeyLocatorType;
import net.named_data.jndn.Name;
import net.named_data.jndn.Sha256WithEcdsaSignature;
import net.named_data.jndn.Sha256WithRsaSignature;
import net.named_data.jndn.Signature;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.security.DigestAlgorithm;
import net.named_data.jndn.security.KeyType;
import net.named_data.jndn.security.UnrecognizedKeyFormatException;
import net.named_data.jndn.security.ValidityPeriod;
import net.named_data.jndn.security.certificate.PublicKey;
import net.named_data.jndn.security.pib.Pib;
import net.named_data.jndn.security.tpm.Tpm;
import net.named_data.jndn.security.tpm.TpmBackEnd;
import net.named_data.jndn.security.tpm.TpmBackEndMemory;
import net.named_data.jndn.security.v2.CertificateV2;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.Common;
import net.named_data.jndn.util.SignedBlob;

public class SafeBag {
    private Data certificate_ = null;
    private Blob privateKeyBag_ = new Blob();

    public SafeBag(Data certificate, Blob privateKeyBag) {
        this.certificate_ = new Data(certificate);
        this.privateKeyBag_ = privateKeyBag;
    }

    public SafeBag(Name keyName, Blob privateKeyBag, Blob publicKeyEncoding, ByteBuffer password, DigestAlgorithm digestAlgorithm, WireFormat wireFormat) throws TpmBackEnd.Error, Pib.Error {
        this.certificate_ = SafeBag.makeSelfSignedCertificate(keyName, privateKeyBag, publicKeyEncoding, password, digestAlgorithm, wireFormat);
        this.privateKeyBag_ = privateKeyBag;
    }

    public SafeBag(Name keyName, Blob privateKeyBag, Blob publicKeyEncoding, ByteBuffer password, DigestAlgorithm digestAlgorithm) throws TpmBackEnd.Error, Pib.Error {
        this.certificate_ = SafeBag.makeSelfSignedCertificate(keyName, privateKeyBag, publicKeyEncoding, password, digestAlgorithm, WireFormat.getDefaultWireFormat());
        this.privateKeyBag_ = privateKeyBag;
    }

    public SafeBag(Name keyName, Blob privateKeyBag, Blob publicKeyEncoding, ByteBuffer password) throws TpmBackEnd.Error, Pib.Error {
        this.certificate_ = SafeBag.makeSelfSignedCertificate(keyName, privateKeyBag, publicKeyEncoding, password, DigestAlgorithm.SHA256, WireFormat.getDefaultWireFormat());
        this.privateKeyBag_ = privateKeyBag;
    }

    public SafeBag(Name keyName, Blob privateKeyBag, Blob publicKeyEncoding) throws TpmBackEnd.Error, Pib.Error {
        this.certificate_ = SafeBag.makeSelfSignedCertificate(keyName, privateKeyBag, publicKeyEncoding, null, DigestAlgorithm.SHA256, WireFormat.getDefaultWireFormat());
        this.privateKeyBag_ = privateKeyBag;
    }

    public final Data getCertificate() {
        return this.certificate_;
    }

    public final Blob getPrivateKeyBag() {
        return this.privateKeyBag_;
    }

    private static CertificateV2 makeSelfSignedCertificate(Name keyName, Blob privateKeyBag, Blob publicKeyEncoding, ByteBuffer password, DigestAlgorithm digestAlgorithm, WireFormat wireFormat) throws TpmBackEnd.Error, Pib.Error {
        CertificateV2 certificate = new CertificateV2();
        double now = Common.getNowMilliseconds();
        Name certificateName = new Name(keyName);
        certificateName.append("self").appendVersion((long)now);
        certificate.setName(certificateName);
        certificate.getMetaInfo().setType(ContentType.KEY);
        certificate.getMetaInfo().setFreshnessPeriod(3600000.0);
        PublicKey publicKey = null;
        try {
            publicKey = new PublicKey(publicKeyEncoding);
        }
        catch (UnrecognizedKeyFormatException ex) {
            throw new Pib.Error("Error decoding public key " + ex);
        }
        certificate.setContent(publicKey.getKeyDer());
        Tpm tpm = new Tpm("", "", new TpmBackEndMemory());
        tpm.importPrivateKey_(keyName, privateKeyBag.buf(), password);
        if (publicKey.getKeyType() == KeyType.RSA) {
            certificate.setSignature(new Sha256WithRsaSignature());
        } else if (publicKey.getKeyType() == KeyType.ECDSA) {
            certificate.setSignature(new Sha256WithEcdsaSignature());
        } else {
            throw new AssertionError((Object)"Unsupported key type");
        }
        Signature signatureInfo = certificate.getSignature();
        KeyLocator.getFromSignature(signatureInfo).setType(KeyLocatorType.KEYNAME);
        KeyLocator.getFromSignature(signatureInfo).setKeyName(keyName);
        ValidityPeriod.getFromSignature(signatureInfo).setPeriod(now, now + 6.3072E11);
        SignedBlob encoding = certificate.wireEncode(wireFormat);
        Blob signatureBytes = tpm.sign(encoding.signedBuf(), keyName, digestAlgorithm);
        signatureInfo.setSignature(signatureBytes);
        certificate.wireEncode(wireFormat);
        return certificate;
    }
}

