/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import net.named_data.jndn.Name;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.ChangeCountable;

public class DelegationSet
implements ChangeCountable {
    private final ArrayList<Delegation> delegations_ = new ArrayList();
    private long changeCount_ = 0L;

    public DelegationSet() {
    }

    public DelegationSet(DelegationSet delegationSet) {
        this.delegations_.addAll(delegationSet.delegations_);
    }

    public final void add(int preference, Name name) {
        int i;
        this.remove(name);
        Delegation newDelegation = new Delegation(preference, name);
        for (i = 0; i < this.delegations_.size() && this.delegations_.get(i).compare(newDelegation) < 0; ++i) {
        }
        this.delegations_.add(i, newDelegation);
        ++this.changeCount_;
    }

    public final void addUnsorted(int preference, Name name) {
        this.delegations_.add(new Delegation(preference, name));
        ++this.changeCount_;
    }

    public final boolean remove(Name name) {
        boolean wasRemoved = false;
        for (int i = this.delegations_.size() - 1; i >= 0; --i) {
            if (!this.delegations_.get(i).getName().equals(name)) continue;
            wasRemoved = true;
            this.delegations_.remove(i);
        }
        if (wasRemoved) {
            ++this.changeCount_;
        }
        return wasRemoved;
    }

    public final void clear() {
        this.delegations_.clear();
        ++this.changeCount_;
    }

    public final int size() {
        return this.delegations_.size();
    }

    public final Delegation get(int i) {
        return this.delegations_.get(i);
    }

    public final int find(Name name) {
        for (int i = 0; i < this.delegations_.size(); ++i) {
            if (!this.delegations_.get(i).getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public final Blob wireEncode(WireFormat wireFormat) {
        return wireFormat.encodeDelegationSet(this);
    }

    public final Blob wireEncode() {
        return this.wireEncode(WireFormat.getDefaultWireFormat());
    }

    public final void wireDecode(ByteBuffer input, WireFormat wireFormat) throws EncodingException {
        wireFormat.decodeDelegationSet(this, input, true);
    }

    public final void wireDecode(ByteBuffer input) throws EncodingException {
        this.wireDecode(input, WireFormat.getDefaultWireFormat());
    }

    public final void wireDecode(Blob input, WireFormat wireFormat) throws EncodingException {
        wireFormat.decodeDelegationSet(this, input.buf(), false);
    }

    public final void wireDecode(Blob input) throws EncodingException {
        this.wireDecode(input.buf());
    }

    @Override
    public final long getChangeCount() {
        return this.changeCount_;
    }

    public static class Delegation {
        private final int preference_;
        private final Name name_;

        public Delegation(int preference, Name name) {
            this.preference_ = preference;
            this.name_ = new Name(name);
        }

        public final int getPreference() {
            return this.preference_;
        }

        public final Name getName() {
            return this.name_;
        }

        public final int compare(Delegation other) {
            if (this.preference_ < other.preference_) {
                return -1;
            }
            if (this.preference_ > other.preference_) {
                return 1;
            }
            return this.name_.compare(other.name_);
        }
    }
}

