/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn;

import java.nio.ByteBuffer;
import net.named_data.jndn.ForwardingFlags;
import net.named_data.jndn.Name;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.util.Blob;

public class ControlParameters {
    private Name name_ = null;
    private int faceId_ = -1;
    private String uri_ = "";
    private int localControlFeature_ = -1;
    private int origin_ = -1;
    private int cost_ = -1;
    private ForwardingFlags flags_ = new ForwardingFlags();
    private Name strategy_ = new Name();
    private double expirationPeriod_ = -1.0;

    public ControlParameters() {
    }

    public ControlParameters(ControlParameters controlParameters) {
        this.name_ = controlParameters.name_ == null ? null : new Name(controlParameters.name_);
        this.faceId_ = controlParameters.faceId_;
        this.uri_ = controlParameters.uri_;
        this.localControlFeature_ = controlParameters.localControlFeature_;
        this.origin_ = controlParameters.origin_;
        this.cost_ = controlParameters.cost_;
        this.flags_ = new ForwardingFlags(controlParameters.flags_);
        this.strategy_ = new Name(controlParameters.strategy_);
        this.expirationPeriod_ = controlParameters.expirationPeriod_;
    }

    public final Blob wireEncode(WireFormat wireFormat) {
        return wireFormat.encodeControlParameters(this);
    }

    public final Blob wireEncode() {
        return this.wireEncode(WireFormat.getDefaultWireFormat());
    }

    public final void wireDecode(ByteBuffer input, WireFormat wireFormat) throws EncodingException {
        wireFormat.decodeControlParameters(this, input, true);
    }

    public final void wireDecode(ByteBuffer input) throws EncodingException {
        this.wireDecode(input, WireFormat.getDefaultWireFormat());
    }

    public final void wireDecode(Blob input, WireFormat wireFormat) throws EncodingException {
        wireFormat.decodeControlParameters(this, input.buf(), false);
    }

    public final void wireDecode(Blob input) throws EncodingException {
        this.wireDecode(input.buf());
    }

    public final Name getName() {
        return this.name_;
    }

    public final int getFaceId() {
        return this.faceId_;
    }

    public final String getUri() {
        return this.uri_;
    }

    public final int getLocalControlFeature() {
        return this.localControlFeature_;
    }

    public final int getOrigin() {
        return this.origin_;
    }

    public final int getCost() {
        return this.cost_;
    }

    public final ForwardingFlags getForwardingFlags() {
        return this.flags_;
    }

    public final Name getStrategy() {
        return this.strategy_;
    }

    public final double getExpirationPeriod() {
        return this.expirationPeriod_;
    }

    public final ControlParameters setName(Name name) {
        this.name_ = name == null ? null : new Name(name);
        return this;
    }

    public final ControlParameters setFaceId(int faceId) {
        this.faceId_ = faceId;
        return this;
    }

    public final ControlParameters setUri(String uri) {
        this.uri_ = uri == null ? "" : uri;
        return this;
    }

    public final ControlParameters setLocalControlFeature(int localControlFeature) {
        this.localControlFeature_ = localControlFeature;
        return this;
    }

    public final ControlParameters setOrigin(int origin) {
        this.origin_ = origin;
        return this;
    }

    public final ControlParameters setCost(int cost) {
        this.cost_ = cost;
        return this;
    }

    public final ControlParameters setForwardingFlags(ForwardingFlags forwardingFlags) {
        this.flags_ = forwardingFlags == null ? new ForwardingFlags() : new ForwardingFlags(forwardingFlags);
        return this;
    }

    public final ControlParameters setStrategy(Name strategy) {
        this.strategy_ = strategy == null ? new Name() : new Name(strategy);
        return this;
    }

    public final ControlParameters setExpirationPeriod(double expirationPeriod) {
        this.expirationPeriod_ = expirationPeriod;
        return this;
    }

    public final void clear() {
        this.name_ = null;
        this.faceId_ = -1;
        this.uri_ = "";
        this.localControlFeature_ = -1;
        this.origin_ = -1;
        this.cost_ = -1;
        this.flags_ = new ForwardingFlags();
        this.strategy_ = new Name();
        this.expirationPeriod_ = -1.0;
    }

    public boolean equals(Object other) {
        return false;
    }
}

