/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.cache.template;

import net.n2oapp.cache.template.ThreeLevelCacheCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public class ThreeLevelCacheTemplate<F, S, T> {
    protected static final Logger log = LoggerFactory.getLogger(ThreeLevelCacheTemplate.class);
    private CacheManager cacheManager;

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    protected CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public F execute(String firstLevelRegion, String secondLevelRegion, String thirdLevelRegion, Object firstKey, Object secondKey, Object thirdKey, ThreeLevelCacheCallback<F, S, T> callback) {
        Cache firstLevelCache = null;
        if (firstLevelRegion != null) {
            firstLevelCache = this.getCacheManager().getCache(firstLevelRegion);
            if (firstLevelCache != null) {
                Cache.ValueWrapper firstLevelCacheValueWrapper = firstLevelCache.get(firstKey);
                if (firstLevelCacheValueWrapper != null) {
                    Object f = firstLevelCacheValueWrapper.get();
                    callback.doInFirstLevelCacheHit(f);
                    return (F)f;
                }
            } else {
                log.warn("Cannot find cache named [" + firstLevelRegion + "] for ThreeLevelCacheTemplate");
            }
        }
        Cache secondLevelCache = null;
        if (secondLevelRegion != null) {
            secondLevelCache = this.getCacheManager().getCache(secondLevelRegion);
            if (secondLevelCache != null) {
                Object secondLevelCacheValue;
                Cache.ValueWrapper secondLevelCacheValueWrapper = secondLevelCache.get(secondKey);
                if (secondLevelCacheValueWrapper != null && (secondLevelCacheValue = secondLevelCacheValueWrapper.get()) != null) {
                    callback.doInSecondLevelCacheHit(secondLevelCacheValue);
                    return this.handleFirstCache(firstKey, secondLevelCacheValue, firstLevelCache, callback);
                }
            } else {
                log.warn("Cannot find cache named [" + secondLevelRegion + "] for ThreeLevelCacheTemplate");
            }
        }
        Cache thirdLevelCache = null;
        if (thirdLevelRegion != null) {
            thirdLevelCache = this.getCacheManager().getCache(thirdLevelRegion);
            if (thirdLevelCache != null) {
                Object thirdLevelCacheValue;
                Cache.ValueWrapper thirdLevelCacheValueWrapper = thirdLevelCache.get(thirdKey);
                if (thirdLevelCacheValueWrapper != null && (thirdLevelCacheValue = thirdLevelCacheValueWrapper.get()) != null) {
                    callback.doInThirdLevelCacheHit(thirdLevelCacheValue);
                    F result = this.handleSecondCache(firstKey, secondKey, callback, firstLevelCache, secondLevelCache, thirdLevelCacheValue);
                    if (result != null) {
                        return result;
                    }
                }
            } else {
                log.warn("Cannot find cache named [" + thirdLevelRegion + "] for ThreeLevelCacheTemplate");
            }
        }
        return this.handleThirdCache(firstKey, secondKey, thirdKey, callback, firstLevelCache, secondLevelCache, thirdLevelCache);
    }

    protected F handleThirdCache(Object firstKey, Object secondKey, Object thirdKey, ThreeLevelCacheCallback<F, S, T> callback, Cache firstLevelCache, Cache secondLevelCache, Cache thirdLevelCache) {
        T thirdLevelCacheValue = callback.doInThirdLevelCacheMiss();
        if (thirdLevelCacheValue != null) {
            thirdLevelCache.put(thirdKey, thirdLevelCacheValue);
            F result = this.handleSecondCache(firstKey, secondKey, callback, firstLevelCache, secondLevelCache, thirdLevelCacheValue);
            if (result != null) {
                return result;
            }
        }
        return null;
    }

    protected F handleSecondCache(Object firstKey, Object secondKey, ThreeLevelCacheCallback<F, S, T> callback, Cache firstLevelCache, Cache secondLevelCache, T thirdLevelCacheValue) {
        S secondLevelCacheValue = callback.doInSecondLevelCacheMiss(thirdLevelCacheValue);
        if (secondLevelCacheValue != null) {
            secondLevelCache.put(secondKey, secondLevelCacheValue);
            return this.handleFirstCache(firstKey, secondLevelCacheValue, firstLevelCache, callback);
        }
        return null;
    }

    protected F handleFirstCache(Object firstKey, S secondLevelCacheValue, Cache firstLevelCache, ThreeLevelCacheCallback<F, S, T> callback) {
        F firstLevelCacheValue = callback.doInFirstLevelCacheMiss(secondLevelCacheValue);
        if (firstLevelCache != null) {
            firstLevelCache.put(firstKey, firstLevelCacheValue);
        }
        return firstLevelCacheValue;
    }
}

