/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.cache.template;

import net.n2oapp.cache.template.TwoLevelCacheCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public class TwoLevelCacheTemplate<K, F, S> {
    private static final Logger log = LoggerFactory.getLogger(TwoLevelCacheTemplate.class);
    private CacheManager cacheManager;

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    private CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public F execute(String firstLevelRegion, String secondLevelRegion, K key, TwoLevelCacheCallback<F, S> callback) {
        Cache firstLevelCache = null;
        if (firstLevelRegion != null) {
            firstLevelCache = this.getCacheManager().getCache(firstLevelRegion);
            if (firstLevelCache != null) {
                Cache.ValueWrapper firstLevelCacheValueWrapper = firstLevelCache.get(key);
                if (firstLevelCacheValueWrapper != null) {
                    Object f = firstLevelCacheValueWrapper.get();
                    callback.doInFirstLevelCacheHit(f);
                    return (F)f;
                }
            } else {
                log.warn("Cannot find cache named [" + firstLevelRegion + "] for TwoLevelCacheTemplate");
            }
        }
        Cache secondLevelCache = null;
        if (secondLevelRegion != null) {
            secondLevelCache = this.getCacheManager().getCache(secondLevelRegion);
            if (secondLevelCache != null) {
                Object secondLevelCacheValue;
                Cache.ValueWrapper secondLevelCacheValueWrapper = secondLevelCache.get(key);
                if (secondLevelCacheValueWrapper != null && (secondLevelCacheValue = secondLevelCacheValueWrapper.get()) != null) {
                    callback.doInSecondLevelCacheHit(secondLevelCacheValue);
                    return this.handleFirstCache(key, callback, firstLevelCache, secondLevelCacheValue);
                }
            } else {
                log.warn("Cannot find cache named [" + secondLevelRegion + "] for TwoLevelCacheTemplate");
            }
        }
        S secondLevelCacheValue = this.handleSecondCache(key, callback, secondLevelCache);
        return this.handleFirstCache(key, callback, firstLevelCache, secondLevelCacheValue);
    }

    protected F handleFirstCache(K key, TwoLevelCacheCallback<F, S> callback, Cache firstLevelCache, S secondLevelCacheValue) {
        F firstLevelCacheValue = callback.doInFirstLevelCacheMiss(secondLevelCacheValue);
        if (firstLevelCache != null) {
            firstLevelCache.put(key, firstLevelCacheValue);
        }
        return firstLevelCacheValue;
    }

    protected S handleSecondCache(K key, TwoLevelCacheCallback<F, S> callback, Cache secondLevelCache) {
        S secondLevelCacheValue = callback.doInSecondLevelCacheMiss();
        if (secondLevelCache != null) {
            secondLevelCache.put(key, secondLevelCacheValue);
        }
        return secondLevelCacheValue;
    }
}

