/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.web.servlets;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.myrrix.common.MyrrixRecommender;
import net.myrrix.common.NotReadyException;
import net.myrrix.common.collection.FastIDSet;
import net.myrrix.online.RescorerProvider;
import net.myrrix.web.servlets.AbstractMyrrixServlet;
import org.apache.mahout.cf.taste.common.NoSuchItemException;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.recommender.Rescorer;

public final class SimilarityServlet
extends AbstractMyrrixServlet {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        int howMany = SimilarityServlet.getHowMany((ServletRequest)request);
        String pathInfo = request.getPathInfo();
        Iterator pathComponents = SLASH.split((CharSequence)pathInfo).iterator();
        FastIDSet itemIDSet = new FastIDSet();
        try {
            while (pathComponents.hasNext()) {
                itemIDSet.add(Long.parseLong((String)pathComponents.next()));
            }
        }
        catch (NoSuchElementException nsee) {
            response.sendError(400, nsee.toString());
            return;
        }
        catch (NumberFormatException nfe) {
            response.sendError(400, nfe.toString());
            return;
        }
        if (itemIDSet.isEmpty()) {
            response.sendError(400);
            return;
        }
        MyrrixRecommender recommender = this.getRecommender();
        RescorerProvider rescorerProvider = this.getRescorerProvider();
        try {
            List similar;
            if (rescorerProvider == null) {
                similar = recommender.mostSimilarItems(itemIDSet.toArray(), howMany);
            } else {
                Rescorer rescorer = rescorerProvider.getMostSimilarItemsRescorer(SimilarityServlet.getRescorerParams((ServletRequest)request));
                similar = recommender.mostSimilarItems(itemIDSet.toArray(), howMany, rescorer);
            }
            this.output(request, (ServletResponse)response, similar);
        }
        catch (NoSuchItemException nsie) {
            response.sendError(404, nsie.toString());
        }
        catch (NotReadyException nre) {
            response.sendError(503, nre.toString());
        }
        catch (TasteException te) {
            response.sendError(500, te.toString());
            this.getServletContext().log("Unexpected error in " + ((Object)((Object)this)).getClass().getSimpleName(), (Throwable)te);
        }
    }

    @Override
    protected Long getUnnormalizedPartitionToServe(HttpServletRequest request) {
        long firstItemID;
        String pathInfo = request.getPathInfo();
        Iterator pathComponents = SLASH.split((CharSequence)pathInfo).iterator();
        try {
            firstItemID = Long.parseLong((String)pathComponents.next());
        }
        catch (NoSuchElementException nsee) {
            return null;
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return firstItemID;
    }
}

