/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.web.servlets;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.myrrix.common.LangUtils;
import net.myrrix.common.MyrrixRecommender;
import net.myrrix.common.NotReadyException;
import net.myrrix.online.RescorerProvider;
import net.myrrix.web.servlets.AbstractMyrrixServlet;
import org.apache.mahout.cf.taste.common.NoSuchItemException;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.recommender.IDRescorer;
import org.apache.mahout.common.Pair;

public final class RecommendToAnonymousServlet
extends AbstractMyrrixServlet {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pathInfo = request.getPathInfo();
        Iterator pathComponents = SLASH.split((CharSequence)pathInfo).iterator();
        ArrayList itemValuePairs = Lists.newArrayListWithCapacity((int)1);
        try {
            while (pathComponents.hasNext()) {
                itemValuePairs.add(RecommendToAnonymousServlet.parseItemValue((String)pathComponents.next()));
            }
        }
        catch (NoSuchElementException nsee) {
            response.sendError(400, nsee.toString());
            return;
        }
        catch (NumberFormatException nfe) {
            response.sendError(400, nfe.toString());
            return;
        }
        if (itemValuePairs.isEmpty()) {
            response.sendError(400);
            return;
        }
        int size = itemValuePairs.size();
        long[] itemIDs = new long[size];
        float[] values = new float[size];
        for (int i = 0; i < size; ++i) {
            Pair itemValuePair = (Pair)itemValuePairs.get(i);
            itemIDs[i] = (Long)itemValuePair.getFirst();
            Float value = (Float)itemValuePair.getSecond();
            values[i] = value == null ? 1.0f : value.floatValue();
        }
        MyrrixRecommender recommender = this.getRecommender();
        RescorerProvider rescorerProvider = this.getRescorerProvider();
        IDRescorer rescorer = rescorerProvider == null ? null : rescorerProvider.getRecommendToAnonymousRescorer(itemIDs, RecommendToAnonymousServlet.getRescorerParams((ServletRequest)request));
        try {
            List recommended = recommender.recommendToAnonymous(itemIDs, values, RecommendToAnonymousServlet.getHowMany((ServletRequest)request), rescorer);
            this.output(request, (ServletResponse)response, recommended);
        }
        catch (NotReadyException nre) {
            response.sendError(503, nre.toString());
        }
        catch (NoSuchItemException nsie) {
            response.sendError(404, nsie.toString());
        }
        catch (TasteException te) {
            response.sendError(500, te.toString());
            this.getServletContext().log("Unexpected error in " + ((Object)((Object)this)).getClass().getSimpleName(), (Throwable)te);
        }
    }

    @Override
    protected Long getUnnormalizedPartitionToServe(HttpServletRequest request) {
        long firstItemID;
        String pathInfo = request.getPathInfo();
        Iterator pathComponents = SLASH.split((CharSequence)pathInfo).iterator();
        try {
            firstItemID = (Long)RecommendToAnonymousServlet.parseItemValue((String)pathComponents.next()).getFirst();
        }
        catch (NoSuchElementException nsee) {
            return null;
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return firstItemID;
    }

    private static Pair<Long, Float> parseItemValue(String s) {
        int equals = s.indexOf(61);
        if (equals < 0) {
            return Pair.of((Object)Long.parseLong(s), null);
        }
        return Pair.of((Object)Long.parseLong(s.substring(0, equals)), (Object)Float.valueOf(LangUtils.parseFloat((String)s.substring(equals + 1))));
    }
}

