/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.web.servlets;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import net.myrrix.common.MyrrixRecommender;
import net.myrrix.web.servlets.AbstractMyrrixServlet;
import org.apache.mahout.cf.taste.common.TasteException;

public final class IngestServlet
extends AbstractMyrrixServlet {
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Reader reader;
        MyrrixRecommender recommender = this.getRecommender();
        boolean fromBrowserUpload = request.getContentType().startsWith("multipart/form-data");
        if (fromBrowserUpload) {
            Collection parts = request.getParts();
            if (parts == null || parts.isEmpty()) {
                response.sendError(400, "No form data");
                return;
            }
            Part part = (Part)parts.iterator().next();
            String partContentType = part.getContentType();
            InputStream in = part.getInputStream();
            if ("application/zip".equals(partContentType)) {
                in = new ZipInputStream(in);
            } else if ("application/x-gzip".equals(partContentType)) {
                in = new GZIPInputStream(in);
            }
            reader = new InputStreamReader(in, Charsets.UTF_8);
        } else {
            String contentEncoding = request.getHeader("Content-Encoding");
            if (contentEncoding == null) {
                reader = request.getReader();
            } else if ("gzip".equals(contentEncoding)) {
                String charEncodingName = request.getCharacterEncoding();
                Charset charEncoding = charEncodingName == null ? Charsets.UTF_8 : Charset.forName(charEncodingName);
                reader = new InputStreamReader((InputStream)new GZIPInputStream((InputStream)request.getInputStream()), charEncoding);
            } else {
                response.sendError(400, "Unsupported Content-Encoding");
                return;
            }
        }
        try {
            recommender.ingest(reader);
        }
        catch (IllegalArgumentException iae) {
            response.sendError(400, iae.toString());
            return;
        }
        catch (NoSuchElementException nsee) {
            response.sendError(400, nsee.toString());
            return;
        }
        catch (TasteException te) {
            response.sendError(500, te.toString());
            this.getServletContext().log("Unexpected error in " + ((Object)((Object)this)).getClass().getSimpleName(), (Throwable)te);
            return;
        }
        String referer = request.getHeader("Referer");
        if (fromBrowserUpload && referer != null) {
            response.sendRedirect(referer);
        }
    }
}

