/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.web.servlets;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.myrrix.common.MyrrixRecommender;
import net.myrrix.common.NotReadyException;
import net.myrrix.web.servlets.AbstractMyrrixServlet;
import org.apache.mahout.cf.taste.common.NoSuchItemException;
import org.apache.mahout.cf.taste.common.NoSuchUserException;
import org.apache.mahout.cf.taste.common.TasteException;

public final class BecauseServlet
extends AbstractMyrrixServlet {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        long itemID;
        long userID;
        String pathInfo = request.getPathInfo();
        Iterator pathComponents = SLASH.split((CharSequence)pathInfo).iterator();
        try {
            userID = Long.parseLong((String)pathComponents.next());
            itemID = Long.parseLong((String)pathComponents.next());
        }
        catch (NoSuchElementException nsee) {
            response.sendError(400, nsee.toString());
            return;
        }
        catch (NumberFormatException nfe) {
            response.sendError(400, nfe.toString());
            return;
        }
        if (pathComponents.hasNext()) {
            response.sendError(400, "Path too long");
            return;
        }
        MyrrixRecommender recommender = this.getRecommender();
        try {
            List similar = recommender.recommendedBecause(userID, itemID, BecauseServlet.getHowMany((ServletRequest)request));
            this.output(request, (ServletResponse)response, similar);
        }
        catch (NoSuchUserException nsue) {
            response.sendError(404, nsue.toString());
        }
        catch (NoSuchItemException nsie) {
            response.sendError(404, nsie.toString());
        }
        catch (NotReadyException nre) {
            response.sendError(503, nre.toString());
        }
        catch (TasteException te) {
            response.sendError(500, te.toString());
            this.getServletContext().log("Unexpected error in " + ((Object)((Object)this)).getClass().getSimpleName(), (Throwable)te);
        }
        catch (UnsupportedOperationException uoe) {
            response.sendError(400, uoe.toString());
        }
    }

    @Override
    protected Long getUnnormalizedPartitionToServe(HttpServletRequest request) {
        long userID;
        String pathInfo = request.getPathInfo();
        Iterator pathComponents = SLASH.split((CharSequence)pathInfo).iterator();
        try {
            userID = Long.parseLong((String)pathComponents.next());
        }
        catch (NoSuchElementException nsee) {
            return null;
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return userID;
    }
}

