/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.web.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.myrrix.common.MyrrixRecommender;
import net.myrrix.common.NotReadyException;
import net.myrrix.common.collection.FastIDSet;
import net.myrrix.web.servlets.AbstractMyrrixServlet;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;

public abstract class AbstractAllIDsServlet
extends AbstractMyrrixServlet {
    protected abstract boolean isUserIDs();

    protected final void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        MyrrixRecommender recommender = this.getRecommender();
        try {
            FastIDSet ids = this.isUserIDs() ? recommender.getAllUserIDs() : recommender.getAllItemIDs();
            this.outputIDs(request, (ServletResponse)response, ids);
        }
        catch (NotReadyException nre) {
            response.sendError(503, nre.toString());
        }
        catch (TasteException te) {
            response.sendError(500, te.toString());
            this.getServletContext().log("Unexpected error in " + ((Object)((Object)this)).getClass().getSimpleName(), (Throwable)te);
        }
    }

    final void outputIDs(HttpServletRequest request, ServletResponse response, FastIDSet ids) throws IOException {
        PrintWriter writer = response.getWriter();
        LongPrimitiveIterator it = ids.iterator();
        switch (this.determineResponseType(request)) {
            case JSON: {
                writer.write(91);
                boolean first = true;
                while (it.hasNext()) {
                    if (first) {
                        first = false;
                    } else {
                        writer.write(44);
                    }
                    writer.write(Long.toString(it.nextLong()));
                }
                writer.write(93);
                break;
            }
            case CSV: {
                while (it.hasNext()) {
                    writer.write(Long.toString(it.nextLong()));
                    writer.write(10);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unknown response type");
            }
        }
    }
}

