/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.web;

import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.logging.Handler;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import net.myrrix.common.ClassUtils;
import net.myrrix.common.PartitionsUtils;
import net.myrrix.common.ReloadingReference;
import net.myrrix.common.io.IOUtils;
import net.myrrix.common.log.MemoryHandler;
import net.myrrix.online.RescorerProvider;
import net.myrrix.online.ServerRecommender;
import net.myrrix.online.io.ResourceRetriever;
import net.myrrix.online.partition.PartitionLoader;
import net.myrrix.web.servlets.AbstractMyrrixServlet;
import org.apache.mahout.common.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InitListener
implements ServletContextListener {
    private static final Logger log = LoggerFactory.getLogger(InitListener.class);
    private static final String KEY_PREFIX = InitListener.class.getName();
    public static final String LOG_HANDLER = KEY_PREFIX + ".LOG_HANDLER";
    public static final String LOCAL_INPUT_DIR_KEY = KEY_PREFIX + ".LOCAL_INPUT_DIR";
    public static final String PORT_KEY = KEY_PREFIX + ".PORT";
    public static final String READ_ONLY_KEY = KEY_PREFIX + ".READ_ONLY";
    public static final String BUCKET_KEY = KEY_PREFIX + ".BUCKET";
    public static final String INSTANCE_ID_KEY = KEY_PREFIX + ".INSTANCE_ID";
    public static final String RESCORER_PROVIDER_CLASS_KEY = KEY_PREFIX + ".RESCORER_PROVIDER_CLASS";
    public static final String ALL_PARTITIONS_SPEC_KEY = KEY_PREFIX + ".ALL_PARTITIONS_SPEC";
    public static final String PARTITION_KEY = KEY_PREFIX + ".PARTITION";
    public static final String LICENSE_FILE_KEY = KEY_PREFIX + ".LICENSE_FILE";
    private File tempDirToDelete;

    public void contextInitialized(ServletContextEvent event) {
        RescorerProvider rescorerProvider;
        int partition;
        File localInputDir;
        log.info("Initializing Myrrix in servlet context...");
        ServletContext context = event.getServletContext();
        MemoryHandler.setSensibleLogFormat();
        Object logHandler = null;
        for (Handler handler : java.util.logging.Logger.getLogger("").getHandlers()) {
            if (!(handler instanceof MemoryHandler)) continue;
            logHandler = handler;
            break;
        }
        if (logHandler == null) {
            logHandler = new MemoryHandler();
            java.util.logging.Logger.getLogger("").addHandler((Handler)logHandler);
        }
        context.setAttribute(LOG_HANDLER, logHandler);
        String localInputDirName = InitListener.getAttributeOrParam(context, LOCAL_INPUT_DIR_KEY);
        if (localInputDirName == null) {
            localInputDir = Files.createTempDir();
            localInputDir.deleteOnExit();
            this.tempDirToDelete = localInputDir;
        } else {
            boolean madeDirs;
            localInputDir = new File(localInputDirName);
            if (!localInputDir.exists() && !(madeDirs = localInputDir.mkdirs())) {
                log.warn("Failed to create local input dir {}", (Object)localInputDir);
            }
            this.tempDirToDelete = null;
        }
        context.setAttribute(AbstractMyrrixServlet.LOCAL_INPUT_DIR_KEY, (Object)localInputDir.getAbsolutePath());
        String partitionString = InitListener.getAttributeOrParam(context, PARTITION_KEY);
        if (partitionString == null) {
            partition = 0;
            log.info("No partition specified, so it is implicitly partition #{}", (Object)partition);
        } else {
            partition = Integer.parseInt(partitionString);
            log.info("Running as partition #{}", (Object)partition);
        }
        context.setAttribute(AbstractMyrrixServlet.PARTITION_KEY, (Object)partition);
        final String bucket = InitListener.getAttributeOrParam(context, BUCKET_KEY);
        try {
            rescorerProvider = InitListener.loadRescorerProvider(context, bucket);
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException(cnfe);
        }
        if (rescorerProvider != null) {
            context.setAttribute(AbstractMyrrixServlet.RESCORER_PROVIDER_KEY, (Object)rescorerProvider);
        }
        boolean readOnly = Boolean.parseBoolean(InitListener.getAttributeOrParam(context, READ_ONLY_KEY));
        context.setAttribute(AbstractMyrrixServlet.READ_ONLY_KEY, (Object)readOnly);
        final String portString = InitListener.getAttributeOrParam(context, PORT_KEY);
        final String instanceID = InitListener.getAttributeOrParam(context, INSTANCE_ID_KEY);
        final String allPartitionsSpecString = InitListener.getAttributeOrParam(context, ALL_PARTITIONS_SPEC_KEY);
        ReloadingReference allPartitionsReference = null;
        if (allPartitionsSpecString != null) {
            allPartitionsReference = new ReloadingReference((Callable)new Callable<List<List<Pair<String, Integer>>>>(){

                @Override
                public List<List<Pair<String, Integer>>> call() {
                    if ("auto".equals(allPartitionsSpecString)) {
                        int port = Integer.parseInt(portString);
                        PartitionLoader loader = (PartitionLoader)ClassUtils.loadInstanceOf((String)"net.myrrix.online.partition.PartitionLoaderImpl", PartitionLoader.class);
                        List newPartitions = loader.loadPartitions(port, bucket, instanceID);
                        log.info("Latest partitions: {}", (Object)newPartitions);
                        return newPartitions;
                    }
                    return PartitionsUtils.parseAllPartitions((CharSequence)allPartitionsSpecString);
                }
            }, 10L, TimeUnit.MINUTES);
            allPartitionsReference.get();
            context.setAttribute(AbstractMyrrixServlet.ALL_PARTITIONS_REF_KEY, (Object)allPartitionsReference);
        }
        File licenseFile = (File)context.getAttribute(LICENSE_FILE_KEY);
        ServerRecommender recommender = new ServerRecommender(bucket, instanceID, localInputDir, partition, allPartitionsReference, licenseFile);
        context.setAttribute(AbstractMyrrixServlet.RECOMMENDER_KEY, (Object)recommender);
        log.info("Myrrix is initialized");
    }

    private static String getAttributeOrParam(ServletContext context, String key) {
        String valueString;
        Object valueObject = context.getAttribute(key);
        String string = valueString = valueObject == null ? null : valueObject.toString();
        if (valueString == null) {
            valueString = context.getInitParameter(key);
        }
        return valueString;
    }

    private static RescorerProvider loadRescorerProvider(ServletContext context, String bucket) throws IOException, ClassNotFoundException {
        String rescorerProviderClassName = InitListener.getAttributeOrParam(context, RESCORER_PROVIDER_CLASS_KEY);
        if (rescorerProviderClassName == null) {
            return null;
        }
        log.info("Using RescorerProvider class {}", (Object)rescorerProviderClassName);
        if (ClassUtils.classExists((String)rescorerProviderClassName)) {
            log.info("Found class in local classpath");
            return (RescorerProvider)ClassUtils.loadInstanceOf((String)rescorerProviderClassName, RescorerProvider.class);
        }
        log.info("Class doesn't exist in local classpath");
        ResourceRetriever resourceRetriever = (ResourceRetriever)ClassUtils.loadInstanceOf((String)"net.myrrix.online.io.DelegateResourceRetriever", ResourceRetriever.class);
        resourceRetriever.init(bucket);
        File tempResourceFile = resourceRetriever.getRescorerJar();
        if (tempResourceFile == null) {
            log.info("No external rescorer JAR is available in this implementation");
            throw new ClassNotFoundException(rescorerProviderClassName);
        }
        log.info("Loading {} from {}, copied from remote JAR at key {}", new Object[]{rescorerProviderClassName, tempResourceFile, tempResourceFile});
        RescorerProvider rescorerProvider = (RescorerProvider)ClassUtils.loadFromRemote((String)rescorerProviderClassName, RescorerProvider.class, (URL)tempResourceFile.toURI().toURL());
        if (!tempResourceFile.delete()) {
            log.info("Could not delete {}", (Object)tempResourceFile);
        }
        return rescorerProvider;
    }

    public void contextDestroyed(ServletContextEvent event) {
        log.info("Uninitializing Myrrix in servlet context...");
        ServletContext context = event.getServletContext();
        Closeable recommender = (Closeable)context.getAttribute(AbstractMyrrixServlet.RECOMMENDER_KEY);
        if (recommender != null) {
            try {
                recommender.close();
            }
            catch (IOException e) {
                log.warn("Unexpected error while closing", (Throwable)e);
            }
        }
        IOUtils.deleteRecursively((File)this.tempDirToDelete);
        log.info("Myrrix is uninitialized");
    }
}

