/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.web.servlets;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.myrrix.common.MyrrixRecommender;
import net.myrrix.web.servlets.AbstractMyrrixServlet;
import net.myrrix.web.servlets.PreferenceServlet;
import org.apache.mahout.cf.taste.common.TasteException;

public final class TagUserServlet
extends AbstractMyrrixServlet {
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        float tagValue;
        String userTag;
        long userID;
        String pathInfo = request.getPathInfo();
        Iterator pathComponents = SLASH.split((CharSequence)pathInfo).iterator();
        try {
            userID = Long.parseLong((String)pathComponents.next());
            userTag = (String)pathComponents.next();
        }
        catch (NoSuchElementException nsee) {
            response.sendError(400, nsee.toString());
            return;
        }
        catch (NumberFormatException nfe) {
            response.sendError(400, nfe.toString());
            return;
        }
        if (pathComponents.hasNext()) {
            response.sendError(400, "Path too long");
            return;
        }
        try {
            tagValue = PreferenceServlet.readValue((ServletRequest)request);
        }
        catch (IllegalArgumentException ignored) {
            response.sendError(400, "Bad value");
            return;
        }
        MyrrixRecommender recommender = this.getRecommender();
        try {
            recommender.setUserTag(userID, userTag, tagValue);
        }
        catch (TasteException te) {
            response.sendError(500, te.toString());
            this.getServletContext().log("Unexpected error in " + ((Object)((Object)this)).getClass().getSimpleName(), (Throwable)te);
        }
    }

    @Override
    protected Long getUnnormalizedPartitionToServe(HttpServletRequest request) {
        long userID;
        String pathInfo = request.getPathInfo();
        Iterator pathComponents = SLASH.split((CharSequence)pathInfo).iterator();
        try {
            userID = Long.parseLong((String)pathComponents.next());
        }
        catch (NoSuchElementException ignored) {
            return null;
        }
        catch (NumberFormatException ignored) {
            return null;
        }
        return userID;
    }
}

