/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.web.servlets;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.myrrix.common.LangUtils;
import net.myrrix.common.MyrrixRecommender;
import net.myrrix.common.NotReadyException;
import net.myrrix.online.RescorerProvider;
import net.myrrix.web.servlets.AbstractMyrrixServlet;
import org.apache.mahout.cf.taste.common.NoSuchItemException;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.recommender.IDRescorer;
import org.apache.mahout.common.Pair;

public final class RecommendToAnonymousServlet
extends AbstractMyrrixServlet {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Pair<long[], float[]> itemIDsAndValue;
        String pathInfo = request.getPathInfo();
        Iterator<String> pathComponents = SLASH.split((CharSequence)pathInfo).iterator();
        try {
            itemIDsAndValue = RecommendToAnonymousServlet.parseItemValuePairs(pathComponents);
        }
        catch (NoSuchElementException nsee) {
            response.sendError(400, nsee.toString());
            return;
        }
        catch (NumberFormatException nfe) {
            response.sendError(400, nfe.toString());
            return;
        }
        if (((long[])itemIDsAndValue.getFirst()).length == 0) {
            response.sendError(400, "No items");
            return;
        }
        long[] itemIDs = (long[])itemIDsAndValue.getFirst();
        float[] values = (float[])itemIDsAndValue.getSecond();
        MyrrixRecommender recommender = this.getRecommender();
        RescorerProvider rescorerProvider = this.getRescorerProvider();
        IDRescorer rescorer = rescorerProvider == null ? null : rescorerProvider.getRecommendToAnonymousRescorer(itemIDs, recommender, RecommendToAnonymousServlet.getRescorerParams((ServletRequest)request));
        try {
            List recommended = recommender.recommendToAnonymous(itemIDs, values, RecommendToAnonymousServlet.getHowMany((ServletRequest)request), rescorer);
            this.output(request, (ServletResponse)response, recommended);
        }
        catch (NotReadyException nre) {
            response.sendError(503, nre.toString());
        }
        catch (NoSuchItemException nsie) {
            response.sendError(404, nsie.toString());
        }
        catch (TasteException te) {
            response.sendError(500, te.toString());
            this.getServletContext().log("Unexpected error in " + ((Object)((Object)this)).getClass().getSimpleName(), (Throwable)te);
        }
        catch (IllegalArgumentException iae) {
            response.sendError(400, iae.toString());
        }
    }

    static Pair<long[], float[]> parseItemValuePairs(Iterator<String> pathComponents) {
        ArrayList itemValuePairs = Lists.newArrayListWithCapacity((int)1);
        while (pathComponents.hasNext()) {
            itemValuePairs.add(RecommendToAnonymousServlet.parseItemValue(pathComponents.next()));
        }
        int size = itemValuePairs.size();
        long[] itemIDs = new long[size];
        float[] values = new float[size];
        for (int i = 0; i < size; ++i) {
            Pair itemValuePair = (Pair)itemValuePairs.get(i);
            itemIDs[i] = (Long)itemValuePair.getFirst();
            Float value = (Float)itemValuePair.getSecond();
            values[i] = value == null ? 1.0f : value.floatValue();
        }
        return Pair.of((Object)itemIDs, (Object)values);
    }

    private static Pair<Long, Float> parseItemValue(String s) {
        int equals = s.indexOf(61);
        if (equals < 0) {
            return Pair.of((Object)Long.parseLong(s), null);
        }
        return Pair.of((Object)Long.parseLong(s.substring(0, equals)), (Object)Float.valueOf(LangUtils.parseFloat((String)s.substring(equals + 1))));
    }
}

