/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.web.servlets;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.myrrix.common.MyrrixRecommender;
import net.myrrix.common.NotReadyException;
import net.myrrix.online.RescorerProvider;
import net.myrrix.web.servlets.AbstractMyrrixServlet;
import org.apache.mahout.cf.taste.common.NoSuchUserException;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.recommender.IDRescorer;

public final class RecommendServlet
extends AbstractMyrrixServlet {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        long userID;
        String pathInfo = request.getPathInfo();
        Iterator pathComponents = SLASH.split((CharSequence)pathInfo).iterator();
        try {
            userID = Long.parseLong((String)pathComponents.next());
        }
        catch (NoSuchElementException nsee) {
            response.sendError(400, nsee.toString());
            return;
        }
        catch (NumberFormatException nfe) {
            response.sendError(400, nfe.toString());
            return;
        }
        if (pathComponents.hasNext()) {
            response.sendError(400, "Path too long");
            return;
        }
        MyrrixRecommender recommender = this.getRecommender();
        RescorerProvider rescorerProvider = this.getRescorerProvider();
        IDRescorer rescorer = rescorerProvider == null ? null : rescorerProvider.getRecommendRescorer(new long[]{userID}, recommender, RecommendServlet.getRescorerParams((ServletRequest)request));
        try {
            List recommended = recommender.recommend(userID, RecommendServlet.getHowMany((ServletRequest)request), RecommendServlet.getConsiderKnownItems((ServletRequest)request), rescorer);
            this.output(request, (ServletResponse)response, recommended);
        }
        catch (NoSuchUserException nsue) {
            response.sendError(404, nsue.toString());
        }
        catch (NotReadyException nre) {
            response.sendError(503, nre.toString());
        }
        catch (TasteException te) {
            response.sendError(500, te.toString());
            this.getServletContext().log("Unexpected error in " + ((Object)((Object)this)).getClass().getSimpleName(), (Throwable)te);
        }
        catch (IllegalArgumentException iae) {
            response.sendError(400, iae.toString());
        }
        catch (UnsupportedOperationException uoe) {
            response.sendError(400, uoe.toString());
        }
    }

    @Override
    protected Long getUnnormalizedPartitionToServe(HttpServletRequest request) {
        long userID;
        String pathInfo = request.getPathInfo();
        Iterator pathComponents = SLASH.split((CharSequence)pathInfo).iterator();
        try {
            userID = Long.parseLong((String)pathComponents.next());
        }
        catch (NoSuchElementException ignored) {
            return null;
        }
        catch (NumberFormatException ignored) {
            return null;
        }
        return userID;
    }
}

