/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.web.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.myrrix.common.MyrrixRecommender;
import net.myrrix.common.NotReadyException;
import net.myrrix.web.servlets.AbstractMyrrixServlet;
import net.myrrix.web.servlets.RecommendToAnonymousServlet;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.common.Pair;

public final class EstimateForAnonymousServlet
extends AbstractMyrrixServlet {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Pair<long[], float[]> itemIDsAndValue;
        long toItemID;
        String pathInfo = request.getPathInfo();
        Iterator<String> pathComponents = SLASH.split((CharSequence)pathInfo).iterator();
        try {
            toItemID = Long.parseLong((String)pathComponents.next());
            itemIDsAndValue = RecommendToAnonymousServlet.parseItemValuePairs(pathComponents);
        }
        catch (NoSuchElementException nsee) {
            response.sendError(400, nsee.toString());
            return;
        }
        catch (NumberFormatException nfe) {
            response.sendError(400, nfe.toString());
            return;
        }
        if (((long[])itemIDsAndValue.getFirst()).length == 0) {
            response.sendError(400, "No items");
            return;
        }
        long[] itemIDs = (long[])itemIDsAndValue.getFirst();
        float[] values = (float[])itemIDsAndValue.getSecond();
        MyrrixRecommender recommender = this.getRecommender();
        try {
            float estimate = recommender.estimateForAnonymous(toItemID, itemIDs, values);
            PrintWriter out = response.getWriter();
            ((Writer)out).write(Float.toString(estimate));
            ((Writer)out).write(10);
        }
        catch (NotReadyException nre) {
            response.sendError(503, nre.toString());
        }
        catch (TasteException te) {
            response.sendError(500, te.toString());
            this.getServletContext().log("Unexpected error in " + ((Object)((Object)this)).getClass().getSimpleName(), (Throwable)te);
        }
    }
}

