/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.web.common.stats;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.myrrix.common.stats.RunningStatistics;
import net.myrrix.common.stats.RunningStatisticsPerTime;

public final class ServletStats
implements Serializable {
    private final RunningStatistics allTimeNanosec = new RunningStatistics();
    private final RunningStatisticsPerTime lastHourNanosec = new RunningStatisticsPerTime(TimeUnit.HOURS);
    private final AtomicInteger numClientErrors = new AtomicInteger();
    private final AtomicInteger numServerErrors = new AtomicInteger();

    public void addTimingNanosec(long timingNanosec) {
        this.allTimeNanosec.addDatum((double)timingNanosec);
        this.lastHourNanosec.addDatum((double)timingNanosec);
    }

    public RunningStatistics getAllTimeNanosec() {
        return this.allTimeNanosec;
    }

    public RunningStatisticsPerTime getLastHourNanosec() {
        return this.lastHourNanosec;
    }

    public int getNumClientErrors() {
        return this.numClientErrors.get();
    }

    public void incrementClientErrors() {
        this.numClientErrors.incrementAndGet();
    }

    public int getNumServerErrors() {
        return this.numServerErrors.get();
    }

    public void incrementServerErrors() {
        this.numServerErrors.incrementAndGet();
    }
}

