/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.web;

import com.google.common.io.Files;
import com.google.common.net.HostAndPort;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.logging.Handler;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import net.myrrix.common.ClassUtils;
import net.myrrix.common.MyrrixRecommender;
import net.myrrix.common.PartitionsUtils;
import net.myrrix.common.ReloadingReference;
import net.myrrix.common.io.IOUtils;
import net.myrrix.common.log.MemoryHandler;
import net.myrrix.online.AbstractRescorerProvider;
import net.myrrix.online.ClientThread;
import net.myrrix.online.RescorerProvider;
import net.myrrix.online.ServerRecommender;
import net.myrrix.online.io.ResourceRetriever;
import net.myrrix.online.partition.PartitionLoader;
import net.myrrix.web.servlets.AbstractMyrrixServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InitListener
implements ServletContextListener {
    private static final Logger log = LoggerFactory.getLogger(InitListener.class);
    private static final String KEY_PREFIX = InitListener.class.getName();
    public static final String LOG_HANDLER = KEY_PREFIX + ".LOG_HANDLER";
    public static final String LOCAL_INPUT_DIR_KEY = KEY_PREFIX + ".LOCAL_INPUT_DIR";
    public static final String PORT_KEY = KEY_PREFIX + ".PORT";
    public static final String READ_ONLY_KEY = KEY_PREFIX + ".READ_ONLY";
    public static final String BUCKET_KEY = KEY_PREFIX + ".BUCKET";
    public static final String INSTANCE_ID_KEY = KEY_PREFIX + ".INSTANCE_ID";
    public static final String RESCORER_PROVIDER_CLASS_KEY = KEY_PREFIX + ".RESCORER_PROVIDER_CLASS";
    public static final String CLIENT_THREAD_CLASS_KEY = KEY_PREFIX + ".CLIENT_THREAD_CLASS";
    public static final String ALL_PARTITIONS_SPEC_KEY = KEY_PREFIX + ".ALL_PARTITIONS_SPEC";
    public static final String PARTITION_KEY = KEY_PREFIX + ".PARTITION";
    public static final String LICENSE_FILE_KEY = KEY_PREFIX + ".LICENSE_FILE";
    private static final Pattern COMMA = Pattern.compile(",");
    private File tempDirToDelete;
    private ClientThread clientThread;

    public void contextInitialized(ServletContextEvent event) {
        log.info("Initializing Myrrix in servlet context...");
        ServletContext context = event.getServletContext();
        InitListener.configureLogging(context);
        File localInputDir = this.configureLocalInputDir(context);
        int partition = InitListener.configurePartition(context);
        String bucket = InitListener.getAttributeOrParam(context, BUCKET_KEY);
        String instanceID = InitListener.getAttributeOrParam(context, INSTANCE_ID_KEY);
        InitListener.configureRescorerProvider(context, bucket, instanceID);
        ReloadingReference<List<List<HostAndPort>>> allPartitionsReference = InitListener.configureAllPartitionsReference(context, bucket, instanceID);
        File licenseFile = (File)context.getAttribute(LICENSE_FILE_KEY);
        ServerRecommender recommender = new ServerRecommender(bucket, instanceID, localInputDir, partition, allPartitionsReference, licenseFile);
        context.setAttribute(AbstractMyrrixServlet.RECOMMENDER_KEY, (Object)recommender);
        this.configureClientThread(context, bucket, instanceID, (MyrrixRecommender)recommender);
        log.info("Myrrix is initialized");
    }

    private static void configureLogging(ServletContext context) {
        MemoryHandler.setSensibleLogFormat();
        Object logHandler = null;
        for (Handler handler : java.util.logging.Logger.getLogger("").getHandlers()) {
            if (!(handler instanceof MemoryHandler)) continue;
            logHandler = handler;
            break;
        }
        if (logHandler == null) {
            logHandler = new MemoryHandler();
            java.util.logging.Logger.getLogger("").addHandler((Handler)logHandler);
        }
        context.setAttribute(LOG_HANDLER, logHandler);
    }

    private File configureLocalInputDir(ServletContext context) {
        File localInputDir;
        String localInputDirName = InitListener.getAttributeOrParam(context, LOCAL_INPUT_DIR_KEY);
        if (localInputDirName == null) {
            localInputDir = Files.createTempDir();
            localInputDir.deleteOnExit();
            this.tempDirToDelete = localInputDir;
        } else {
            boolean madeDirs;
            localInputDir = new File(localInputDirName);
            if (!localInputDir.exists() && !(madeDirs = localInputDir.mkdirs())) {
                log.warn("Failed to create local input dir {}", (Object)localInputDir);
            }
            this.tempDirToDelete = null;
        }
        context.setAttribute(AbstractMyrrixServlet.LOCAL_INPUT_DIR_KEY, (Object)localInputDir.getAbsolutePath());
        return localInputDir;
    }

    private static int configurePartition(ServletContext context) {
        int partition;
        String partitionString = InitListener.getAttributeOrParam(context, PARTITION_KEY);
        if (partitionString == null) {
            partition = 0;
            log.info("No partition specified, so it is implicitly partition #{}", (Object)partition);
        } else {
            partition = Integer.parseInt(partitionString);
            log.info("Running as partition #{}", (Object)partition);
        }
        context.setAttribute(AbstractMyrrixServlet.PARTITION_KEY, (Object)partition);
        return partition;
    }

    private static void configureRescorerProvider(ServletContext context, String bucket, String instanceID) {
        RescorerProvider rescorerProvider;
        try {
            rescorerProvider = InitListener.loadRescorerProvider(context, bucket, instanceID);
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException(cnfe);
        }
        if (rescorerProvider != null) {
            context.setAttribute(AbstractMyrrixServlet.RESCORER_PROVIDER_KEY, (Object)rescorerProvider);
        }
    }

    private static ReloadingReference<List<List<HostAndPort>>> configureAllPartitionsReference(ServletContext context, final String bucket, final String instanceID) {
        boolean readOnly = Boolean.parseBoolean(InitListener.getAttributeOrParam(context, READ_ONLY_KEY));
        context.setAttribute(AbstractMyrrixServlet.READ_ONLY_KEY, (Object)readOnly);
        final String portString = InitListener.getAttributeOrParam(context, PORT_KEY);
        final String allPartitionsSpecString = InitListener.getAttributeOrParam(context, ALL_PARTITIONS_SPEC_KEY);
        ReloadingReference allPartitionsReference = null;
        if (allPartitionsSpecString != null) {
            allPartitionsReference = new ReloadingReference((Callable)new Callable<List<List<HostAndPort>>>(){

                @Override
                public List<List<HostAndPort>> call() {
                    if ("auto".equals(allPartitionsSpecString)) {
                        int port = Integer.parseInt(portString);
                        PartitionLoader loader = (PartitionLoader)ClassUtils.loadInstanceOf((String)"net.myrrix.online.partition.PartitionLoaderImpl", PartitionLoader.class);
                        List newPartitions = loader.loadPartitions(port, bucket, instanceID);
                        log.debug("Latest partitions: {}", (Object)newPartitions);
                        return newPartitions;
                    }
                    return PartitionsUtils.parseAllPartitions((CharSequence)allPartitionsSpecString);
                }
            }, 10L, TimeUnit.MINUTES);
            allPartitionsReference.get();
            context.setAttribute(AbstractMyrrixServlet.ALL_PARTITIONS_REF_KEY, (Object)allPartitionsReference);
        }
        return allPartitionsReference;
    }

    private void configureClientThread(ServletContext context, String bucket, String instanceID, MyrrixRecommender recommender) {
        ClientThread theThread;
        try {
            theThread = InitListener.loadClientThreadClass(context, bucket, instanceID);
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException(cnfe);
        }
        if (theThread != null) {
            theThread.setRecommender(recommender);
            this.clientThread = theThread;
            new Thread((Runnable)theThread, "MyrrixClientThread").start();
        }
    }

    private static String getAttributeOrParam(ServletContext context, String key) {
        String valueString;
        Object valueObject = context.getAttribute(key);
        String string = valueString = valueObject == null ? null : valueObject.toString();
        if (valueString == null) {
            valueString = context.getInitParameter(key);
        }
        return valueString;
    }

    private static RescorerProvider loadRescorerProvider(ServletContext context, String bucket, String instanceID) throws IOException, ClassNotFoundException {
        String rescorerProviderClassNames = InitListener.getAttributeOrParam(context, RESCORER_PROVIDER_CLASS_KEY);
        if (rescorerProviderClassNames == null) {
            return null;
        }
        log.info("Using RescorerProvider class(es) {}", (Object)rescorerProviderClassNames);
        boolean allClassesFound = true;
        for (String rescorerProviderClassName : COMMA.split(rescorerProviderClassNames)) {
            if (ClassUtils.classExists((String)rescorerProviderClassName)) continue;
            allClassesFound = false;
            break;
        }
        if (allClassesFound) {
            log.info("Found class(es) in local classpath");
            return AbstractRescorerProvider.loadRescorerProviders((String)rescorerProviderClassNames, null);
        }
        log.info("Class doesn't exist in local classpath");
        ResourceRetriever resourceRetriever = (ResourceRetriever)ClassUtils.loadInstanceOf((String)"net.myrrix.online.io.DelegateResourceRetriever", ResourceRetriever.class);
        resourceRetriever.init(bucket);
        File tempResourceFile = resourceRetriever.getRescorerJar(instanceID);
        if (tempResourceFile == null) {
            log.info("No external rescorer JAR is available in this implementation");
            throw new ClassNotFoundException(rescorerProviderClassNames);
        }
        log.info("Loading class(es) {} from {}, copied from remote JAR at key {}", new Object[]{rescorerProviderClassNames, tempResourceFile, tempResourceFile});
        RescorerProvider rescorerProvider = AbstractRescorerProvider.loadRescorerProviders((String)rescorerProviderClassNames, (URL)tempResourceFile.toURI().toURL());
        if (!tempResourceFile.delete()) {
            log.info("Could not delete {}", (Object)tempResourceFile);
        }
        return rescorerProvider;
    }

    private static ClientThread loadClientThreadClass(ServletContext context, String bucket, String instanceID) throws IOException, ClassNotFoundException {
        String clientThreadClassName = InitListener.getAttributeOrParam(context, CLIENT_THREAD_CLASS_KEY);
        if (clientThreadClassName == null) {
            return null;
        }
        log.info("Using Runnable/Closeable client thread class {}", (Object)clientThreadClassName);
        if (ClassUtils.classExists((String)clientThreadClassName)) {
            log.info("Found class on local classpath");
            return (ClientThread)ClassUtils.loadInstanceOf((String)clientThreadClassName, ClientThread.class);
        }
        log.info("Class doesn't exist in local classpath");
        ResourceRetriever resourceRetriever = (ResourceRetriever)ClassUtils.loadInstanceOf((String)"net.myrrix.online.io.DelegateResourceRetriever", ResourceRetriever.class);
        resourceRetriever.init(bucket);
        File tempResourceFile = resourceRetriever.getClientThreadJar(instanceID);
        if (tempResourceFile == null) {
            log.info("No external client thread JAR is available in this implementation");
            throw new ClassNotFoundException(clientThreadClassName);
        }
        log.info("Loading class {} from {}, copied from remote JAR at key {}", new Object[]{clientThreadClassName, tempResourceFile, tempResourceFile});
        ClientThread clientThreadRunnable = (ClientThread)ClassUtils.loadFromRemote((String)clientThreadClassName, ClientThread.class, (URL)tempResourceFile.toURI().toURL());
        if (!tempResourceFile.delete()) {
            log.info("Could not delete {}", (Object)tempResourceFile);
        }
        return clientThreadRunnable;
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext context;
        Closeable recommender;
        log.info("Uninitializing Myrrix in servlet context...");
        ClientThread theClientThread = this.clientThread;
        if (theClientThread != null) {
            try {
                theClientThread.close();
            }
            catch (IOException e) {
                log.warn("Error while closing client thread", (Throwable)e);
            }
        }
        if ((recommender = (Closeable)(context = event.getServletContext()).getAttribute(AbstractMyrrixServlet.RECOMMENDER_KEY)) != null) {
            try {
                recommender.close();
            }
            catch (IOException e) {
                log.warn("Unexpected error while closing", (Throwable)e);
            }
        }
        IOUtils.deleteRecursively((File)this.tempDirToDelete);
        log.info("Myrrix is uninitialized");
    }
}

