/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.web;

import com.google.common.base.Preconditions;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import net.myrrix.common.MyrrixRecommender;
import net.myrrix.common.NotReadyException;
import net.myrrix.common.parallel.Paralleler;
import net.myrrix.common.parallel.Processor;
import net.myrrix.online.RescorerProvider;
import net.myrrix.online.ServerRecommender;
import net.myrrix.web.AllConfig;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.recommender.IDRescorer;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;

public final class AllRecommendations
implements Callable<Object> {
    private final AllConfig config;

    public AllRecommendations(AllConfig config) {
        Preconditions.checkNotNull((Object)config);
        this.config = config;
    }

    public static void main(String[] args) throws Exception {
        AllConfig config = AllConfig.build(args);
        if (config != null) {
            new AllRecommendations(config).call();
        }
    }

    @Override
    public Object call() throws InterruptedException, NotReadyException, ExecutionException {
        final ServerRecommender recommender = new ServerRecommender(this.config.getLocalInputDir());
        recommender.await();
        final RescorerProvider rescorerProvider = this.config.getRescorerProvider();
        final int howMany = this.config.getHowMany();
        Processor<Long> processor = new Processor<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void process(Long userID, long count) throws ExecutionException {
                List recs;
                IDRescorer rescorer = rescorerProvider == null ? null : rescorerProvider.getRecommendRescorer(new long[]{userID}, (MyrrixRecommender)recommender, new String[0]);
                try {
                    recs = recommender.recommend(userID.longValue(), howMany, rescorer);
                }
                catch (TasteException te) {
                    throw new ExecutionException(te);
                }
                PrintStream printStream = System.out;
                synchronized (printStream) {
                    System.out.println(Long.toString(userID));
                    StringBuilder line = new StringBuilder(30);
                    for (RecommendedItem rec : recs) {
                        line.setLength(0);
                        line.append(Long.toString(rec.getItemID())).append(',').append(Float.toString(rec.getValue()));
                        System.out.println(line);
                    }
                }
            }
        };
        new Paralleler((Iterator)recommender.getAllUserIDs().iterator(), (Processor)processor, "AllRecommendations").runInParallel();
        return null;
    }
}

