/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.web;

import com.google.common.base.Preconditions;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import net.myrrix.common.MyrrixRecommender;
import net.myrrix.common.NotReadyException;
import net.myrrix.common.parallel.Paralleler;
import net.myrrix.common.parallel.Processor;
import net.myrrix.online.RescorerProvider;
import net.myrrix.online.ServerRecommender;
import net.myrrix.web.AllConfig;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.cf.taste.recommender.Rescorer;

public final class AllItemSimilarities
implements Callable<Object> {
    private final AllConfig config;

    public AllItemSimilarities(AllConfig config) {
        Preconditions.checkNotNull((Object)config);
        this.config = config;
    }

    public static void main(String[] args) throws Exception {
        AllConfig config = AllConfig.build(args);
        if (config != null) {
            new AllItemSimilarities(config).call();
        }
    }

    @Override
    public Object call() throws InterruptedException, NotReadyException, ExecutionException {
        final ServerRecommender recommender = new ServerRecommender(this.config.getLocalInputDir());
        recommender.await();
        final RescorerProvider rescorerProvider = this.config.getRescorerProvider();
        final int howMany = this.config.getHowMany();
        Processor<Long> processor = new Processor<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void process(Long itemID, long count) throws ExecutionException {
                List similar;
                Rescorer rescorer = rescorerProvider == null ? null : rescorerProvider.getMostSimilarItemsRescorer((MyrrixRecommender)recommender, new String[0]);
                try {
                    similar = recommender.mostSimilarItems(new long[]{itemID}, howMany, rescorer);
                }
                catch (TasteException te) {
                    throw new ExecutionException(te);
                }
                PrintStream printStream = System.out;
                synchronized (printStream) {
                    System.out.println(Long.toString(itemID));
                    StringBuilder line = new StringBuilder(30);
                    for (RecommendedItem sim : similar) {
                        line.setLength(0);
                        line.append(Long.toString(sim.getItemID())).append(',').append(Float.toString(sim.getValue()));
                        System.out.println(line);
                    }
                }
            }
        };
        new Paralleler((Iterator)recommender.getAllItemIDs().iterator(), (Processor)processor, "AllItemSimilarities").runInParallel();
        return null;
    }
}

